package de.z0rdak.yawp.mixin.flag.mobgrief;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.core.flag.RegionFlag.MOB_GRIEFING;
import static de.z0rdak.yawp.handler.HandlerUtil.processCheck;

@Mixin(class_2302.class)
public class CropBlockMixin {

    @Inject(method = "entityInside", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/level/ServerLevel;destroyBlock(Lnet/minecraft/core/BlockPos;ZLnet/minecraft/world/entity/Entity;)Z"), cancellable = true, allow = 1)
    public void onEntityCollision(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity, CallbackInfo ci) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(pos, MOB_GRIEFING, world.method_27983(), null);
        if (Services.EVENT.post(checkEvent))
            return;
        processCheck(checkEvent, deny -> ci.cancel());
    }

    /*
    @Inject(method = "growCrops", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onCropGrow(Level level, BlockPos blockPos, BlockState blockState, CallbackInfo ci) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, CROP_TICK, level.dimension());
        if (Services.EVENT.post(checkEvent))
            return;
        processCheck(checkEvent, deny -> ci.cancel());
    }
     */


}
