package de.z0rdak.yawp.mixin.flag.mobgrief;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1308;
import net.minecraft.class_1345;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.core.flag.RegionFlag.MOB_GRIEFING;
import static de.z0rdak.yawp.handler.HandlerUtil.processCheck;

@Mixin(class_1345.class)
public class EatBlockGoalMixin {
    @Final
    @Shadow
    private class_1308 mob;

    @Final
    @Shadow
    private class_1937 level;

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;destroyBlock(Lnet/minecraft/core/BlockPos;Z)Z"), cancellable = true, allow = 1)
    void onEatGrass(CallbackInfo ci) {
        class_2338 blockPos = mob.method_24515();
        FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, MOB_GRIEFING, level.method_27983());
        if (Services.EVENT.post(checkEvent))
            return;
        processCheck(checkEvent, deny -> {
            // mob.onEatingGrass();
            ci.cancel();
        });
    }

    @Inject(method = "tick()V", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;levelEvent(ILnet/minecraft/core/BlockPos;I)V"), cancellable = true, allow = 1)
    void onEatGrassBlock(CallbackInfo ci) {
        class_2338 blockPos = mob.method_24515().method_10074();
        FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, MOB_GRIEFING, level.method_27983());
        if (Services.EVENT.post(checkEvent))
            return;
        processCheck(checkEvent, deny -> {
            // mob.onEatingGrass();  
            ci.cancel();
        });
    }
}
