package de.z0rdak.yawp.mixin.flag.mobgrief;

import de.z0rdak.yawp.handler.HandlerUtil;
import net.minecraft.class_4019;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_4019.class_4025.class)
public class FoxEatBerriesGoalMixin {
    @Unique
    private class_4019 fox;

    // Remember the outer class instance
    @Inject(method = "<init>", at = @At("TAIL"))
    private void onConstructor(class_4019 fox, double speed, int range, int maxYDifference, CallbackInfo ci) {
        this.fox = fox;
    }

    @Inject(method = "onReachedTarget", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onEatBerries(CallbackInfo ci) {
        HandlerUtil.checkMobGrief(fox, ci);
    }
}
