package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import static de.z0rdak.yawp.core.flag.RegionFlag.PLACE_FLUIDS;
import static de.z0rdak.yawp.core.flag.RegionFlag.SCOOP_FLUIDS;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_1755.class)
public abstract class BucketItemMixin {

    @Inject(method = "use", locals = LocalCapture.CAPTURE_FAILSOFT,
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;getBlockState(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal = 0), cancellable = true, allow = 1)
    public void onFillBucket(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1269> cir, class_1799 itemStack, class_3965 blockHitResult, class_2338 blockPos, class_2350 direction, class_2338 blockPos2) {
        if (isServerSide(world)) {
            if (user != null) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, SCOOP_FLUIDS, getDimKey(world), user);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    cir.setReturnValue(class_1269.field_5814);
                });
            }
        }
    }

    @Inject(method = "use", locals = LocalCapture.CAPTURE_FAILSOFT,
            at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/BucketItem;emptyContents(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/BlockHitResult;)Z"), cancellable = true, allow = 1)
    public void onEmptyBucket(class_1937 world, class_1657 user, class_1268 hand, CallbackInfoReturnable<class_1269> cir, class_1799 itemStack, class_3965 blockHitResult, class_2338 blockPos, class_2350 direction, class_2338 blockPos2, class_2680 blockState, class_2338 blockPos3) {
        if (isServerSide(world)) {
            if (user != null) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos3, PLACE_FLUIDS, getDimKey(world), user);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    cir.setReturnValue(class_1269.field_5814);
                });
            }
        }
    }
}