package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.handler.HandlerUtil.*;

@Mixin({class_1657.class})
public abstract class PlayerEntityMixin {
    
    @Inject(method = "tryToStartFallFlying()Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;startFallFlying()V"), allow = 1, cancellable = true)
    void injectElytraCheck(CallbackInfoReturnable<Boolean> cir) {
        class_1657 self = (class_1657) (Object) this;
        if (isServerSide(self.method_37908())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.USE_ELYTRA, getDimKey(self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, denyResult -> cir.setReturnValue(false));
        }
    }

    @Inject(method = "dropEquipment", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    void onDropEquipment(class_3218 level, CallbackInfo ci) {
        class_1657 self = (class_1657) (Object) this;
        if (isServerSide(self.method_37908())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.KEEP_INV, getDimKey(self));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            processCheck(checkEvent, denyResult -> ci.cancel());
        }
    }

    @Inject(method = "causeFoodExhaustion", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/food/FoodData;addExhaustion(F)V"), cancellable = true, allow = 1)
    public void onGainHunger(float exhaustion, CallbackInfo ci) {
        class_1657 self = (class_1657) (Object) this;
        if (isServerSide(self)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), RegionFlag.NO_HUNGER, getDimKey(self), self);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagState flagState = processCheck(checkEvent,
                    deny -> { /* player has no permission -> do nothing to apply hunger */ }
            );
            if (flagState == FlagState.ALLOWED) {
                ci.cancel();
            }            
        }
    }

}
