package de.z0rdak.yawp.platform.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.config.server.PermissionConfig;
import de.z0rdak.yawp.platform.services.config.IPermissionConfigHelper;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2168;

public class FabricPermissionConfigHelper implements IPermissionConfigHelper {

    @Override
    public boolean isCommandBlockExecutionAllowed() {
        return PermissionConfig.isCommandBlockExecutionAllowed();
    }

    @Override
    public boolean isHierarchyOwnershipEnabled() {
        return PermissionConfig.isHierarchyOwnershipEnabled();
    }

    @Override
    public Set<String> UUIDsWithPermission() {
        return PermissionConfig.UUIDsWithPermission();
    }

    @Override
    public boolean isCmdEnabledForNonOp() {
        return PermissionConfig.isCmdEnabledForNonOp();
    }

    @Override
    public int getRequiredOpLevel() {
        return PermissionConfig.getRequiredOpLevel();
    }

    @Override
    public boolean byPassFlagAllowed() {
        return PermissionConfig.byPassFlagAllowed();
    }

    @Override
    public boolean hasConfigPermission(class_1657 player) {
        return PermissionConfig.hasConfigPermission(player);
    }

    @Override
    public boolean hasConfigPermission(class_2168 src, CommandSourceType srcType) throws CommandSyntaxException {
        return PermissionConfig.hasConfigPermission(src, srcType);
    }

    @Override
    public boolean isReadOnlyAllowed() {
        return PermissionConfig.isReadOnlyAllowed();
    }

    @Override
    public boolean allowRegionTp() {
        return PermissionConfig.allowRegionTp();
    }
}