package de.z0rdak.yawp.util;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.flag.FlagMessage;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.util.text.Messages;
import org.apache.commons.lang3.NotImplementedException;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

import static de.z0rdak.yawp.api.commands.CommandConstants.*;
import static de.z0rdak.yawp.api.commands.Commands.*;
import static de.z0rdak.yawp.handler.HandlerUtil.getFlagMapRecursive;
import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.*;
import static net.minecraft.class_124.*;
import static net.minecraft.class_2558.class_2559.*;

public class ChatLinkBuilder {

    private ChatLinkBuilder() {
    }

    /***
     * [X,Y,Z], ..., [X,Y,Z]
     */
    public static class_5250 buildAreaMarkedBlocksTpLinks(IMarkableRegion region) {
        List<class_5250> tpLinks = region.getArea().markedBlocks().stream().map(pos -> buildDimensionalBlockTpLink(region.getDim(), pos)).collect(Collectors.toList());
        class_5250 blockPosTpLinkList = class_2561.method_43470("");
        tpLinks.forEach(tpLink -> blockPosTpLinkList.method_10852(tpLink).method_27693(" "));
        return blockPosTpLinkList;
    }
    
    public static class_5250 buildRegionAreaExpandLink(IMarkableRegion region) {
        // [<=expand=>] [<=max=>]
        class_5250 linkText = class_2561.method_48321("cli.msg.info.region.area.area.expand.link.text", "<=expand=>");
        class_5250 linkHover = class_2561.method_48322("cli.msg.info.region.area.area.expand.link.hover", "Expand the area for '%s'", region.getName());
        String expandCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), AREA.toString(), EXPAND.toString(), region.getArea().getAreaType().areaType);
        switch (region.getArea().getAreaType()) {
            case CUBOID: {
                CuboidArea cuboidArea = (CuboidArea) region.getArea();
                int areaLowerLimit = cuboidArea.getArea().method_35416();
                int areaUpperLimit = cuboidArea.getArea().method_35419();
                // [<=expand=>]
                String expandCmdSuggestion = appendSubCommand(expandCmd, String.valueOf(areaLowerLimit), String.valueOf(areaUpperLimit));
                class_5250 expandLink = buildExecuteCmdComponent(linkText, linkHover, expandCmdSuggestion, field_11745, LINK_COLOR);
                // [<=max=>]
                class_5250 maxExpandLinkText = class_2561.method_48321("cli.msg.info.region.area.area.expand-max.link.text", "<=max=>");
                class_5250 maxExpandLinkHover = class_2561.method_48321("cli.msg.info.region.area.area.expand-max.link.hover", "Expand area to build limit");
                String maxExpandCmd = appendSubCommand(expandCmd, String.valueOf(Constants.MIN_BUILD_LIMIT), String.valueOf(Constants.MAX_BUILD_LIMIT));
                class_5250 maxExpandLink = buildExecuteCmdComponent(maxExpandLinkText, maxExpandLinkHover, maxExpandCmd, field_11750, LINK_COLOR);
                return Messages.substitutable("%s %s", expandLink, maxExpandLink);
            }
            case CYLINDER:
                throw new NotImplementedException("cylinder");
            case SPHERE:
                // [<=expand=>]
                String expandCmdSuggestion = appendSubCommand(expandCmd, String.valueOf(1));
                return buildExecuteCmdComponent(linkText, linkHover, expandCmdSuggestion, field_11745, LINK_COLOR);
            case POLYGON_3D:
                throw new NotImplementedException("polygon");
            case PRISM:
                throw new NotImplementedException("prism");
            default:
                throw new IllegalArgumentException("Invalid area type");
        }
    }

    private static class_5250 buildShowAreaToggleLink(IMarkableRegion region) {
        class_5250 showAreaLinkText = class_2561.method_48321("cli.msg.info.region.area.area.show.link", "Show");
        class_5250 showAreaLinkHover = class_2561.method_48322("cli.msg.info.region.area.area.show.hover", "Toggle visible bounding box of '%s'", region.getName());
        String showAreaCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), AREA.toString(), "show");
        return buildExecuteCmdComponent(showAreaLinkText, showAreaLinkHover, showAreaCmd, field_11750, LINK_COLOR);
    }

    /**
     * [set area]
     */
    public static class_5250 buildAreaUpdateLink(IMarkableRegion region) {
        class_5250 setAreaLinkText = class_2561.method_48321("cli.msg.info.region.area.area.set.link", "set area");
        class_5250 setAreaLinkHover = class_2561.method_48322("cli.msg.info.region.area.area.set.hover", "Update area of region '%s'", region.getName());
        String blocks = String.join(" ", region.getArea().markedBlocks().stream().map(ChatComponentBuilder::buildBlockCoordinateStr).collect(Collectors.toSet()));
        String setAreaCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), AREA.toString(), SET.toString(), region.getArea().getAreaType().areaType, blocks);
        return buildExecuteCmdComponent(setAreaLinkText, setAreaLinkHover, setAreaCmd, field_11745, LINK_COLOR);
    }
    
    public static class_5250 buildRegionAreaActionLinks(IMarkableRegion region) {
        // [set area] [set TP] [show area] [<=expand=>] [<=max=>]
        return Messages.substitutable("%s %s %s", buildAreaUpdateLink(region), buildRegionSetTpLink(region), buildRegionAreaExpandLink(region));
        // buildShowAreaToggleLink(region)
    }

    public static class_5250 buildWikiLink() {
        class_5250 wikiLinkHover = class_2561.method_48321("help.tooltip.wiki.link.hover", "https://github.com/Z0rdak/Yet-Another-Level-Protector/wiki");
        class_5250 wikiLink = class_2561.method_48321("help.tooltip.wiki.link.text", "Open Wiki in default browser");
        return buildExecuteCmdComponent(wikiLink, wikiLinkHover, "https://github.com/Z0rdak/Yet-Another-World-Protector/wiki", field_11749, field_1075);
    }

    public static class_5250 buildRegionInfoLink(IProtectedRegion region) {
        return buildRegionInfoLink(region, class_2561.method_48322("cli.msg.info.region.link.hover", "Show region info for %s", region.getName()));
    }

    public static class_5250 buildRegionInfoLink(IProtectedRegion region, class_5250 linkText, class_5250 hoverText) {
        String cmd = Commands.buildRegionInfoCmd(region);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, LINK_COLOR);
    }

    public static class_5250 buildRegionInfoLink(IProtectedRegion region, class_5250 hoverText) {
        class_5250 linkText = class_2561.method_43470(region.getName());
        return buildRegionInfoLink(region, linkText, hoverText);
    }

    public static class_5250 buildRegionAreaLink(IMarkableRegion region) {
        String showSpatialPropLink = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), AREA.toString());
        class_5250 spatialPropLinkText = class_2561.method_48321("cli.msg.info.region.area.link.text", "Area Properties");
        class_5250 spatialPropHoverText = class_2561.method_48322("cli.msg.info.region.area.link.hover", "Show region area properties for %s", region.getName());
        return buildExecuteCmdComponent(spatialPropLinkText, spatialPropHoverText, showSpatialPropLink, field_11750, LINK_COLOR);
    }

    public static class_5250 buildGroupLink(IProtectedRegion region, String group, int groupSize) {
        class_5250 linkText = class_2561.method_48322("cli.msg.info.region.group.list.link.text", "%s %s(s)", groupSize, group);
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.group.list.link.hover", "List '%s' for region %s", group, region.getName());
        String cmd = Commands.buildListGroupCommand(region, group);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, LINK_COLOR);
    }

    /**
     * Players: [n player(s)] [+]
     */
    public static class_5250 buildPlayerListLink(IProtectedRegion region, PlayerContainer players, String group) {
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.group.player.list.link.hover", "List players of group '%s' in region %s", group, region.getName());
        class_5250 linkText = class_2561.method_48322("cli.msg.info.region.group.player.list.link.text", "%s player(s)", players.getPlayers().size());
        String cmd = Commands.buildListGroupMemberCommand(region, group, GroupType.PLAYER);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, LINK_COLOR);
    }

    /**
     * Teams: [n team(s)] [+]
     */
    public static class_5250 buildTeamListLink(IProtectedRegion region, PlayerContainer teams, String group) {
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.group.team.list.link.hover", "List teams of group '%s' in region %s", group, region.getName());
        class_5250 linkText = class_2561.method_48322("cli.msg.info.region.group.team.list.link.text", "%s team(s)", teams.getTeams().size());
        String cmd = Commands.buildListGroupMemberCommand(region, group, GroupType.TEAM);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, LINK_COLOR);
    }

    public static class_5250 buildAddToGroupLink(IProtectedRegion region, String group, GroupType groupType) {
        class_5250 linkText = class_2561.method_48321("cli.link.add", "+");
        String fallback = "Add " + groupType.name + " as '%s' to region %s";
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.group." + groupType.name + ".add.link.hover", fallback, group, region.getName());
        String cmd = buildAddGroupMemberCommand(region, groupType, group, ""); // "" for blank (suggestion)
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11745, LINK_COLOR);
    }

    public static class_5250 buildGroupTeamListLink(IProtectedRegion region, String group) {
        // Teams: [n team(s)] [+]
        PlayerContainer playerContainer = region.getGroup(group);
        class_5250 teamAddLink = buildAddToGroupLink(region, group, GroupType.TEAM);
        class_5250 teamListLink = playerContainer.hasTeams() ? buildTeamListLink(region, playerContainer, group) : class_2561.method_48322("cli.msg.info.region.group.team.list.link.text", "%s team(s)", playerContainer.getTeams().size());
        return Messages.substitutable("%s: %s %s", class_2561.method_48321("cli.msg.info.region.group.team", "Teams"), teamListLink, teamAddLink);
    }

    public static class_5250 buildGroupPlayerListLink(IProtectedRegion region, String group) {
        // Players: [n player(s)] [+]
        PlayerContainer playerContainer = region.getGroup(group);
        class_5250 playersAddLink = buildAddToGroupLink(region, group, GroupType.PLAYER);
        class_5250 playerListLink = playerContainer.hasPlayers() ? buildPlayerListLink(region, playerContainer, group) : class_2561.method_48322("cli.msg.info.region.group.player.list.link.text", "%s player(s)", playerContainer.getPlayers().size());
        return Messages.substitutable("%s: %s %s", class_2561.method_48321("cli.msg.info.region.group.player", "Players"), playerListLink, playersAddLink);
    }

    /**
     * Creates a TextComponent for displaying the flag info  <br>
     * Text: [$flag-name] <br>
     * Link: /wp flag dim $dim $flag-name info  <br>
     *
     * @param region involved in creating command link for
     * @param flag   involved in creating command link for
     * @return TextComponent [$flag-name] with a link for the flag info
     */
    public static class_5250 buildFlagInfoLink(IProtectedRegion region, IFlag flag, class_124 linkColor) {
        class_5250 text = class_2561.method_43470(flag.getName());
        class_5250 hoverText = class_2561.method_48322("cli.flag.info.hover", "Show %s flag info of region '%s'", flag.getName(), region.getName());
        return buildFlagInfoLink(region, flag, text, hoverText, linkColor);
    }

    public static class_5250 buildFlagInfoLink(IProtectedRegion region, IFlag flag, class_5250 text, class_5250 hoverText, class_124 linkColor) {
        String cmd = Commands.buildFlagInfoCmd(region, flag.getName());
        return buildExecuteCmdComponent(text, hoverText, cmd, field_11750, linkColor);
    }

    public static class_5250 buildFlagInfoLink(IProtectedRegion region, IFlag flag) {
        return buildFlagInfoLink(region, flag, LINK_COLOR);
    }

    public static class_5250 buildFlagStateSuggestionLink(IProtectedRegion region, IFlag flag) {
        class_5250 hover = class_2561.method_48322("cli.flag.state.set.link.hover", "Set flag state for '%s' in '%s'", flag.getName(), region.getName());
        class_5250 text = class_2561.method_48321("cli.flag.state.set.link.text", "s");
        String cmd = buildFlagSuggestStateCmd(region, flag.getName());
        return buildExecuteCmdComponent(text, hover, cmd, field_11745, LINK_COLOR);
    }

    public static class_5250 buildFlagOverrideToggleLink(IProtectedRegion region, IFlag flag, boolean shortLink) {
        String fallback = flag.doesOverride() ? "active" : "inactive";
        String fallbackHover = (flag.doesOverride() ? "Disable" : "Enable") + " flag override for '%s' of '%s'";
        class_5250 linkText = class_2561.method_48321("cli.flag.override.link.text." + flag.doesOverride(), fallback);
        class_5250 hoverText = class_2561.method_48322("cli.flag.override.link.hover." + flag.doesOverride(), fallbackHover, flag.getName(), region.getName());
        if (shortLink) {
            linkText = class_2561.method_48321("cli.flag.override.link.Component.toggle", "o");
        }
        class_124 color = flag.doesOverride() ? field_1060 : field_1080;
        String cmd = buildFlagOverrideToggleCmd(region, flag.getName());
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, color);
    }

    public static class_5250 buildFlagMessageEditLink(IProtectedRegion region, IFlag flag) {
        class_5250 hover = class_2561.method_48322("cli.flag.msg.Component.set.link.hover", "Change the message shown when the flag '%s' of '%s' is triggered", flag.getName(), region.getName());
        class_5250 text = class_2561.method_48321("cli.flag.msg.Component.set.link.text", "Edit");
        String msg = "\"" + flag.getFlagMsg().msg() + "\"";
        String cmd = buildFlagMsgSetCmd(region, flag.getName(), msg);
        return buildExecuteCmdComponent(text, hover, cmd, field_11745, LINK_COLOR);
    }

    public static class_5250 buildFlagMessageClearLink(IProtectedRegion region, IFlag flag) {
        class_5250 hover = class_2561.method_48322("cli.flag.msg.Component.set.default", "Reset flag message for flag '%s' of '%s' to config default", flag.getName(), region.getName());
        class_5250 text = class_2561.method_48321("cli.link.remove", "x");
        String cmd = buildFlagMsgClearCmd(region, flag.getName());
        return buildExecuteCmdComponent(text, hover, cmd, field_11750, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildFlagMuteToggleLink(IProtectedRegion region, IFlag flag, boolean shortLink) {
        String fallback = !flag.getFlagMsg().isMuted() ? "inactive" : "active";
        class_5250 hover = class_2561.method_48322("cli.flag.msg.mute.set.link.hover", "Activate flag alert for '%s' in '%s'", flag.getName(), region.getName());
        class_5250 text = class_2561.method_48321("cli.flag.msg.mute.set.link.text." + !flag.getFlagMsg().isMuted(), fallback);
        if (shortLink) {
            text = class_2561.method_48321("cli.flag.msg.mute.set.link.Component.toggle", "m");
        }
        class_124 textChatFormatting = !flag.getFlagMsg().isMuted() ? field_1060 : field_1080;
        String cmd = buildFlagMsgMuteToggleCmd(region, flag.getName());
        return buildExecuteCmdComponent(text, hover, cmd, field_11750, textChatFormatting);
    }

    /**
     * Builds a TextComponent for the given flag and region. <br>
     * Currently not used in the CLI for obvious reasons. <br>
     */
    public static class_5250 buildRemoveAllRegionsAttemptLink(DimensionRegionCache dimCache) {
        String cmd = buildCommandStr(DIM.toString(), dimCache.getDimensionalRegion().getName(), DELETE_ALL.toString(), REGIONS.toString());
        class_5250 hover = class_2561.method_48322("cli.msg.info.dim.region.remove.all.link.hover", "Remove all regions from %s", dimCache.getDimensionalRegion().getName());
        class_5250 text = class_2561.method_48321("cli.link.remove", "x");
        return buildExecuteCmdComponent(text, hover, cmd, field_11750, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRemoveAllRegionsLink(DimensionRegionCache dimCache) {
        String cmd = buildCommandStr(DIM.toString(), dimCache.getDimensionalRegion().getName(), DELETE_ALL.toString(), REGIONS.toString(), FOREVER.toString(), SERIOUSLY.toString());
        class_5250 hover = class_2561.method_48322("cli.msg.info.dim.region.remove.all.link.hover", "Remove all regions from %s", dimCache.getDimensionalRegion().getName());
        class_5250 text = class_2561.method_48321("cli.link.remove", "x");
        return buildExecuteCmdComponent(text, hover, cmd, field_11750, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRemoveRegionLink(IProtectedRegion region) {
        String cmd = buildCommandStr(DIM.toString(), region.getDim().method_29177().toString(), DELETE.toString(), region.getName(), "-y");
        class_5250 hover = class_2561.method_48322("cli.msg.info.dim.region.remove.link.hover", "Remove region %s", region.getName());
        class_5250 text = class_2561.method_48321("cli.link.remove", "x");
        return buildExecuteCmdComponent(text, hover, cmd, field_11750, REMOVE_CMD_COLOR);
    }

    // [x]
    public static class_5250 buildParentClearLink(IMarkableRegion region) {
        String clearRegionParentCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), PARENT.toString(), REMOVE.toString());
        class_5250 parentClearLinkText = class_2561.method_48321("cli.link.remove", "x");
        class_5250 parentClearHoverText = class_2561.method_48322("cli.msg.info.region.parent.clear.link.hover", "Clear '%s' as parent region", region.getParent().getName());
        return buildExecuteCmdComponent(parentClearLinkText, parentClearHoverText, clearRegionParentCmd, field_11750, REMOVE_CMD_COLOR);
    }

    // No parent set [+]
    private static class_5250 createParentAddLink(IProtectedRegion region) {
        String setRegionParentCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), PARENT.toString(), SET.toString(), "");
        class_5250 setParentLinkText = class_2561.method_48321("cli.link.add", "+");
        class_5250 setParentHoverText = class_2561.method_48322("cli.msg.info.region.parent.set.link.hover", "Set parent for region %s", region.getName());
        return Messages.substitutable("%s %s", class_2561.method_48321("cli.msg.info.region.parent.null", "No parent set"), buildExecuteCmdComponent(setParentLinkText, setParentHoverText, setRegionParentCmd, field_11750, field_1060));
    }

    // [n regions] [+]
    public static class_5250 buildDimRegionsLink(DimensionRegionCache dimCache) {
        DimensionalRegion dimRegion = dimCache.getDimensionalRegion();
        String command = buildCommandStr(DIM.toString(), dimRegion.getDim().method_29177().toString(), LIST.toString(), CommandConstants.LOCAL.toString());
        class_5250 text = class_2561.method_48322("cli.msg.dim.info.region.list.link.text", "%s region(s)", dimCache.getRegionCount());
        class_5250 hover = class_2561.method_48322("cli.msg.dim.info.region.list.link.hover", "List regions in %s", dimRegion.getName());
        class_5250 listLocalRegionsLink = buildExecuteCmdComponent(text, hover, command, field_11750, LINK_COLOR);
        class_5250 createRegionLink = buildDimCreateRegionLink(dimRegion);
        if (dimRegion.getChildren().isEmpty()) {
            return Messages.substitutable("%s %s", text, createRegionLink);
        }
        return Messages.substitutable("%s %s", listLocalRegionsLink, createRegionLink);
    }

    public static class_5250 buildRegionListChildrenLink(IProtectedRegion region) {
        class_5250 text = class_2561.method_48322("cli.msg.info.region.children.list.link.text", "%s child regions(s)", region.getChildren().size());
        class_5250 hover = class_2561.method_48322("cli.msg.info.region.children.list.link.hover", "List direct child regions of '%s'", region.getName());
        String command = Commands.buildListChildRegionCommand(region);
        return switch (region.getRegionType()) {
            case GLOBAL -> {
                // [n dimensions(s)]
                Collection<String> dimensionList = RegionDataManager.get().getDimensionList();
                class_5250 listDimRegionsLinkText = class_2561.method_48322("cli.msg.global.info.region.list.link.text", "%s dimensions(s)", dimensionList.size());
                class_5250 listDimRegionsHoverText = class_2561.method_48321("cli.msg.global.info.region.list.link.hover", "List all Dimensional Regions");
                yield buildExecuteCmdComponent(listDimRegionsLinkText, listDimRegionsHoverText, command, field_11750, LINK_COLOR);
            }
            case DIMENSION -> {
                // [n children] [+]
                class_5250 listDimRegionsListLink = buildExecuteCmdComponent(text, hover, command, field_11750, LINK_COLOR);
                if (region.getChildren().isEmpty()) {
                    yield Messages.substitutable("%s %s", text, buildDimCreateRegionLink(region));
                }
                yield Messages.substitutable("%s %s", listDimRegionsListLink, buildDimCreateRegionLink(region));
            }
            case LOCAL -> {
                // [n children] [+]
                class_5250 regionChildrenLink = buildExecuteCmdComponent(text, hover, command, field_11750, LINK_COLOR);
                class_5250 addChildrenLink = buildRegionAddChildrenLink(region);
                if (region.getChildren().isEmpty()) {
                    yield Messages.substitutable("%s %s", text, addChildrenLink);
                }
                yield Messages.substitutable("%s %s", regionChildrenLink, addChildrenLink);
            }
            default -> throw new IllegalStateException("Unexpected value: " + region.getRegionType());
        };
    }

    public static class_5250 buildRegionAddChildrenLink(IProtectedRegion region) {
        String addChildrenCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), ADD.toString(), CHILD.toString(), "");
        class_5250 addChildrenLinkText = class_2561.method_48321("cli.link.add", "+");
        class_5250 addChildrenHoverText = class_2561.method_48322("cli.msg.info.region.children.add.link.hover", "Add child to region %s", region.getName());
        return buildExecuteCmdComponent(addChildrenLinkText, addChildrenHoverText, addChildrenCmd, field_11745, ADD_CMD_COLOR);
    }

    public static class_5250 buildDimCreateRegionLink(IProtectedRegion region) {
        String dimCreateRegionCmd = buildCommandStr(DIM.toString(), region.getDim().method_29177().toString(), CREATE.toString(), CommandConstants.LOCAL.toString(), "");
        class_5250 createRegionLinkText = class_2561.method_48321("cli.link.add", "+");
        class_5250 createRegionHoverText = class_2561.method_48322("cli.msg.dim.info.region.create.link.hover", "Create region in dimension %s", region.getName());
        return buildExecuteCmdComponent(createRegionLinkText, createRegionHoverText, dimCreateRegionCmd, field_11745, ADD_CMD_COLOR);
    }

    /**
     * [n] responsible flag(s) | [m] flag(s) [+]
     * With the responsible flags being the applied flags for this region, including the parent flags
     * and the later are only the flags defined in this region, whether they are applied, active or not
     *
     * @param region the to build the flag list link component for
     * @return [n] responsible flag(s) | [m] flag(s) [+]
     */
    public static class_5250 buildResponsibleFlagListLink(IProtectedRegion region) {
        Map<String, FlagMessage.FlagCorrelation> flagsInHierarchy = getFlagMapRecursive(region, null);
        class_5250 responsibleFlagsNumber = buildTextWithHoverMsg(Messages.substitutable("%s", flagsInHierarchy.size()), class_2561.method_48322("cli.msg.info.region.flag.responsible.number.hover", "%s responsible flag(s) applicable for %s", flagsInHierarchy.size(), region.getName()), LINK_COLOR);
        class_5250 responsibleFlagListHoverText = class_2561.method_48322("cli.msg.info.region.flag.responsible.link.hover", "Show responsible region flags for %s", region.getName());
        String flagListCmd = buildListFlagsCommand(region);
        class_5250 responsibleFlagListLink = buildExecuteCmdComponent(responsibleFlagsNumber, responsibleFlagListHoverText, flagListCmd, field_11750, LINK_COLOR);
        class_5250 responsibleFlagsComp = flagsInHierarchy.isEmpty() ? responsibleFlagsNumber : responsibleFlagListLink;
        return class_2561.method_48322("cli.msg.info.region.flag.responsible.link.text", "%s responsible flag(s)", responsibleFlagsComp);
    }

    // [m] flag(s) [+]
    public static class_5250 buildRegionFlagListLink(IProtectedRegion region) {
        class_5250 regionFlagNumber = buildTextWithHoverMsg(Messages.substitutable("%s", region.getFlags().size()), class_2561.method_48322("cli.msg.info.region.flag.number.hover", "%s flag(s)", region.getFlags().size(), region.getName()), LINK_COLOR);
        class_5250 flagListHoverText = class_2561.method_48322("cli.msg.info.region.flag.link.hover", "%s flag(s)", region.getName());
        String regionFlagListCmd = buildListRegionFlagsCommand(region);
        class_5250 regionFlagListLink = buildExecuteCmdComponent(regionFlagNumber, flagListHoverText, regionFlagListCmd, field_11750, LINK_COLOR);
        class_5250 regionFlagsComp = region.getFlags().isEmpty() ? regionFlagNumber : regionFlagListLink;
        return Messages.substitutable("%s %s", class_2561.method_48322("cli.msg.info.region.flag.region.link.text", "%s flag(s)", regionFlagsComp), buildSuggestAddFlagLink(region));
    }

    public static class_5250 buildSuggestAddFlagLink(IProtectedRegion region) {
        return buildAddFlagLink(region, "", field_11745);
    }

    public static class_5250 buildAddFlagLink(IProtectedRegion region, String flag) {
        return buildAddFlagLink(region, flag, field_11750);
    }

    public static class_5250 buildAddFlagLink(IProtectedRegion region, String flag, class_2558.class_2559 action) {
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.flag.add.link.hover", "Add new flag to region %s", region.getName());
        class_5250 linkText = class_2561.method_48321("cli.link.add", "+");
        String cmd = buildAddFlagCommand(region, flag);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, action, ADD_CMD_COLOR);
    }

    /**
     * [X,Y,Z]
     */
    public static class_5250 buildDimensionalBlockTpLink(class_5321<class_1937> dim, class_2338 target) {
        String teleportCmd = buildTeleportCmd(dim, "@s", target);
        class_5250 text = class_2561.method_48322("cli.msg.info.region.area.tp.block.link.text", "%s", buildBlockPosLinkText(target));
        class_5250 hover = class_2561.method_48321("cli.msg.info.region.area.tp.block.link.hover", "Teleport to block");
        return buildExecuteCmdComponent(text, hover, teleportCmd, field_11750, TP_COLOR);
    }

    /**
     * [region] @ [X,Y,Z]
     */
    public static class_5250 buildRegionInfoAndTpLink(IMarkableRegion region) {
        return Messages.substitutable("%s @ %s", buildRegionInfoLink(region), buildRegionTeleportLink(region, null));
    }

    public static class_5250 buildRegionInfoAndTpLink(IMarkableRegion region, class_5250 regionInfoLinkWithIndicator) {
        return Messages.substitutable("%s @ %s", regionInfoLinkWithIndicator, buildRegionTeleportLink(region, null));
    }

    public static class_5250 buildRegionTeleportLink(IMarkableRegion region, class_1657 player) {
        String regionTpCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), AREA.toString(), TELEPORT.toString());
        if (player != null) {
            regionTpCmd = appendSubCommand(regionTpCmd, player.method_5820());
        }
        class_5250 text = class_2561.method_48322("cli.msg.info.region.area.tp.link.text", "%s", buildBlockPosLinkText(region.getTpTarget()));
        class_5250 hover = class_2561.method_48322("cli.msg.info.region.area.tp.link.hover", "Teleport to region '%s' in dimension '%s", region.getName(), region.getDim().method_29177().toString());
        return buildExecuteCmdComponent(text, hover, regionTpCmd, field_11750, TP_COLOR);
    }

    public static class_5250 buildRegionSetTpLink(IMarkableRegion region) {
        String setTpPosCmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), AREA.toString(), TELEPORT.toString(), SET.toString(), "");
        class_5250 linkText = class_2561.method_48321("cli.msg.info.region.area.tp.set.link.text", "set TP");
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.area.tp.set.link.hover", "Set new teleport anchor for '%s'", region.getName());
        return buildExecuteCmdComponent(linkText, hoverText, setTpPosCmd, field_11745, LINK_COLOR);
    }

    public static class_5250 buildDimSuggestRegionRemovalLink(IMarkableRegion region) {
        String cmd = buildCommandStr(DIM.toString(), region.getDim().method_29177().toString(), DELETE.toString(), region.getName());
        class_5250 hover = class_2561.method_48322("cli.msg.info.dim.region.remove.link.hover", "Remove region %s", region.getName());
        class_5250 text = class_2561.method_48321("cli.link.remove", "x");
        return buildExecuteCmdComponent(text, hover, cmd, field_11745, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRegionRemoveChildLink(IProtectedRegion region, IProtectedRegion child) {
        String command = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), REMOVE.toString(), CHILD.toString(), child.getName());
        class_5250 linkText = class_2561.method_48321("cli.link.remove", "x");
        class_5250 linkHoverText = class_2561.method_48322("cli.msg.info.region.children.remove.link.hover", "Remove child '%s' from region %s", child.getName(), region.getName());
        return buildExecuteCmdComponent(linkText, linkHoverText, command, field_11745, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRegionActionUndoLink(String cmd, CommandConstants toReplace, CommandConstants replacement) {
        String revertCmd = ArgumentUtil.revertCommand(cmd, toReplace, replacement);
        class_5250 revertLinkText = class_2561.method_48321("cli.link.action.undo.text", "<-");
        class_5250 revertLinkHover = class_2561.method_48321("cli.link.action.undo.hover", "Undo action.");
        return buildExecuteCmdComponent(revertLinkText, revertLinkHover, revertCmd, field_11750, field_1079);
    }

    public static class_5250 buildRegionActionUndoLink(String cmd, String toReplace, String replacement) {
        String revertCmd = ArgumentUtil.revertCommand(cmd, toReplace, replacement);
        class_5250 revertLinkText = class_2561.method_48321("cli.link.action.undo.text", "<-");
        class_5250 revertLinkHover = class_2561.method_48321("cli.link.action.undo.hover", "Undo action.");
        return buildExecuteCmdComponent(revertLinkText, revertLinkHover, revertCmd, field_11750, field_1079);
    }

    // TODO: Combine from ChatComponentBuilder::buildRemoveGroupEntry
    public static class_5250 buildRemoveGroupMemberLink(IProtectedRegion region, String name, GroupType groupType, String group, class_5250 linkText, class_5250 hoverText) {
        String cmd = Commands.buildRemoveGroupMemberCommand(region, groupType, group, name);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRemoveLinkForOfflinePlayer(IProtectedRegion region, String name, GroupType groupType, String group, class_5250 linkText, class_5250 hoverText) {
        String cmd = buildRemoveOfflinePlayerCommand(region, group, groupType, name);
        return buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, REMOVE_CMD_COLOR);
    }
}
