package de.z0rdak.yawp.util;

import de.z0rdak.yawp.constants.serialization.ItemNbtKeys;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.stick.MarkerStick;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

import static net.minecraft.class_124.*;
import static net.minecraft.class_9334.field_49628;

public final class StickUtil {

    private static final String MARKED_BLOCK_INDICATOR = "X";
    private static final String UNMARKED_BLOCK_INDICATOR = "#";
    private static final String TP_POS_INDICATOR = "TP";
    private static final class_124 MARKED_BLOCK_COLOR = field_1060;
    private static final class_124 UNMARKED_BLOCK_COLOR = field_1061;
    private static final class_124 UNMARKED_POS_COLOR = field_1075;

    private StickUtil() {
    }

    /**
     * Set init (default) nbt value for sticks
     *
     * @param stick stick item
     * @param dim dimension tag to set for sticks
     */
    public static void initStickTag(class_1799 stick, class_5321<class_1937> dim, boolean reset) {
        class_9279 customData = stick.method_57824(field_49628);
        if (customData == null) {
            stick.method_57379(field_49628, class_9279.field_49302);
        }
        customData = stick.method_57824(field_49628);
        if (customData != null) {
            class_2487 customDataTag = customData.method_57461();
            if (!customDataTag.method_10545(ItemNbtKeys.STICK) || reset) {
                class_2487 compoundNBT = new MarkerStick(dim).serializeNBT();
                customDataTag.method_10566(ItemNbtKeys.STICK, compoundNBT);
                stick.method_57379(field_49628, class_9279.method_57456(customDataTag));
            }
        }
    }

    public static void initMarkerNbt(class_1799 stack, class_5321<class_1937> dim) {
        stack.method_7939(1);
        initStickTag(stack, dim, false);
        updateStickMetadata(stack);
    }

    public static void resetMarkerNbt(class_1799 stack, class_5321<class_1937> dim) {
        initStickTag(stack, dim, true);
        updateStickMetadata(stack);
    }

    private static void updateStickMetadata(class_1799 stack) {
        updateStickName(stack);
        stack.method_57379(class_9334.field_49632, buildToolTip());
        stack.method_57379(class_9334.field_49641, true);
    }


    public static boolean isMarker(class_1799 stack) {
        if (hasCustomDataTag(stack)) {
            class_9279 customData = stack.method_57824(field_49628);
            class_2487 compoundTag = customData.method_57461();
            return compoundTag.method_10545(ItemNbtKeys.STICK) && customData.method_57461().method_10580(ItemNbtKeys.STICK) != null;
        }
        return false;
    }

    @Nullable
    public static class_2487 getStickNBT(class_1799 stick) {
        if (stick.method_57824(field_49628).method_57461().method_10545(ItemNbtKeys.STICK)) {
            return (class_2487) stick.method_57824(field_49628).method_57461().method_10580(ItemNbtKeys.STICK);
        }
        return null;
    }

    @Nullable
    public static IMarkableArea getMarkedArea(class_1799 stick) {
        if (isMarker(stick)) {
            class_2487 stickNBT = StickUtil.getStickNBT(stick);
            if (stickNBT != null) {
                MarkerStick marker = new MarkerStick(stickNBT);
                if (!marker.isValidArea()) {
                    return null;
                }
                return LocalRegions.areaFrom(marker);
            }
        }
        return null;
    }

    public static void updateStickName(class_1799 stick) {
        class_2487 stickNBT = getStickNBT(stick);
        if (stickNBT != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            boolean isTpPosSet = marker.getTeleportPos() != null;
            class_5250 markerIndicators = buildRegionMarkerIndicators(marker)
                    .method_27693(" ")
                    .method_10852(buildTpPosIndicator(isTpPosSet));
            class_5250 markerHoverName = buildStickName(marker)
                    .method_27693(" ")
                    .method_10852(markerIndicators);
            stick.method_57379(class_9334.field_49631, markerHoverName);
        }      
    }

    private static class_5250 buildStickName(MarkerStick marker) {
        class_5250 stickName = class_2561.method_43470(marker.getStickType().stickName).method_27692(field_1065);
        class_5250 areaType = class_2561.method_43470(" (").method_27693(marker.getAreaType().areaType).method_27693(")");
        return stickName.method_10852(areaType);
    }

    /**
     * @param isMarked
     * @return [X] or [#]
     */
    private static class_5250 buildMarkerIndicator(boolean isMarked) {
        String indicator = isMarked ? MARKED_BLOCK_INDICATOR : UNMARKED_BLOCK_INDICATOR;
        class_124 color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_BLOCK_COLOR;
        class_5250 indicatorComp = class_2561.method_43470(indicator).method_27692(color);
        class_5250 closedResetComp = class_2561.method_43470("]").method_27692(field_1070);
        return class_2561.method_43470("[").method_10852(indicatorComp).method_10852(closedResetComp);
    }

    private static class_5250 buildTpPosIndicator(boolean isMarked) {
        class_124 color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_POS_COLOR;
        class_5250 indicatorComp = class_2561.method_43470(TP_POS_INDICATOR).method_27692(color);
        class_5250 closedResetComp = class_2561.method_43470("]").method_27692(field_1070);
        return class_2561.method_43470("[").method_10852(indicatorComp).method_10852(closedResetComp);
    }

    /**
     * RegionMarker [x][x] [TP]
     *
     * @param marker
     * @return
     */
    private static class_5250 buildRegionMarkerIndicators(MarkerStick marker) {
        class_5250 regionMarkerIndicators = class_2561.method_43470("");
        int maxBlocks = marker.getAreaType().maxBlocks;
        int amountUnmarked = maxBlocks - marker.getMarkedBlocks().size();
        for (int i = 0; i < marker.getMarkedBlocks().size(); i++) {
            regionMarkerIndicators.method_10852(buildMarkerIndicator(true));
        }
        for (int i = 0; i < amountUnmarked; i++) {
            regionMarkerIndicators.method_10852(buildMarkerIndicator(false));
        }
        return regionMarkerIndicators;
    }

    public static boolean hasCustomDataTag(class_1799 itemStack) {
        return itemStack.method_57824(field_49628) != null;
    }

    public static void setMarkerNbt(class_1799 itemStack, class_2487 markerTag) {
        if (hasCustomDataTag(itemStack)) {
            class_2487 compoundTag = itemStack.method_57824(field_49628).method_57461();
            compoundTag.method_10566(ItemNbtKeys.STICK, markerTag);
            itemStack.method_57379(field_49628, class_9279.method_57456(compoundTag));
        }       
    }


    private static class_9290 buildToolTip() {
        List<class_2561> lore = new ArrayList<>();
        lore.add(class_2561.method_48321("help.tooltip.stick.marker.simple.1", "Used to mark a new region."));
        lore.add(class_2561.method_48321("help.tooltip.stick.marker.simple.2", "Keep the Region Marker in your hand while creating a region!"));
        lore.add(class_2561.method_43470(field_1056 + "").method_10852(class_2561.method_48321("help.tooltip.stick.marker.simple.3", "Mark a (Cuboid) region by right-clicking the diagonal opposite corner blocks.")));
        lore.add(class_2561.method_43470(field_1056 + "").method_10852(class_2561.method_48321("help.tooltip.stick.marker.simple.4", "Set a region teleport position by shift-right-clicking a block.")));
        return new class_9290(lore);
    }
}
