package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public interface MultiLineMessage<T> {

    static <T> void send(class_2168 source, MultiLineMessage<T> message) {
        message.to(source);
    }

    static AreaInfoMessage areaInfo(IMarkableRegion region) {
        return new AreaInfoMessage(region);
    }

    static RegionInfoMessage regionInfo(IProtectedRegion region) {
        return new RegionInfoMessage(region);
    }

    static FlagDetailMessage flagDetail(IProtectedRegion region, IFlag flag) {
        return new FlagDetailMessage(region, flag);
    }

    static RegionStateMessage regionState(IProtectedRegion region) {
        return new RegionStateMessage(region);
    }

    List<class_2561> getLines();

    T getContent();

    default void to(class_2168 source) {
        this.getLines().forEach(source::method_45068);
    }
}
