package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.ChatLinkBuilder.*;
import static de.z0rdak.yawp.util.text.messages.multiline.RegionStateMessage.buildRegionStateLink;
import static net.minecraft.class_124.field_1065;

public class RegionInfoMessage implements MultiLineMessage<IProtectedRegion> {

    private final IProtectedRegion region;
    private final List<class_2561> regionInfoLines;

    public RegionInfoMessage(IProtectedRegion region) {
        this.region = region;
        this.regionInfoLines = new ArrayList<>();
    }

    private final static int MAX_ENCODER_LIMIT = 30000;
    
    public static class_5250 buildRegionOverviewHeader(IProtectedRegion region) {
        class_2487 regionNbt = region.serializeNBT();
        String nbtClipBoardText = regionNbt.method_47988() > MAX_ENCODER_LIMIT 
                ? "Sorry, region data is too big. I am working on a fix." 
                : class_2512.method_36117(regionNbt, true);
        switch (region.getRegionType()) {
            case GLOBAL: {
                class_5250 dumpLinkText = class_2561.method_48321("cli.msg.global.overview.header.dump.link.text", "Global overview");
                class_5250 dumpLinkHover = class_2561.method_48321("cli.msg.global.overview.header.dump.link.hover", "Copy Global Region NBT to clipboard");
                class_5250 clipBoardDumpLink = buildExecuteCmdComponent(dumpLinkText, dumpLinkHover, nbtClipBoardText, class_2558.class_2559.field_21462, field_1065);
                return buildHeader(class_2561.method_48322("cli.msg.info.header.for", "== %s for %s ==", clipBoardDumpLink, buildRegionInfoLink(region)));
            }
            case DIMENSION: {
                class_5250 dumpLinkText = class_2561.method_48321("cli.msg.dim.overview.header.dump.link.text", "Dimension overview");
                class_5250 dumpLinkHover = class_2561.method_48321("cli.msg.dim.overview.header.dump.link.hover", "Copy Dimensional Region NBT to clipboard");
                class_5250 clipBoardDumpLink = buildExecuteCmdComponent(dumpLinkText, dumpLinkHover, nbtClipBoardText, class_2558.class_2559.field_21462, field_1065);
                return buildHeader(class_2561.method_48322("cli.msg.info.header.for", "== %s for %s ==", clipBoardDumpLink, buildRegionInfoLink(region)));
            }
            case LOCAL: {
                class_5250 dumpLinkText = class_2561.method_48321("cli.msg.local.overview.header.dump.link.text", "Region overview");
                class_5250 dumpLinkHover = class_2561.method_48321("cli.msg.local.overview.header.dump.link.hover", "Copy Local Region NBT to clipboard");
                class_5250 clipBoardDumpLink = buildExecuteCmdComponent(dumpLinkText, dumpLinkHover, nbtClipBoardText, class_2558.class_2559.field_21462, field_1065);
                return buildHeader(class_2561.method_48322("cli.msg.info.header.for", "== %s for %s ==", clipBoardDumpLink, buildRegionInfoLink(region)));
            }
            default:
                throw new IllegalStateException("Unexpected value: " + region.getRegionType());
        }
    }

    public static class_5250 buildFlagsListLink(IProtectedRegion region) {
        if (region.getRegionType() == RegionType.GLOBAL) {
            return buildRegionFlagListLink(region);
        }
        return Messages.substitutable("%s | %s", buildResponsibleFlagListLink(region), buildRegionFlagListLink(region));
    }

    public static class_5250 buildGroupLinks(IProtectedRegion region) {
        return getGroupsForRegion(region).stream()
                .map(group -> buildGroupLink(region, group, getGroupSize(region, group)))
                .reduce(class_2561.method_43470(""), (link1, link2) -> link1.method_27693(" ").method_10852(link2));
    }

    private static class_5250 buildRegionHierarchyComponent(IProtectedRegion region) {
        class_5250 listChildrenLink = buildRegionListChildrenLink(region);
        switch (region.getRegionType()) {
            case GLOBAL: {
                // Dimensions: [n dimensions(s)]
                return buildInfoComponent("cli.msg.info.dimensions", "Dimensions", listChildrenLink);
            }
            case DIMENSION: {
                // Parent: [global], [n children], [n regions] [+]
                class_5250 globalRegionLink = buildRegionInfoLink(region.getParent(), class_2561.method_48321("cli.msg.info.region.global.link.hover", "Show global region info"));
                DimensionRegionCache dimCache = RegionDataManager.get().cacheFor(region.getDim());
                class_5250 hierarchyLinks = Messages.substitutable("%s, %s, %s", globalRegionLink, buildDimRegionsLink(dimCache), listChildrenLink);
                return buildInfoComponent("cli.msg.info.region.hierarchy", "Hierarchy", hierarchyLinks);
            }
            case LOCAL: {
                // Parent: [parent] [x], [n children] [+]
                class_5250 parentRemoveThisChildLink = buildRegionRemoveChildLink(region.getParent(), region);
                class_5250 hierarchyLinks = class_2561.method_43470("");
                if (region.getParent().getRegionType() == RegionType.DIMENSION) {
                    // don't show removal link, since it's not possible to remove the parent
                    hierarchyLinks = Messages.substitutable("%s, %s", buildRegionInfoLink(region.getParent()), listChildrenLink);
                }
                if (region.getParent().getRegionType() == RegionType.LOCAL) {
                    hierarchyLinks = Messages.substitutable("%s %s, %s", buildRegionInfoLink(region.getParent()), parentRemoveThisChildLink, listChildrenLink);
                }
                return buildInfoComponent("cli.msg.info.region.parent", "Parent", hierarchyLinks);
            }
            default:
                throw new IllegalStateException("Unexpected value: " + region.getRegionType());
        }
    }

    @Override
    public IProtectedRegion getContent() {
        return this.region;
    }

    @Override
    public List<class_2561> getLines() {
        // == Region [<name>] overview ==
        class_5250 header = buildRegionOverviewHeader(region);
        regionInfoLines.add(header);

        // Flags: [n] | [m] flag(s)] [+]
        class_5250 flagsText = buildInfoComponent("cli.msg.info.region.flag", "Flags", buildFlagsListLink(region));
        regionInfoLines.add(flagsText);

        if (region.getRegionType() == RegionType.LOCAL) {
            // Area: [Area]
            class_5250 areaText = buildInfoComponent("cli.msg.info.region.area", "Area", buildRegionAreaLink((IMarkableRegion) region));
            regionInfoLines.add(areaText);
        }

        // Groups: [owners], [members], [<listGroups>]
        class_5250 groupsText = buildInfoComponent("cli.msg.info.region.group", "Groups", buildGroupLinks(region));
        regionInfoLines.add(groupsText);

        // Regions: [global], [n children], [n regions][+],
        // Dimensions: [n dimensions(s)]
        // Parent: [parent][x], [n children][+]
        class_5250 hierarchy = buildRegionHierarchyComponent(region);
        regionInfoLines.add(hierarchy);

        // State: [State]
        class_5250 state = buildInfoComponent("cli.msg.info.region.state", "State", buildRegionStateLink(region));
        regionInfoLines.add(state);

        return regionInfoLines;
    }
}
