package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.List;
import net.minecraft.class_2561;

import static de.z0rdak.yawp.util.ChatComponentBuilder.buildHeader;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildRemoveRegionEntries;

public class RegionsInDimensionPagination extends BasePaginationMessage<IProtectedRegion> {

    private final IProtectedRegion region;
    private final DimensionRegionCache cache;

    public RegionsInDimensionPagination(DimensionRegionCache cache, List<IProtectedRegion> entries, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(entries, Commands.buildListLocalRegionCommand(cache.dimensionKey()), pageNumber, pageSize);
        this.region = cache.getDimensionalRegion();
        this.cache = cache;
    }

    @Override
    public List<class_2561> buildEntries() {
        return buildRemoveRegionEntries(region, this.pageContent);
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322("cli.msg.dim.info.regions.empty", "No regions defined in %s", ChatLinkBuilder.buildRegionInfoLink(this.cache.getDimensionalRegion()));
    }

    @Override
    public class_2561 header() {
        return buildHeader(class_2561.method_48322("cli.msg.info.header.in", "== %s in %s ==", ChatLinkBuilder.buildDimRegionsLink(this.cache), ChatLinkBuilder.buildRegionInfoLink(this.cache.getDimensionalRegion())));
    }

    @Override
    public class_2561 emptyEntry() {
        return Messages.substitutable(" - %s", ChatLinkBuilder.buildDimCreateRegionLink(this.cache.getDimensionalRegion()));
    }
}
