package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1621;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static de.z0rdak.yawp.api.FlagEvaluator.processCheck;

public class YawpEventHandler {

    public static void removeInvolvedEntities(class_2168 src, IProtectedRegion region, RegionFlag flag) {
        class_5321<class_1937> dimKey = class_5321.method_29179(class_7924.field_41223, region.getDim().method_29177());
        MinecraftServer server = src.method_9211();
        Predicate<? super class_1297> entityFilter = getEntityFilterForFlag(flag);
        switch (region.getRegionType()) {
            case GLOBAL: {
                server.method_3738().forEach(world -> {
                    List<class_1297> entitiesToRemove = getEntitiesToRemove(world, entityFilter, flag);
                    entitiesToRemove.forEach(e -> e.method_31745(class_1297.class_5529.field_26999));
                });
            }
            break;
            case DIMENSION: {
                class_3218 regionWorld = server.method_3847(dimKey);
                if (regionWorld != null) {
                    List<class_1297> entitiesToRemove = getEntitiesToRemove(regionWorld, entityFilter, flag);
                    entitiesToRemove.forEach(e -> e.method_31745(class_1297.class_5529.field_26999));
                }
            }
            break;
            case LOCAL: {
                class_3218 regionWorld = server.method_3847(dimKey);
                if (regionWorld != null) {
                    List<class_1297> entitiesToRemove = getEntitiesToRemove(regionWorld, (IMarkableRegion) region, entityFilter);
                    entitiesToRemove.forEach(e -> e.method_31745(class_1297.class_5529.field_26999));
                }
            }
            break;
        }
    }

    private static Predicate<? super class_1297> getEntityFilterForFlag(RegionFlag flag) {
        switch (flag) {
            case SPAWNING_ALL:
                return e -> e instanceof class_1308;
            case SPAWNING_MONSTER:
                return HandlerUtil::isMonster;
            case SPAWNING_ANIMAL:
                return HandlerUtil::isAnimal;
            case SPAWNING_GOLEM:
                return e -> e instanceof class_1473 || e instanceof class_1439;
            case SPAWNING_TRADER:
                return e -> e instanceof class_3989 || e instanceof class_3986;
            case SPAWNING_SLIME:
                return e -> e instanceof class_1621;
            case SPAWNING_VILLAGER:
                return HandlerUtil::isVillager;
            case SPAWNING_XP:
                return e -> e instanceof class_1303;
            default:
                return e -> false;
        }
    }

    /**
     * Get all entities in the region which are not persistent and match the entityFilter
     */
    private static List<class_1297> getEntitiesToRemove(class_3218 level, IMarkableRegion region, Predicate<? super class_1297> entityFilter) {
        // TODO: could be optimized by getting the chunks around the area only to check
        List<? extends class_1297> entities = level.method_18198(class_5575.method_31795(class_1297.class), entityFilter);
        return entities.stream()
                .filter(e -> region.getArea().containsOther(new CuboidArea(e.method_24515(), e.method_24515())))
                .filter(YawpEventHandler::isNotPersistent)
                .collect(Collectors.toList());
    }

    private static List<class_1297> getEntitiesToRemove(class_3218 level, Predicate<? super class_1297> entityFilter, RegionFlag flag) {
        List<? extends class_1297> entities = level.method_18198(class_5575.method_31795(class_1297.class), entityFilter);
        // TODO: EntityTypeTest static where possible, to reduce load
        // for monsters that could be Enemy.class i guess
        return entities.stream()
                .filter(e -> !isProtectedByRegion(level, flag, e)) // That's O(enemyCount * regionCount) complexity, not considering the recursion for the flag check
                .filter(YawpEventHandler::isNotPersistent)
                .collect(Collectors.toList());
    }

    private static boolean isNotPersistent(class_1297 e) {
        return !hasEnabledPersistenceFlag(e) && !e.method_16914();
    }

    private static boolean hasEnabledPersistenceFlag(class_1297 e) {
        if (e instanceof class_1308 mob) {
            return mob.method_5947();
        }
        return false;
    }

    private static boolean isProtectedByRegion(class_3218 level, RegionFlag flag, class_1297 e) {
        FlagCheckEvent checkEvent = new FlagCheckEvent(e.method_24515(), flag, level.method_27983());
        FlagState flagState = processCheck(checkEvent);
        return flagState == FlagState.ALLOWED;
    }
}
