package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1439;
import net.minecraft.class_1473;
import net.minecraft.class_1621;
import net.minecraft.class_3218;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;

@Mixin(class_3218.class)
public class ServerWorldMixin {

    @Inject(method = "addEntity", at = @At("HEAD"), cancellable = true, allow = 1)
    public void onSpawnEntity(class_1297 entity, CallbackInfoReturnable<Boolean> cir) {
        if (isServerSide(entity.method_73183())) {
            FlagCheckEvent checkEvent;
            if (entity instanceof class_1308) { // should not cover paintings, armor stands, item entities, players
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_ALL, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (isMonster(entity)) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_MONSTER, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (isAnimal(entity)) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_ANIMAL, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (isVillager(entity)) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_VILLAGER, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (entity instanceof class_3989 || entity instanceof class_3986) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_TRADER, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (entity instanceof class_1473 || entity instanceof class_1439) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_GOLEM, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (entity instanceof class_1621) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_SLIME, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
            if (entity instanceof class_1303) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), SPAWNING_XP, getDimKey(entity));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
            }
        }
    }
}
