package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.core.flag.RegionFlag.ANIMAL_TAMING;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_1321.class)
public abstract class TameableEntityMixin {
    @Inject(method = "tame", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onAnimalTame(class_1657 player, CallbackInfo ci) {
        class_1321 self = (class_1321) (Object) this;
        if (isServerSide(self.method_73183())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), ANIMAL_TAMING, getDimKey(self), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }
}
