/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3169;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_8113;

public final class VisualizationUtil {
    private VisualizationUtil() {
    }

    public static void updateDisplayBlock(class_1297 blockDisplayEntity, class_2960 blockRl) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        try {
            class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
            class_2487 entityTag = entityDataAccessor.method_13881();
            class_2487 blockState = (class_2487)entityTag.method_10562("block_state").get();
            blockState.method_10582("Name", blockRl.toString());
            entityTag.method_10566("block_state", (class_2520)blockState);
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayGlow(class_1297 blockDisplayEntity, boolean glow) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        entityTag.method_10556("Glowing", glow);
        try {
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayLightLevel(class_1297 blockDisplayEntity, int lightLevel) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", lightLevel);
        brightnessTag.method_10569("block", lightLevel);
        entityTag.method_10566("brightness", (class_2520)brightnessTag);
        try {
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void initTextDisplayProperties(class_1297 blockDisplayEntity, String regionName, TextDisplayProperties properties) {
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        try {
            class_2487 entityTag = VisualizationUtil.buildTeleportAnchorTextDisplayTag(regionName, properties);
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void initBlockDisplayProperties(class_1297 blockDisplayEntity, String regionName, BlockDisplayProperties properties) {
        class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
        try {
            class_2487 blockDisplayTag = VisualizationUtil.buildBlockDisplayTag(regionName, properties);
            class_2487 existingTag = entityDataAccessor.method_13881();
            existingTag.method_10566("block_state", (class_2520)blockDisplayTag.method_10562("block_state").get());
            existingTag.method_10566("brightness", (class_2520)blockDisplayTag.method_10562("brightness").get());
            existingTag.method_10566("data", (class_2520)blockDisplayTag.method_10562("data").get());
            existingTag.method_10582("id", (String)blockDisplayTag.method_10558("id").get());
            existingTag.method_10556("Glowing", ((Boolean)blockDisplayTag.method_10577("Glowing").get()).booleanValue());
            entityDataAccessor.method_13880(existingTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayProperties(class_1297 blockDisplayEntity, BlockDisplayProperties properties) {
        try {
            class_3169 entityDataAccessor = new class_3169(blockDisplayEntity);
            class_2487 entityTag = entityDataAccessor.method_13881();
            class_2487 blockState = (class_2487)entityTag.method_10562("block_state").get();
            blockState.method_10582("Name", properties.blockRl().toString());
            entityTag.method_10566("block_state", (class_2520)blockState);
            entityTag.method_10556("Glowing", properties.hasGlow());
            class_2487 brightnessTag = new class_2487();
            brightnessTag.method_10569("sky", properties.lightLevel());
            brightnessTag.method_10569("block", properties.lightLevel());
            entityTag.method_10566("brightness", (class_2520)brightnessTag);
            entityDataAccessor.method_13880(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Optional<class_1297> createTextDisplayEntity(class_3218 level, String regionName, class_2338 pos, TextDisplayProperties displayProperties) {
        class_8113.class_8115 textDisplay = (class_8113.class_8115)class_1299.field_42460.method_5888(level, e -> VisualizationUtil.initTextDisplayProperties((class_1297)e, regionName, displayProperties), pos, class_3730.field_16462, false, false);
        return textDisplay == null ? Optional.empty() : Optional.of(textDisplay);
    }

    public static Optional<class_1297> createBlockDisplayEntity(class_3218 level, String regionName, class_2338 pos, BlockDisplayProperties displayProperties) {
        class_1297 blockDisplay = class_1299.field_42460.method_5888(level, e -> {
            VisualizationUtil.initBlockDisplayProperties((class_1297)e, regionName, displayProperties);
            e.method_66246(new class_243((class_2382)pos), 0.0f, 0.0f);
        }, pos, class_3730.field_16462, false, false);
        return blockDisplay == null ? Optional.empty() : Optional.of(blockDisplay);
    }

    public static class_2487 buildTeleportAnchorTextDisplayTag(String regionName, TextDisplayProperties properties) {
        class_2487 textDisplayTag = new class_2487();
        class_2960 blockDisplayRl = class_2960.method_60656((String)"text_display");
        textDisplayTag.method_10582("id", blockDisplayRl.toString());
        class_2487 data = new class_2487();
        data.method_10582("yawp_display", "text");
        data.method_10582("region", regionName);
        data.method_10582("tpAnchor", properties.getText());
        textDisplayTag.method_10566("data", (class_2520)data);
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", 15);
        brightnessTag.method_10569("block", 15);
        textDisplayTag.method_10566("brightness", (class_2520)brightnessTag);
        textDisplayTag.method_10582("billboard", "center");
        class_5250 text = class_2561.method_43470((String)properties.toString());
        textDisplayTag.method_10582("text", text.toString());
        textDisplayTag.method_10582("alignment", "center");
        textDisplayTag.method_10569("background", 0x1A000000);
        return textDisplayTag;
    }

    public static class_2487 buildBlockDisplayTag(String regionName, BlockDisplayProperties properties) {
        class_2487 blockDisplayTag = new class_2487();
        class_2960 blockDisplayRl = class_2960.method_60656((String)"block_display");
        blockDisplayTag.method_10582("id", blockDisplayRl.method_12832());
        blockDisplayTag.method_10556("Glowing", properties.hasGlow());
        class_2487 data = new class_2487();
        data.method_10582("yawp_display", "block");
        data.method_10582("region", regionName);
        blockDisplayTag.method_10566("data", (class_2520)data);
        class_2487 brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", properties.lightLevel());
        brightnessTag.method_10569("block", properties.lightLevel());
        blockDisplayTag.method_10566("brightness", (class_2520)brightnessTag);
        class_2487 blockstateTag = new class_2487();
        blockstateTag.method_10582("Name", properties.blockRl().toString());
        blockDisplayTag.method_10566("block_state", (class_2520)blockstateTag);
        return blockDisplayTag;
    }
}

