/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class TeleportAnchorPagination
extends BasePaginationMessage<TeleportAnchor> {
    private final IMarkableRegion region;

    public TeleportAnchorPagination(IMarkableRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(region.getTpAnchors().getAnchors(), Commands.buildListRegionFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static class_5250 buildTeleportAnchorInfoHeader(IProtectedRegion region, class_5250 flagListLink) {
        return ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{flagListLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static List<class_2561> buildTeleportAnchorEntries(IMarkableRegion region, List<TeleportAnchor> tpAnchors) {
        List<TeleportAnchor> alphabeticAnchors = tpAnchors.stream().sorted(Comparator.comparing(TeleportAnchor::getName)).toList();
        return alphabeticAnchors.stream().map(tpAnchor -> TeleportAnchorPagination.buildRemoveTeleportAnchorEntry(region, tpAnchor)).collect(Collectors.toList());
    }

    public static class_2561 buildRemoveTeleportAnchorEntry(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2561 teleportAnchorRemoveLink = TeleportAnchorPagination.buildRemoveTeleportAnchorLink(region, tpAnchor);
        class_5250 anchorNameText = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.text", (String)"%s", (Object[])new Object[]{tpAnchor.getName()});
        class_5250 anchorNameHover = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.hover", (String)"Anchor '%s' @ %s", (Object[])new Object[]{tpAnchor.getName(), ChatComponentBuilder.shortBlockPosBracketed(tpAnchor.getPos())});
        class_5250 anchorName = ChatComponentBuilder.buildTextWithHoverMsg(anchorNameText, anchorNameHover, class_124.field_1060);
        class_2561 tpLink = TeleportAnchorPagination.buildTeleportToAnchorLink(region, tpAnchor);
        class_2561 showLink = TeleportAnchorPagination.buildShowTeleportAnchorLink(region, tpAnchor);
        class_2561 hideLink = TeleportAnchorPagination.buildHideTeleportAnchorLink(region, tpAnchor);
        class_2561 renameLink = TeleportAnchorPagination.buildRenameTeleportAnchorLink(region, tpAnchor);
        class_2561 updateLink = TeleportAnchorPagination.buildUpdateTeleportAnchorLink(region, tpAnchor);
        return Messages.substitutable(" - %s %s @ %s | %s %s %s %s", teleportAnchorRemoveLink, anchorName, tpLink, showLink, hideLink, updateLink, renameLink);
    }

    public static class_2561 buildShowTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String cmd = Commands.buildShowTpAnchorCommand(region, tpAnchor.getName());
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.show.link.text", (String)"s");
        class_5250 hover = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.show.link.hover", (String)"Click to show teleport anchor");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_2561 buildHideTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String cmd = Commands.buildHideTpAnchorCommand(region, tpAnchor.getName());
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.hide.link.text", (String)"h");
        class_5250 hover = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.hide.link.hover", (String)"Click to hide teleport anchor");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_2561 buildRemoveTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String rmCmd = Commands.buildRemoveTeleportAnchorCommand(region, tpAnchor.getName());
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.remove.link.hover", (String)"Click to remove '%s' from region %s", (Object[])new Object[]{tpAnchor.getName(), region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, rmCmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    public static class_2561 buildTeleportToAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String cmd = Commands.buildTeleportTpAnchorCommand(region, tpAnchor.getName());
        class_5250 text = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.tp.link.text", (String)"%s", (Object[])new Object[]{ChatComponentBuilder.commandBlockPosStr(tpAnchor.getPos())});
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.tp.link.hover", (String)"Click to teleport to '%s' @ %s", (Object[])new Object[]{tpAnchor.getName(), ChatComponentBuilder.shortBlockPosBracketed(tpAnchor.getPos())});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_2561 buildRenameTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String renameCmd = Commands.buildSuggestRenameTpAnchorCommand(region, tpAnchor.getName());
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.rename.link.hover", (String)"Click to rename '%s'", (Object[])new Object[]{tpAnchor.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.rename.link.text", (String)"r");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, renameCmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_2561 buildUpdateTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String renameCmd = Commands.buildSuggestUpdateTpAnchorCommand(region, tpAnchor.getName());
        class_5250 hover = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.update.link.hover", (String)"Click to set new teleport position");
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.tp-anchor.update.link.text", (String)"p");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, renameCmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.empty", (String)"No teleport anchors defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.region)});
    }

    @Override
    public class_2561 header() {
        return TeleportAnchorPagination.buildTeleportAnchorInfoHeader(this.region, TeleportAnchorPagination.buildRegionTeleportAnchorListLink(this.region));
    }

    @Override
    public List<class_2561> buildEntries() {
        return TeleportAnchorPagination.buildTeleportAnchorEntries(this.region, this.pageContent);
    }

    @Override
    public class_2561 emptyEntry() {
        return Messages.substitutable(" - %s", TeleportAnchorPagination.buildSuggestAddTeleportAnchorLink(this.region, "tpAnchor", class_2338.field_10980));
    }

    public static class_5250 buildRegionTeleportAnchorListLink(IMarkableRegion region) {
        class_5250 numberHover = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.link.hover", (String)"%s teleport anchor(s) defined in %s", (Object[])new Object[]{region.getTpAnchors().getAnchors().size(), region.getName()});
        class_5250 regionTpAnchorAmountPlain = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", region.getTpAnchors().getAnchors().size()), numberHover, Messages.LINK_COLOR);
        class_5250 regionTpAnchorAmount = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", region.getTpAnchors().getAnchors().size()), numberHover, Messages.LINK_COLOR);
        class_5250 tpAnchorHoverText = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.link.hover", (String)"%s teleport anchor(s) defined in %s", (Object[])new Object[]{region.getTpAnchors().getAnchors().size(), region.getName()});
        String listAnchorCmd = Commands.buildListTeleportAnchorCommand(region);
        class_5250 tpAnchorListLink = ChatComponentBuilder.buildExecuteCmdComponent(regionTpAnchorAmount, tpAnchorHoverText, listAnchorCmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
        class_5250 tpAnchorComp = region.getTpAnchors().getAnchors().isEmpty() ? regionTpAnchorAmountPlain : tpAnchorListLink;
        return Messages.substitutable("%s %s", class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.link.text", (String)"%s teleport anchor(s)", (Object[])new Object[]{tpAnchorComp}), TeleportAnchorPagination.buildSuggestAddTeleportAnchorLink(region, "tpAnchor-name", class_2338.field_10980));
    }

    public static class_5250 buildSuggestAddTeleportAnchorLink(IMarkableRegion region, String name, class_2338 pos) {
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.add.link.hover", (String)"Click to create new teleport anchor in %s", (Object[])new Object[]{region.getName()});
        class_5250 linkText = class_2561.method_48321((String)"cli.link.add", (String)"+");
        String cmd = Commands.buildAddTeleportAnchorCommand(region, name, pos);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, class_2558.class_2559.field_11745, Messages.ADD_CMD_COLOR);
    }
}

