package de.z0rdak.yawp.api.visualization;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3169;
import net.minecraft.class_3218;
import net.minecraft.class_8113;

public final class VisualizationUtil {

    private VisualizationUtil() {}

    public static void updateDisplayBlock(class_1297 blockDisplayEntity, class_2960 blockRl) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        var entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        class_2487 blockState = entityTag.method_10562("block_state");
        blockState.method_10582("Name", blockRl.toString());
        entityTag.method_10566("block_state", blockState);
        try {
            entityDataAccessor.method_13880(entityTag);
        } catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayGlow(class_1297 blockDisplayEntity, boolean glow) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        var entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        entityTag.method_10556("Glowing", glow);
        try {
            entityDataAccessor.method_13880(entityTag);
        } catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayLightLevel(class_1297 blockDisplayEntity, int lightLevel) {
        if (!(blockDisplayEntity instanceof class_8113.class_8115)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        var entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        var brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", lightLevel);
        brightnessTag.method_10569("block", lightLevel);
        entityTag.method_10566("brightness", brightnessTag);
        try {
            entityDataAccessor.method_13880(entityTag);
        } catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayProperties(class_1297 blockDisplayEntity, BlockDisplayProperties properties) {
        var entityDataAccessor = new class_3169(blockDisplayEntity);
        class_2487 entityTag = entityDataAccessor.method_13881();
        class_2487 blockState = entityTag.method_10562("block_state");
        blockState.method_10582("Name", properties.blockRl().toString());
        entityTag.method_10566("block_state", blockState);
        entityTag.method_10556("Glowing", properties.hasGlow());
        var brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", properties.lightLevel());
        brightnessTag.method_10569("block", properties.lightLevel());
        entityTag.method_10566("brightness", brightnessTag);
        try {
            entityDataAccessor.method_13880(entityTag);
        } catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", e);
            throw new RuntimeException(e);
        }
    }



    @Deprecated
    public static class_1297 createBlockDisplayRecursive(class_3218 level, class_2338 pos, class_2487 displayTag) {
        return class_1299.method_17842(displayTag, level, p_396566_ -> {
            p_396566_.method_5808(pos.method_10263(), pos.method_10264(), pos.method_10260(), p_396566_.method_36454(), p_396566_.method_36455());
            return p_396566_;
        });
    }

    /**
     * Creates an entity in the level at the specified position with the provided tag.
     * @param level level in which to spawn the entity
     * @param pos position at which to spawn the display entity
     * @param displayTag tag which provides data about the entity (e.g. text or block display entity)
     * @return an optional with the entity inside if spawning was successfully, empty otherwise
     */
    public static Optional<class_1297> createDisplayEntity(class_3218 level, class_2338 pos, class_2487 displayTag) {
        Optional<class_1297> entity = class_1299.method_5892(displayTag, level);
        entity.ifPresent(e -> e.method_5808(pos.method_10263(), pos.method_10264(), pos.method_10260(), e.field_5982, e.field_6004));
        return entity;
    }

    /**
     *
     * @param regionName a marker, stored in custom entity data for identification later
     */
    public static Optional<class_1297> createTextDisplayEntity(class_3218 level, String regionName, class_2338 pos, TextDisplayProperties displayProperties) {
        var entityTag = buildTeleportAnchorTextDisplayTag(regionName, displayProperties);
        var maybeEntity = class_1299.method_5892(entityTag, level);
        maybeEntity.ifPresent(e -> e.method_5808(pos.method_10263(), pos.method_10264(), pos.method_10260(), e.field_5982, e.field_6004));
        return maybeEntity;
    }

    /**
     *
     * @param regionName a marker, stored in custom entity data for identification later
     */
    public static Optional<class_1297> createBlockDisplayEntity(class_3218 level, String regionName, class_2338 pos, BlockDisplayProperties displayProperties) {
        var entityTag = buildBlockDisplayTag(regionName, displayProperties);
        var maybeEntity = class_1299.method_5892(entityTag, level);
        maybeEntity.ifPresent(e -> e.method_5808(pos.method_10263(), pos.method_10264(), pos.method_10260(), e.field_5982, e.field_6004));
        return maybeEntity;
    }

    /**
     * SEE: https://minecraft.wiki/w/Display#Data_values
     */
    public static class_2487 buildTeleportAnchorTextDisplayTag(String regionName, TextDisplayProperties properties) {
        var textDisplayTag = new class_2487();

        // General Entity Tags
        class_2960 blockDisplayRl = class_2960.method_60656("text_display");
        textDisplayTag.method_10582("id", blockDisplayRl.toString());
        // textDisplayTag.putBoolean("Glowing", properties.hasGlow());

        // custom data
        class_2487 data = new class_2487();
        data.method_10582("yawp_display", "text");
        data.method_10582("region", regionName);
        data.method_10582("tpAnchor", properties.getText());
        textDisplayTag.method_10566("data", data);

        // Display Entity Tags
        var brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", 15);
        brightnessTag.method_10569("block", 15);
        textDisplayTag.method_10566("brightness", brightnessTag);
        textDisplayTag.method_10582("billboard", "center");

        // Text Display Entity Tags
        var text = class_2561.method_43470(properties.toString());
        // TODO: text.getString() ?
        textDisplayTag.method_10582("text", text.toString());
        textDisplayTag.method_10582("alignment", "center");
        textDisplayTag.method_10569("background", TextDisplayProperties.DEFAULT_BACKGROUND);

        return textDisplayTag;
    }

    public static class_2487 buildBlockDisplayTag(String regionName, BlockDisplayProperties properties) {
        var blockDisplayTag = new class_2487();

        // General Entity Tags
        class_2960 blockDisplayRl = class_2960.method_60656("block_display");
        blockDisplayTag.method_10582("id", blockDisplayRl.method_12832());
        blockDisplayTag.method_10556("Glowing", properties.hasGlow());

        // custom data
        class_2487 data = new class_2487();
        data.method_10582("yawp_display", "block");
        data.method_10582("region", regionName);
        blockDisplayTag.method_10566("data", data);

        // Display Entity Tags
        var brightnessTag = new class_2487();
        brightnessTag.method_10569("sky", properties.lightLevel());
        brightnessTag.method_10569("block", properties.lightLevel());
        blockDisplayTag.method_10566("brightness", brightnessTag);

        // Block Display Tags
        var blockstateTag = new class_2487();
        blockstateTag.method_10582("Name", properties.blockRl().toString());
        blockDisplayTag.method_10566("block_state", blockstateTag);

        return blockDisplayTag;
    }
}
