package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3616;
import net.minecraft.class_3621;
import net.minecraft.world.level.material.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;

@Mixin(class_3609.class)
public class FlowingFluidMixin {

    @Inject(method = "spreadTo", at = @At("HEAD"), cancellable = true)
    protected void canSpreadTo(class_1936 levelAccessor, class_2338 pos, class_2680 blockState, class_2350 direction, class_3610 fluidState, CallbackInfo ci) {
        if (!(levelAccessor instanceof class_1937 level)) {
            // Should never happen, but skip check if it does
            return;
        }
        if (!Services.FLAG_CONFIG.isDisabledByConfig(FLUID_FLOW.name)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, FLUID_FLOW, level.method_27983());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                ci.cancel();
            });
            if (ci.isCancelled()) {
                return;
            }
        }

        if (!Services.FLAG_CONFIG.isDisabledByConfig(WATER_FLOW.name)) {
            if ( fluidState.method_15772() instanceof class_3621) {
                FlagCheckEvent specificFluidCheckEvent = new FlagCheckEvent(pos, WATER_FLOW, level.method_27983());
                if (Services.EVENT.post(specificFluidCheckEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> {
                    ci.cancel();
                });
            }
        }

        if (!Services.FLAG_CONFIG.isDisabledByConfig(LAVA_FLOW.name)) {
            if ( fluidState.method_15772() instanceof class_3616) {
                FlagCheckEvent specificFluidCheckEvent = new FlagCheckEvent(pos, LAVA_FLOW, level.method_27983());
                if (Services.EVENT.post(specificFluidCheckEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> {
                    ci.cancel();
                });
            }
        }
    }
}
