package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3695;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;

@Mixin(class_3218.class)
public class ServerWorldMixin {

    /**
     * Injection for lightning protection flag. It prevents lightning strikes which are not hitting entities and would potentially cause fire.
     */
    @Inject(method = "tickChunk", locals = LocalCapture.CAPTURE_FAILSOFT, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LightningBolt;setVisualOnly(Z)V"), cancellable = false, allow = 1)
    public void onSpawnLightning(class_2818 chunk, int randomTickSpeed, CallbackInfo ci, class_1923 chunkPos, boolean bl, int i, int j, class_3695 profiler, class_2338 blockPos, class_1266 localDifficulty, boolean b, class_1538 lightningEntity) {
        if (isServerSide(chunk.method_12200())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, LIGHTNING_PROT, getDimKey(chunk.method_12200()));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                lightningEntity.method_5650(class_1297.class_5529.field_26999);
                Constants.LOGGER.info("Discarded 'minecraft:lightning_bolt' due to flag in region {}. You can ignore the warning printed by the vanilla code.", deny.getResponsible().getName());
            });
        }
    }

    /**
     * Returning a null explosion will cause this event to be canceled.
     * An arrow on fire or fire charge shot by an e.g. dispenser will cause the type of the explosion to be ExplosionSourceType.TNT
     */
    @Inject(method = "explode", at = @At("HEAD"), cancellable = true, allow = 1)
    public void onIgniteExplosive(
            class_1297 source, class_1282 damageSource, class_5362 damageCalculator, double x, double y, double z, float radius, boolean fire, class_1937.class_7867 explosionInteraction, class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, class_6880<class_3414> explosionSound, CallbackInfoReturnable<class_1927> cir) {
        class_3218 world = (class_3218) (Object) this;
        if (isServerSide(world)) {
            if (explosionInteraction == class_1937.class_7867.field_40891 || explosionInteraction == class_1937.class_7867.field_40889) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(new class_2338((int) x, (int) y, (int) z), IGNITE_EXPLOSIVES, world.method_27983());
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> cir.setReturnValue(null));
            }
            if (explosionInteraction == class_1937.class_7867.field_40890) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(new class_2338((int) x, (int) y, (int) z), MOB_GRIEFING, world.method_27983());
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> cir.setReturnValue(null));
            }
        }
    }
}