package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.platform.Services;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3989;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_1657.class)
public abstract class PlayerMixin {

    // TODO: This does not seem to be triggered
    @Inject(method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    private void onDropItem(class_1799 stack, boolean b1, boolean retainOwnership, CallbackInfoReturnable<class_1799> cir) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), ITEM_DROP, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                player.method_7270(stack);
                cir.setReturnValue(null);
            });
        }
    }

    @Inject(method = "giveExperienceLevels", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onGainLevels(int levels, CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), LEVEL_FREEZE, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }

    @Inject(method = "giveExperiencePoints", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onGainExperience(int experience, CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), XP_FREEZE, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                ci.cancel();
            });
        }
    }

    @Inject(method = "actuallyHurt", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;getDamageAfterArmorAbsorb(Lnet/minecraft/world/damagesource/DamageSource;F)F"), cancellable = true, allow = 1)
    public void onHurt(class_1282 source, float amount, CallbackInfo ci) {
        class_1657 self = (class_1657) (Object) this;
        if (isServerSide(self)) {
            if (source.method_5529() instanceof class_1657 attackingPlayer) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), NO_PVP, getDimKey(self), attackingPlayer);
                if (Services.EVENT.post(checkEvent))
                    return;
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    ci.cancel();
                });
            }
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), INVINCIBLE, getDimKey(self), self);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.process(checkEvent)
                    .onAllow(res -> ci.cancel());
        }
    }

    @Inject(method = "actuallyHurt", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;setAbsorptionAmount(F)V"), cancellable = true, allow = 1)
    public void onReceiveDamage(class_1282 damageSource, float amount, CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            // TODO: meele-player flag
        }
    }


    @Inject(method = "attack", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onAttackEntity(class_1297 target, CallbackInfo ci) {
        if (isServerSide(target)) {
            class_1657 player = (class_1657) (Object) this;
            if (target == null) return;
            if (target instanceof class_1657) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), MELEE_PLAYERS, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent))
                    return;
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    ci.cancel();
                });
            } else {
                if (isAnimal(target)) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), MELEE_ANIMALS, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent))
                        return;
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                if (isMonster(target)) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), MELEE_MONSTERS, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent))
                        return;
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                if (target instanceof class_1646) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), MELEE_VILLAGERS, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent))
                        return;
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        sendFlagMsg(deny);
                        ci.cancel();
                    });
                }
                if (target instanceof class_3989) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), MELEE_WANDERING_TRADER, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent))
                        return;
                    FlagEvaluator.processCheck(checkEvent, deny -> {
                        sendFlagMsg(deny);
                        ci.cancel();
                    });
                }

                // check every other entity if it is in the list of entities to protect
                // this is for BlockEntities which are not covered by the block breaking flag
                Set<String> entityTags = FlagConfig.getCoveredBlockEntityTags();
                boolean isCoveredByTag = entityTags.stream().anyMatch(entityTag -> {
                    class_2960 tagRl = class_2960.method_60654(entityTag);
                    return target.method_5752().contains(tagRl.method_12832());
                });
                Set<String> entities = FlagConfig.getCoveredBlockEntities();
                boolean isBlockEntityCovered = entities.stream().anyMatch(entity -> {
                    class_2960 entityRl = class_2960.method_60654(entity);
                    class_2960 targetRl = class_1299.method_5890(target.method_5864());
                    return targetRl != null && targetRl.equals(entityRl);
                });
                if (isBlockEntityCovered || isCoveredByTag) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), BREAK_BLOCKS, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent))
                        return;
                    FlagEvaluator.processCheck(checkEvent, null, onDeny -> {
                        ci.cancel();
                        sendFlagMsg(onDeny);
                    });
                }
            }
        }
    }

    @Inject(method = "tick", at = @At(value = "TAIL"), allow = 1)
    private void onUseElytraTick(CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            if (player.method_6128()) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), NO_FLIGHT, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent))
                    return;
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    player.method_23670();
                });
            }
        }
    }
}
