package de.z0rdak.yawp.platform.services;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2168;

public interface IPermissionHelper {
    
    boolean hasConfigPermission(class_2168 src, CommandSourceType srcType) throws CommandSyntaxException;
    boolean isAllowedForNonOp(class_2168 src);
    boolean hasConfigPermAndOpBypassFlags(class_1657 player);
    boolean hasOwnerPermission(IProtectedRegion region, class_1657 player);
    boolean hasAnyPermission(IProtectedRegion region, class_1657 player, List<String> groups);
    boolean hasCmdPermission(class_2168 src);
    boolean hasGroupPermission(IProtectedRegion region, class_1657 player, String permissionGroup);
    boolean isInGroup(IProtectedRegion region, class_1657 player, String group);
    //boolean hasRegionHierarchyPermission(IProtectedRegion region, Player player, String permissionGroup);
    //boolean hasRegionHierarchyPermission(IProtectedRegion region, Player player, String permissionGroup, boolean hasPermission);    
    
}
