package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.api.commands.CommandConstants.FLAG;
import static de.z0rdak.yawp.api.commands.CommandConstants.REMOVE;
import static de.z0rdak.yawp.api.commands.Commands.buildCommandStr;
import static de.z0rdak.yawp.api.commands.Commands.buildListRegionFlagsCommand;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildExecuteCmdComponent;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildHeader;
import static de.z0rdak.yawp.util.ChatLinkBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.REMOVE_CMD_COLOR;
import static net.minecraft.class_124.*;
import static net.minecraft.class_2558.class_2559.field_11750;

public class RegionFlagPagination extends BasePaginationMessage<IFlag> {

    private final IProtectedRegion region;

    public RegionFlagPagination(IProtectedRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(region.getFlags().flags(), buildListRegionFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static class_5250 buildRegionFlagInfoHeader(IProtectedRegion region, class_5250 flagListLink) {
        return buildHeader(class_2561.method_48322("cli.msg.info.header.in", "== %s in %s ==", flagListLink, buildRegionInfoLink(region)));
    }

    public static List<class_2561> buildRegionFlagEntries(IProtectedRegion region) {
        return buildRegionFlagEntries(region, region.getFlags().flags());
    }

    public static List<class_2561> buildRegionFlagEntries(IProtectedRegion region, List<IFlag> selectedFlags) {
        List<class_2561> flagEntries = new ArrayList<>();
        flagEntries.addAll(buildFlagEntriesForState(region, selectedFlags, FlagState.DENIED));
        flagEntries.addAll(buildFlagEntriesForState(region, selectedFlags, FlagState.ALLOWED));
        flagEntries.addAll(buildFlagEntriesForState(region, selectedFlags, FlagState.DISABLED));
        return flagEntries;
    }

    public static List<class_5250> buildFlagEntriesForState(IProtectedRegion region, List<IFlag> selectedFlags, FlagState state) {
        List<IFlag> flagsByState = selectedFlags.stream()
                .filter(f -> f.getState() == state)
                .sorted(Comparator.comparing(IFlag::getName))
                .toList();
        return flagsByState.stream()
                .map(flag -> buildRemoveFlagEntry(region, flag, colorForState(flag.getState())))
                .collect(Collectors.toList());
    }

    /**
     * Creates a TextComponent for flag removal, followed by the flag infos
     */
    public static class_5250 buildRemoveFlagEntry(IProtectedRegion region, IFlag flag, class_124 flagLinkColor, class_124... ChatFormattings) {
        // [x] [flagname] [<region-indicator] [] []
        String cmd;
        switch (region.getRegionType()) {
            case GLOBAL: {
                cmd = buildCommandStr(CommandConstants.GLOBAL.toString(), REMOVE.toString(), FLAG.toString(), flag.getName());
                break;
            }
            case DIMENSION: {
                cmd = buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), REMOVE.toString(), FLAG.toString(), flag.getName());
                break;
            }
            case LOCAL: {
                cmd = buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), REMOVE.toString(), FLAG.toString(), flag.getName());
                break;
            }
            default:
                throw new IllegalArgumentException();
        }
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.flag.remove.link.hover", "Remove flag '%s' from region %s", flag.getName(), region.getName());
        class_5250 linkText = class_2561.method_48321("cli.link.remove", "x");
        class_5250 flagRemoveLink = buildExecuteCmdComponent(linkText, hoverText, cmd, field_11750, REMOVE_CMD_COLOR);
        class_5250 flagQuickActionComponent = buildFlagQuickActionComponent(region, flag, flagLinkColor);
        flagQuickActionComponent.method_27695(ChatFormattings);
        return Messages.substitutable(" - %s %s", flagRemoveLink, flagQuickActionComponent);
    }

    public static class_124 colorForState(FlagState state) {
        switch (state) {
            case ALLOWED:
                return field_1060;
            case DENIED:
                return field_1061;
            case DISABLED:
                return field_1080;
            default:
                throw new IllegalArgumentException();
        }
    }

    /**
     * Creates a TextComponent with a Link for displaying the flag info. <br>
     * Text: [flagname] [regionTypeIdentifier] [s] [m] [o] <br>
     * Where <br>
     * - [s] is a suggest link to change the flag state, <br>
     * - [m] is a quick link to toggle the flag mute state, <br>
     * - [o] is a quick link to toggle the flag override state, <br>
     *
     * @param region
     * @param flag
     * @return text component for quick flag actions [flagname] [regionTypeIdentifier] [s] [m] [o]
     */
    public static class_5250 buildFlagQuickActionComponent(IProtectedRegion region, IFlag flag, class_124 flagLinkColor) {
        class_5250 regionTypeIndicator = class_2561.method_43470(region.getRegionType().type.substring(0, 1).toUpperCase());
        class_5250 hoverText = class_2561.method_48322("cli.flag.info.hover", "Show %s flag info of region '%s'", flag.getName(), region.getName());
        class_5250 flagInfoLink = buildFlagInfoLink(region, flag, flagLinkColor);
        return Messages.substitutable("%s %s %s %s %s",
                flagInfoLink,
                buildFlagInfoLink(region, flag, regionTypeIndicator, hoverText, field_1064),
                buildFlagStateSuggestionLink(region, flag),
                buildFlagMuteToggleLink(region, flag, true),
                buildFlagOverrideToggleLink(region, flag, true));
    }

    @Override
    public class_2561 noContentMsg() {
        return class_2561.method_48322("cli.msg.info.region.flag.empty", "No flags defined in %s", buildRegionInfoLink(region));
    }

    @Override
    public class_2561 header() {
        return buildRegionFlagInfoHeader(this.region, buildRegionFlagListLink(this.region));
    }

    @Override
    public List<class_2561> buildEntries() {
        return buildRegionFlagEntries(this.region, this.pageContent);
    }

    @Override
    public class_2561 emptyEntry() {
        return Messages.substitutable(" - %s", buildSuggestAddFlagLink(region));
    }


}
