/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.flag.FlagEvent;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.flag.IFlagArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.FlagType;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.MojangApiHelper;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.ChildRegionPagination;
import de.z0rdak.yawp.util.text.messages.pagination.GroupMemberPagination;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionFlagPagination;
import de.z0rdak.yawp.util.text.messages.pagination.ResponsibleFlagPagination;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2243;
import net.minecraft.class_2561;
import net.minecraft.class_270;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public class CommandUtil {
    public static LiteralArgumentBuilder<class_2168> buildClearSubCommand(Function<CommandContext<class_2168>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.CLEAR).then(ArgumentUtil.literal(CommandConstants.FLAGS).executes(ctx -> CommandUtil.clearFlags((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PLAYERS).executes(ctx -> CommandUtil.clearPlayers((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx)))).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.clearPlayers((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.TEAMS).executes(ctx -> CommandUtil.clearTeams((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx)))).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.clearTeams((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.GROUP).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.clearGroups((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))));
    }

    public static LiteralArgumentBuilder<class_2168> buildRemoveSubCommand(Function<CommandContext<class_2168>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.REMOVE).then(ArgumentUtil.literal(CommandConstants.PLAYER).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)CommandConstants.PLAYER.toString(), (ArgumentType)class_2186.method_9308()).executes(ctx -> CommandUtil.removePlayers((CommandContext<class_2168>)ctx, ArgumentUtil.getPlayersArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx))))).then(ArgumentUtil.literal(CommandConstants.BY_UUID).then(class_2170.method_9244((String)CommandConstants.PLAYER_UUID.toString(), (ArgumentType)class_5242.method_27643()).suggests((ctx, builder) -> class_2172.method_9265((Iterable)((IProtectedRegion)regionSupplier.apply(ctx)).getGroup(ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)).getPlayers().keySet().stream().map(UUID::toString).collect(Collectors.toList()), (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.removePlayerByUUID((CommandContext<class_2168>)ctx, ArgumentUtil.getPlayerUUIDArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.BY_NAME).then(class_2170.method_9244((String)CommandConstants.PLAYER_NAMES.toString(), (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> class_2172.method_9265(((IProtectedRegion)regionSupplier.apply(ctx)).getGroup(ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)).getPlayers().values(), (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.removePlayersByName((CommandContext<class_2168>)ctx, ArgumentUtil.getPlayerNamesArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.TEAM).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)CommandConstants.TEAM.toString(), (ArgumentType)class_2243.method_9482()).executes(ctx -> CommandUtil.removeTeam((CommandContext<class_2168>)ctx, ArgumentUtil.getTeamArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.FLAG).then(class_2170.method_9244((String)CommandConstants.FLAG.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.removeRegionFlag((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.FLAGS).then(class_2170.method_9244((String)CommandConstants.FLAGS.toString(), (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.removeFlags((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArguments((CommandContext<class_2168>)ctx)))));
    }

    public static LiteralArgumentBuilder<class_2168> buildAddSubCommand(Function<CommandContext<class_2168>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ADD).then(ArgumentUtil.literal(CommandConstants.PLAYER).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)CommandConstants.PLAYER.toString(), (ArgumentType)class_2186.method_9308()).executes(ctx -> CommandUtil.addPlayers((CommandContext<class_2168>)ctx, ArgumentUtil.getPlayersArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx))))).then(ArgumentUtil.literal(CommandConstants.BY_UUID).then(class_2170.method_9244((String)CommandConstants.PLAYER_UUID.toString(), (ArgumentType)class_5242.method_27643()).executes(ctx -> CommandUtil.addPlayerByUuid((CommandContext<class_2168>)ctx, ArgumentUtil.getPlayerUUIDArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.BY_NAME).then(class_2170.method_9244((String)CommandConstants.PLAYER_NAMES.toString(), (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandUtil.addPlayersByName((CommandContext<class_2168>)ctx, ArgumentUtil.getPlayerNamesArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.TEAM).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)CommandConstants.TEAM.toString(), (ArgumentType)class_2243.method_9482()).executes(ctx -> CommandUtil.addTeam((CommandContext<class_2168>)ctx, ArgumentUtil.getTeamArgument((CommandContext<class_2168>)ctx), (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.FLAG).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.FLAG.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.addFlag((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArgument((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)CommandConstants.STATE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(FlagState.ValidFlagStates(), (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.addFlag((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getFlagStateArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.FLAGS).then(class_2170.method_9244((String)CommandConstants.FLAGS.toString(), (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> IFlagArgumentType.flag().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.addFlags((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getFlagArguments((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.ALL_FLAGS).executes(ctx -> CommandUtil.addAllFlags((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx))));
    }

    public static LiteralArgumentBuilder<class_2168> buildListSubCommand(Function<CommandContext<class_2168>, IProtectedRegion> regionSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.LIST).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.CHILDREN).executes(ctx -> CommandUtil.promptRegionChildren((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), 0))).then(class_2170.method_9244((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptRegionChildren((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getPageNoArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.FLAG).executes(ctx -> CommandUtil.promptFlagList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), 0))).then(class_2170.method_9244((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptFlagList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getPageNoArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.REGION_FLAG).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), 0))).then(class_2170.method_9244((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptRegionFlagList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getPageNoArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.GROUP).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.promptGroupLinks((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.TEAM).executes(ctx -> CommandUtil.promptGroupList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx), GroupType.TEAM, 0))).then(class_2170.method_9244((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptGroupList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx), GroupType.TEAM, ArgumentUtil.getPageNoArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PLAYER).executes(ctx -> CommandUtil.promptGroupList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx), GroupType.PLAYER, 0))).then(class_2170.method_9244((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> CommandUtil.promptGroupList((CommandContext<class_2168>)ctx, (IProtectedRegion)regionSupplier.apply(ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx), GroupType.PLAYER, ArgumentUtil.getPageNoArgument((CommandContext<class_2168>)ctx)))))));
    }

    public static LiteralArgumentBuilder<class_2168> buildCopySubCommand(Function<CommandContext<class_2168>, IProtectedRegion> srcSupplier) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.COPY).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.FLAGS).then(ArgumentUtil.literal(CommandConstants.TO_LOCAL).then(class_2170.method_9244((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)CommandConstants.TARGET_REGION.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listRegionsInTargetDim(ctx, builder)).executes(ctx -> CommandUtil.copyRegionFlags((CommandContext<class_2168>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetLocalRegionArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.TO_DIM).then(class_2170.method_9244((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)class_2181.method_9288()).executes(ctx -> CommandUtil.copyRegionFlags((CommandContext<class_2168>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetDimRegionArgument((CommandContext<class_2168>)ctx).getDim())))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PLAYERS).then(ArgumentUtil.literal(CommandConstants.TO_LOCAL).then(class_2170.method_9244((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)CommandConstants.TARGET_REGION.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listRegionsInTargetDim(ctx, builder)).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.copyRegionPlayers((CommandContext<class_2168>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetLocalRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.TO_DIM).then(class_2170.method_9244((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)CommandConstants.GROUP.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Permissions.GROUP_LIST, (SuggestionsBuilder)builder)).executes(ctx -> CommandUtil.copyRegionPlayers((CommandContext<class_2168>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetDimRegionArgument((CommandContext<class_2168>)ctx).getDim(), ArgumentUtil.getGroupArgument((CommandContext<class_2168>)ctx)))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.STATE).then(ArgumentUtil.literal(CommandConstants.TO_LOCAL).then(class_2170.method_9244((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)class_2181.method_9288()).then(class_2170.method_9244((String)CommandConstants.TARGET_REGION.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listRegionsInTargetDim(ctx, builder)).executes(ctx -> CommandUtil.copyRegionState((CommandContext<class_2168>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetLocalRegionArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.TO_DIM).then(class_2170.method_9244((String)CommandConstants.TARGET_DIM.toString(), (ArgumentType)class_2181.method_9288()).executes(ctx -> CommandUtil.copyRegionState((CommandContext<class_2168>)ctx, (IProtectedRegion)srcSupplier.apply(ctx), ArgumentUtil.getTargetDimRegionArgument((CommandContext<class_2168>)ctx).getDim())))));
    }

    public static int promptRegionInfo(CommandContext<class_2168> ctx, IProtectedRegion region) {
        MultiLineMessage.send((class_2168)ctx.getSource(), MultiLineMessage.regionInfo(region));
        return 0;
    }

    public static int promptRegionState(CommandContext<class_2168> ctx, IProtectedRegion region) {
        MultiLineMessage.send((class_2168)ctx.getSource(), MultiLineMessage.regionState(region));
        return 0;
    }

    public static int promptGroupLinks(CommandContext<class_2168> ctx, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.region.info.group.invalid", (String)"cli.msg.region.info.group.invalid", (Object[])new Object[]{group}).method_27692(class_124.field_1061));
            return -1;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), ChatComponentBuilder.buildGroupListHeader(region, group));
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), ChatLinkBuilder.buildGroupPlayerListLink(region, group));
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), ChatLinkBuilder.buildGroupTeamListLink(region, group));
        return 0;
    }

    public static int promptFlagList(CommandContext<class_2168> ctx, IProtectedRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            ResponsibleFlagPagination flagPagination = new ResponsibleFlagPagination(region, pageNo, paginationSize);
            MultiLineMessage.send((class_2168)ctx.getSource(), flagPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((class_2168)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int promptRegionFlagList(CommandContext<class_2168> ctx, IProtectedRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            RegionFlagPagination flagPagination = new RegionFlagPagination(region, pageNo, paginationSize);
            MultiLineMessage.send((class_2168)ctx.getSource(), flagPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((class_2168)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int promptRegionChildren(CommandContext<class_2168> ctx, IProtectedRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            ChildRegionPagination childRegionPagination = new ChildRegionPagination(region, region.getChildren().values().stream().toList(), pageNo, paginationSize);
            MultiLineMessage.send((class_2168)ctx.getSource(), childRegionPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((class_2168)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int promptGroupList(CommandContext<class_2168> ctx, IProtectedRegion region, String group, GroupType groupType, int pageNo) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        List<String> groupNames = ChatComponentBuilder.getGroupList(region, group, groupType);
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            GroupMemberPagination childRegionPagination = new GroupMemberPagination(region, group, groupType, groupNames, pageNo, paginationSize);
            MultiLineMessage.send((class_2168)ctx.getSource(), childRegionPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((class_2168)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    public static int setActiveState(CommandContext<class_2168> ctx, IProtectedRegion region, boolean activate) {
        region.setIsActive(activate);
        RegionManager.get().save();
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!activate), String.valueOf(activate));
        class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.state.enable.set.value", (String)"Region state of %s is now: %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), region.isActive() ? "active" : "inactive"});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
        return 0;
    }

    public static int setAlertState(CommandContext<class_2168> ctx, IProtectedRegion region, boolean showAlert) {
        region.setIsMuted(!showAlert);
        RegionManager.get().save();
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(!showAlert), String.valueOf(showAlert));
        class_5250 msg = class_2561.method_48322((String)"cli.msg.info.state.alert.set.value", (String)"Flag messages of %s are now: %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), region.isMuted() ? "muted" : "active"});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
        return 0;
    }

    private static class_5250 buildInvalidGroupMsg(String group) {
        return class_2561.method_48322((String)"cli.msg.region.info.group.invalid", (String)"Group '%s' is not defined!", (Object[])new Object[]{group});
    }

    public static int removeTeam(CommandContext<class_2168> ctx, class_270 team, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
        class_5250 teamInfo = ChatComponentBuilder.buildGroupInfo(region, team.method_1197(), GroupType.TEAM);
        if (region.getGroup(group).hasTeam(team.method_1197())) {
            region.removeTeam(team.method_1197(), group);
            RegionManager.get().save();
            class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.team.removed", (String)"Removed team '%s' (group '%s') from %s", (Object[])new Object[]{teamInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.team.not-present", (String)"Team '%s' (group '%s') is not present in %s", (Object[])new Object[]{teamInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        return 1;
    }

    private static int removePlayersByName(CommandContext<class_2168> ctx, Collection<String> playerNames, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        playerNames.forEach(playerName -> CommandUtil.removePlayer(ctx, playerName, region, group));
        return 0;
    }

    private static void removePlayer(CommandContext<class_2168> ctx, String playerName, IProtectedRegion region, String group) {
        region.getGroup(group).getPlayers().entrySet().stream().filter(e -> ((String)e.getValue()).equals(playerName)).findFirst().ifPresent(e -> CommandUtil.removePlayer(ctx, (UUID)e.getKey(), playerName, region, group));
    }

    private static int removePlayerByUUID(CommandContext<class_2168> ctx, UUID playerUuid, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        if (region.getGroup(group).hasPlayer(playerUuid)) {
            String playerName = region.getGroup(group).getPlayers().get(playerUuid);
            return CommandUtil.removePlayer(ctx, playerUuid, playerName, region, group);
        }
        return 1;
    }

    private static int removePlayers(CommandContext<class_2168> ctx, Collection<class_3222> players, IProtectedRegion region, String group) {
        players.forEach(player -> CommandUtil.removePlayer(ctx, (class_1657)player, region, group));
        return 0;
    }

    private static int removePlayer(CommandContext<class_2168> ctx, class_1657 player, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        if (region.getGroup(group).hasPlayer(player.method_5667())) {
            String playerName = region.getGroup(group).getPlayers().get(player.method_5667());
            return CommandUtil.removePlayer(ctx, player.method_5667(), playerName, region, group);
        }
        return 1;
    }

    public static int removePlayer(CommandContext<class_2168> ctx, UUID playerUuid, String playerName, IProtectedRegion region, String group) {
        class_5250 playerInfo = ChatComponentBuilder.buildGroupInfo(region, playerName, GroupType.PLAYER);
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
        if (region.getGroup(group).hasPlayer(playerUuid)) {
            region.removePlayer(playerUuid, group);
            class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.player.removed", (String)"Removed player '%s' (group '%s') from %s", (Object[])new Object[]{playerInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            RegionManager.get().save();
            return 0;
        }
        class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.player.not-present", (String)"Player '%s' (group '%s') is not present in %s", (Object[])new Object[]{playerInfo, group, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        return 1;
    }

    private static int addPlayerByUuid(CommandContext<class_2168> ctx, UUID playerUuid, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        Optional<GameProfile> cachedProfile = MojangApiHelper.lookupGameProfileInCache(ctx, playerUuid);
        if (cachedProfile.isPresent()) {
            boolean isComplete;
            GameProfile profile = cachedProfile.get();
            boolean bl = isComplete = profile.getId() != null && StringUtils.isNotBlank((CharSequence)profile.getName());
            if (isComplete) {
                class_5250 cacheSuccess = class_2561.method_48322((String)"cli.msg.info.player.lookup.cache.success", (String)"Found entry for '%s' in the cache", (Object[])new Object[]{playerUuid.toString()});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), cacheSuccess);
                return CommandUtil.addPlayer(ctx, profile.getId(), profile.getName(), region, group);
            }
            return -1;
        }
        class_5250 cacheMiss = class_2561.method_48322((String)"cli.msg.info.player.lookup.pending", (String)"No cache entry existing for '%s'. Looking up %s at Mojang...", (Object[])new Object[]{playerUuid.toString(), "uuid"});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), cacheMiss);
        CompletableFuture.runAsync(() -> MojangApiHelper.getGameProfileInfo(playerUuid, gameProfile -> {
            if (gameProfile != null) {
                class_5250 lookupSuccess = class_2561.method_48322((String)"cli.msg.info.player.lookup.api.success", (String)"Successfully retrieved game profile info for '%s' from Mojang", (Object[])new Object[]{playerUuid.toString()});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), lookupSuccess);
                CommandUtil.addPlayer(ctx, gameProfile.getId(), gameProfile.getName(), region, group);
            } else {
                class_5250 lookupFailed = class_2561.method_48322((String)"cli.msg.info.player.lookup.api.failed", (String)"Unable to retrieve game profile info for '%s' from Mojang", (Object[])new Object[]{playerUuid.toString()});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), lookupFailed);
            }
        }));
        return 0;
    }

    public static int addPlayersByName(CommandContext<class_2168> ctx, List<String> playerNames, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        playerNames.forEach(name -> CommandUtil.addPlayerByName(ctx, name, region, group));
        return 0;
    }

    private static int addPlayerByName(CommandContext<class_2168> ctx, String playerName, IProtectedRegion region, String group) {
        Optional<GameProfile> cachedProfile = MojangApiHelper.lookupGameProfileInCache(ctx, playerName);
        if (cachedProfile.isPresent()) {
            boolean isComplete;
            GameProfile profile = cachedProfile.get();
            boolean bl = isComplete = profile.getId() != null && StringUtils.isNotBlank((CharSequence)profile.getName());
            if (isComplete) {
                class_5250 cacheSuccess = class_2561.method_48322((String)"cli.msg.info.player.lookup.cache.success", (String)"Found entry for '%s' in the cache", (Object[])new Object[]{playerName});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), cacheSuccess);
                return CommandUtil.addPlayer(ctx, profile.getId(), profile.getName(), region, group);
            }
            return -1;
        }
        class_5250 cacheMiss = class_2561.method_48322((String)"cli.msg.info.player.lookup.pending", (String)"No cache entry existing for '%s'. Looking up %s at Mojang...", (Object[])new Object[]{playerName, "name"});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), cacheMiss);
        CompletableFuture.runAsync(() -> MojangApiHelper.getGameProfileInfo(playerName, gameProfile -> {
            if (gameProfile != null) {
                class_5250 lookupSuccess = class_2561.method_48322((String)"cli.msg.info.player.lookup.api.success", (String)"Successfully retrieved game profile info for '%s' from Mojang", (Object[])new Object[]{playerName});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), lookupSuccess);
                CommandUtil.addPlayer(ctx, gameProfile.getId(), gameProfile.getName(), region, group);
            } else {
                class_5250 lookupFailed = class_2561.method_48322((String)"cli.msg.info.player.lookup.api.failed", (String)"Unable to retrieve game profile info for '%s' from Mojang", (Object[])new Object[]{playerName});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), lookupFailed);
            }
        }));
        return 0;
    }

    public static int addPlayers(CommandContext<class_2168> ctx, Collection<class_3222> players, IProtectedRegion region, String group) {
        players.forEach(player -> CommandUtil.addPlayer(ctx, (class_1657)player, region, group));
        return 0;
    }

    public static int addPlayer(CommandContext<class_2168> ctx, class_1657 player, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        return CommandUtil.addPlayer(ctx, player.method_5667(), player.method_5820(), region, group);
    }

    private static int addPlayer(CommandContext<class_2168> ctx, UUID uuid, String name, IProtectedRegion region, String group) {
        class_5250 regionInfoLink = ChatLinkBuilder.buildRegionInfoLink(region);
        class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
        if (!region.hasPlayer(uuid, group)) {
            region.addPlayer(uuid, name, group);
            RegionManager.get().save();
            class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.player.added", (String)"Added player '%s' as '%s' to %s", (Object[])new Object[]{name, group, regionInfoLink});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.player.present", (String)"Player '%s' (group '%s') already present in %s", (Object[])new Object[]{name, group, regionInfoLink});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        return 1;
    }

    public static int addTeam(CommandContext<class_2168> ctx, class_270 team, IProtectedRegion region, String group) {
        if (!Permissions.GROUP_LIST.contains(group)) {
            MessageSender.sendError((class_2168)ctx.getSource(), CommandUtil.buildInvalidGroupMsg(group));
            return -1;
        }
        class_5250 regionInfoLink = ChatLinkBuilder.buildRegionInfoLink(region);
        class_5250 teamHoverInfo = ChatComponentBuilder.buildTeamHoverComponent(team);
        if (!region.hasTeam(team.method_1197(), group)) {
            region.addTeam(team.method_1197(), group);
            RegionManager.get().save();
            class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
            class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.team.added", (String)"Added team '%s' as '%s' to region %s", (Object[])new Object[]{teamHoverInfo, group, regionInfoLink});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        class_5250 msg = class_2561.method_48322((String)"cli.msg.info.region.group.team.present", (String)"Team '%s' (group '%s') already present in %s", (Object[])new Object[]{teamHoverInfo, group, regionInfoLink});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        return 1;
    }

    public static int removeFlags(CommandContext<class_2168> ctx, IProtectedRegion region, Set<RegionFlag> flags) {
        flags.forEach(flag -> CommandUtil.removeRegionFlag(ctx, region, flag));
        return 0;
    }

    public static int removeRegionFlag(CommandContext<class_2168> ctx, IProtectedRegion region, RegionFlag flag) {
        if (region.containsFlag(flag)) {
            IFlag iFlag = region.getFlag(flag.name);
            FlagEvent.RemoveFlagEvent removeFlagEvent = new FlagEvent.RemoveFlagEvent((class_2168)ctx.getSource(), region, iFlag);
            Services.EVENT.post(removeFlagEvent);
            region.removeFlag(flag.name);
            RegionManager.get().save();
            class_5250 msg = class_2561.method_48322((String)"cli.msg.flag.removed", (String)"Removed flag '%s' from %s", (Object[])new Object[]{flag.name, ChatLinkBuilder.buildRegionInfoLink(region)});
            class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        class_5250 msg = class_2561.method_48322((String)"cli.msg.flag.not-present", (String)"Flag '%s' is not present in %s", (Object[])new Object[]{flag.name, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        return 1;
    }

    public static int copyRegionFlags(CommandContext<class_2168> ctx, IProtectedRegion srcRegion, IProtectedRegion targetRegion) {
        if (srcRegion.getFlags().isEmpty()) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(srcRegion)}));
            return 1;
        }
        Set flagsToCopy = srcRegion.getFlags().flags().stream().filter(flag -> !targetRegion.containsFlag(flag.getName())).collect(Collectors.toSet());
        srcRegion.getFlags().flags().forEach(targetRegion::addFlag);
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.copy.region.flags", (String)"Copied %s flag(s) from region %s to %s", (Object[])new Object[]{flagsToCopy.size(), ChatLinkBuilder.buildRegionInfoLink(srcRegion), ChatLinkBuilder.buildRegionInfoLink(targetRegion)}));
        return 0;
    }

    public static int copyRegionState(CommandContext<class_2168> ctx, IProtectedRegion srcRegion, IProtectedRegion targetRegion) {
        targetRegion.setIsActive(srcRegion.isActive());
        targetRegion.setIsMuted(srcRegion.isMuted());
        if (srcRegion instanceof IMarkableRegion) {
            IMarkableRegion regionSource = (IMarkableRegion)srcRegion;
            if (targetRegion instanceof IMarkableRegion) {
                IMarkableRegion regionTarget = (IMarkableRegion)targetRegion;
                regionTarget.setPriority(regionSource.getPriority());
            }
        }
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.copy.region.state", (String)"Copied state from region %s to %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(srcRegion), ChatLinkBuilder.buildRegionInfoLink(targetRegion)}));
        return 0;
    }

    public static int copyRegionPlayers(CommandContext<class_2168> ctx, IProtectedRegion srcRegion, IProtectedRegion targetRegion, String group) {
        if (!srcRegion.getGroup(group).getPlayers().isEmpty()) {
            Set playerEntriesToCopy = srcRegion.getGroup(group).getPlayers().entrySet().stream().filter(entry -> !targetRegion.getGroup(group).getPlayers().containsKey(entry.getKey())).collect(Collectors.toSet());
            srcRegion.getGroup(group).getPlayers().forEach((uuid, name) -> targetRegion.getGroup(group).addPlayer((UUID)uuid, (String)name));
            RegionManager.get().save();
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.copy.region.players", (String)"Copied %s player(s) of group '%s' from %s to %s", (Object[])new Object[]{playerEntriesToCopy.size(), group, ChatLinkBuilder.buildRegionInfoLink(srcRegion), ChatLinkBuilder.buildRegionInfoLink(targetRegion)}));
            return 0;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.group.player.empty", (String)"No players defined as '%s' in %s", (Object[])new Object[]{group, ChatLinkBuilder.buildRegionInfoLink(srcRegion)}));
        return 1;
    }

    public static int copyRegionPlayers(CommandContext<class_2168> ctx, IProtectedRegion region, IProtectedRegion srcRegion) {
        return CommandUtil.copyRegionPlayers(ctx, region, srcRegion, CommandConstants.MEMBER.toString()) + CommandUtil.copyRegionPlayers(ctx, region, srcRegion, CommandConstants.OWNER.toString());
    }

    public static int clearFlags(CommandContext<class_2168> ctx, IProtectedRegion region) {
        int amount = region.getFlags().size();
        if (amount == 0) {
            class_5250 feedbackMsg = class_2561.method_48322((String)"cli.msg.info.region.flag.empty", (String)"No flags defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), feedbackMsg);
            return 1;
        }
        List<IFlag> flags = region.getFlags().flags();
        region.getFlags().clear();
        class_5250 feedbackMsg = class_2561.method_48322((String)"cli.msg.info.region.flag.cleared", (String)"Removed %s flag(s) from %s", (Object[])new Object[]{amount, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), feedbackMsg);
        RegionManager.get().save();
        return 0;
    }

    public static int clearPlayers(CommandContext<class_2168> ctx, IProtectedRegion region) {
        return CommandUtil.clearPlayers(ctx, region, "members") + CommandUtil.clearPlayers(ctx, region, "owners");
    }

    public static int clearPlayers(CommandContext<class_2168> ctx, IProtectedRegion region, String groupName) {
        int amount = region.getGroup(groupName).getPlayers().size();
        if (amount == 0) {
            class_5250 feedbackMsg = class_2561.method_48322((String)"cli.msg.info.region.players.empty", (String)"No players (group '%s') present in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), groupName});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), feedbackMsg);
            return 1;
        }
        region.getGroup(groupName).clearPlayers();
        class_5250 feedbackMsg = class_2561.method_48322((String)"cli.msg.info.region.players.cleared", (String)"Cleared %s players of group '%s' for %s\",", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), amount, groupName});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), feedbackMsg);
        RegionManager.get().save();
        return 0;
    }

    public static int clearTeams(CommandContext<class_2168> ctx, IProtectedRegion region) {
        return CommandUtil.clearPlayers(ctx, region, "members") + CommandUtil.clearPlayers(ctx, region, "owners");
    }

    public static int clearTeams(CommandContext<class_2168> ctx, IProtectedRegion region, String groupName) {
        int amount = region.getGroup(groupName).getTeams().size();
        if (amount == 0) {
            class_5250 feedbackMsg = class_2561.method_48322((String)"cli.msg.info.region.teams.empty", (String)"No teams (group '%s') present in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), groupName});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), feedbackMsg);
            return 1;
        }
        region.getGroup(groupName).clearTeams();
        class_5250 feedbackMsg = class_2561.method_48322((String)"cli.msg.info.region.teams.cleared", (String)"Cleared %s teams of group '%s' for %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), amount, groupName});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), feedbackMsg);
        RegionManager.get().save();
        return 0;
    }

    public static int clearGroups(CommandContext<class_2168> ctx, IProtectedRegion region, String groupName) {
        return CommandUtil.clearTeams(ctx, region, groupName) + CommandUtil.clearPlayers(ctx, region, groupName);
    }

    public static int addAllFlags(CommandContext<class_2168> ctx, IProtectedRegion region) {
        return CommandUtil.addFlags(ctx, region, RegionFlag.getFlags());
    }

    public static int addFlag(CommandContext<class_2168> ctx, IProtectedRegion region, RegionFlag flag) {
        return CommandUtil.addFlag(ctx, region, flag, FlagState.DENIED);
    }

    public static int addFlag(CommandContext<class_2168> ctx, IProtectedRegion region, RegionFlag flag, FlagState state) {
        return CommandUtil.addRegionFlag(ctx, region, flag, state);
    }

    public static int addFlags(CommandContext<class_2168> ctx, IProtectedRegion region, Set<RegionFlag> flags) {
        flags.forEach(flag -> CommandUtil.addRegionFlag(ctx, region, flag));
        return 0;
    }

    public static int addRegionFlag(CommandContext<class_2168> ctx, IProtectedRegion region, RegionFlag flag, FlagState state) {
        if (region.getRegionType() == RegionType.LOCAL && flag == RegionFlag.ENTER_DIM) {
            class_5250 msg = class_2561.method_43470((String)"Flag 'enter-dim' is currently not supported for local regions.");
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
            return 1;
        }
        if (!region.containsFlag(flag)) {
            BooleanFlag iFlag = switch (flag.type) {
                case FlagType.BOOLEAN_FLAG -> new BooleanFlag(flag, state, false);
                default -> throw new IllegalArgumentException("Unexpected value = " + ((Object)((Object)flag)).getClass().getName());
            };
            FlagEvent.AddFlagEvent addFlagEvent = new FlagEvent.AddFlagEvent((class_2168)ctx.getSource(), region, iFlag);
            Services.EVENT.post(addFlagEvent);
            region.addFlag(iFlag);
            RegionManager.get().save();
            class_5250 flagLink = ChatLinkBuilder.buildFlagInfoLink(region, iFlag);
            class_5250 msg = class_2561.method_48322((String)"cli.msg.flag.added", (String)"Added flag '%s' to %s", (Object[])new Object[]{flagLink, ChatLinkBuilder.buildRegionInfoLink(region)});
            class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), Messages.substitutable("%s %s", msg, undoLink));
            return 0;
        }
        class_5250 msg = class_2561.method_48322((String)"cli.msg.flag.present", (String)"Flag '%s' is already present in %s", (Object[])new Object[]{flag.name, ChatLinkBuilder.buildRegionInfoLink(region)});
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), msg);
        return 1;
    }

    public static int addRegionFlag(CommandContext<class_2168> ctx, IProtectedRegion region, RegionFlag flag) {
        return CommandUtil.addRegionFlag(ctx, region, flag, FlagState.DENIED);
    }
}

