/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class LevelRegionDataArgumentType
implements ArgumentType<LevelRegionData> {
    private static final Collection<String> EXAMPLES = RegionDataManager.getLevelNames();
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(dim -> class_2561.method_48322((String)"cli.arg.dim.invalid", (String)"Dimension '%s' does not exist!", (Object[])new Object[]{dim}));

    public static LevelRegionDataArgumentType levelData() {
        return new LevelRegionDataArgumentType();
    }

    public static LevelRegionData getDimRegion(CommandContext<class_2168> context, String dim) throws CommandSyntaxException {
        class_2960 levelRl = (class_2960)context.getArgument(dim, class_2960.class);
        boolean isValidDimResourceLocation = ((class_2168)context.getSource()).method_29310().stream().map(class_5321::method_29177).anyMatch(loc -> loc.equals((Object)levelRl));
        if (isValidDimResourceLocation) {
            LevelRegionData dimCache = RegionDataManager.getOrCreate(levelRl);
            if (dimCache == null) {
                throw ERROR_INVALID_VALUE.create((Object)levelRl.toString());
            }
            return dimCache;
        }
        throw ERROR_INVALID_VALUE.create((Object)levelRl.toString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof class_2168) {
            return class_2172.method_9265(RegionDataManager.getLevelNames(), (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public LevelRegionData parse(StringReader reader) throws CommandSyntaxException {
        class_2960 levelRl = class_2960.method_12835((StringReader)reader);
        if (RegionDataManager.hasLevel(levelRl)) {
            return RegionDataManager.getOrCreate(levelRl);
        }
        return null;
    }
}

