/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1538;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1538.class})
public abstract class LightningEntityMixin {
    @Inject(method={"clearCopperOnLightningStrike"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlockAndUpdate(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Z")}, cancellable=true, allow=1)
    private static void cleanOxidationOnHitBlock(class_1937 world, class_2338 pos, CallbackInfo ci) {
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.LIGHTNING_PROT, HandlerUtil.getDimKey(world));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }

    @Inject(method={"spawnFire"}, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/BaseFireBlock;getState(Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;", ordinal=0)}, cancellable=true, allow=1)
    public void onSpawnFireFromLightning(int extraIgnitions, CallbackInfo ci, class_2338 blockPos) {
        class_1538 lightningEntity = (class_1538)this;
        if (HandlerUtil.isServerSide((class_1297)lightningEntity)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.LIGHTNING_PROT, HandlerUtil.getDimKey((class_1297)lightningEntity), null);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
        }
    }
}

