/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.core;

import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.IRegionManager;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public final class RegionManager
implements IRegionManager {
    private RegionManager() {
    }

    public static RegionManager get() {
        return new RegionManager();
    }

    @Override
    public GlobalRegion getGlobalRegion() {
        return RegionDataManager.getGlobalRegion();
    }

    @Override
    public void resetGlobal() {
        RegionDataManager.getGlobalRegionData().reset();
        this.save();
    }

    @Override
    public Optional<IProtectedRegion> getDimensionalRegion(ResourceKey<Level> dim) {
        Optional<LevelRegionData> cache = this.getLevelRegionData(dim);
        return cache.map(LevelRegionData::getDim);
    }

    @Override
    public Optional<LevelRegionData> getLevelRegionData(ResourceKey<Level> dim) {
        return RegionDataManager.getLevelRegionData(dim);
    }

    @Override
    public void save() {
        RegionDataManager.save(true);
    }

    @Override
    public Optional<IDimensionRegionApi> getDimRegionApi(ResourceKey<Level> dim) {
        if (RegionDataManager.hasLevel(dim.location())) {
            LevelRegionData levelRegionData = RegionDataManager.getOrCreate(dim.location());
            return Optional.of(new DimensionRegionApi(levelRegionData));
        }
        return Optional.empty();
    }

    @Override
    public Optional<IDimensionRegionApi> getDimRegionApiByKey(String dimKey) {
        return this.getDimRegionApi(this.getDimApiKey(dimKey));
    }

    @Override
    public ResourceKey<Level> getDimApiKey(String dimKey) {
        ResourceLocation rl = ResourceLocation.tryParse((String)dimKey);
        if (rl == null) {
            throw new IllegalArgumentException("Invalid dim key: " + dimKey);
        }
        return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rl);
    }

    @Override
    public boolean hasLevelData(ResourceKey<Level> dim) {
        return RegionDataManager.hasLevel(dim.location());
    }

    @Override
    public boolean createDimRegion(ResourceKey<Level> dim) {
        if (this.hasLevelData(dim)) {
            return false;
        }
        RegionDataManager.getOrCreate(dim);
        this.save();
        return true;
    }

    @Override
    public Set<ResourceLocation> getLevels() {
        return RegionDataManager.getLevels();
    }

    public Set<String> getLevelNames() {
        return RegionDataManager.getLevelNames();
    }

    @Override
    public void resetLevelData(ResourceKey<Level> dim) {
        RegionDataManager.resetLevelData(dim);
        this.save();
    }

    public static class DimensionRegionApi
    implements IDimensionRegionApi {
        private final LevelRegionData levelData;

        private DimensionRegionApi(LevelRegionData levelData) {
            this.levelData = levelData;
        }

        @Override
        public void save() {
            RegionManager.get().save();
        }

        @Override
        public Optional<IMarkableRegion> getLocalRegion(String name) {
            IMarkableRegion region = this.levelData.getLocal(name);
            return region != null ? Optional.of(region) : Optional.empty();
        }

        @Override
        public ResourceKey<Level> getDimKey() {
            return this.levelData.getDim().getDim();
        }

        @Override
        public LevelRegionData getCache() {
            return this.levelData;
        }

        @Override
        public boolean hasLocal(String name) {
            return this.levelData.hasLocal(name);
        }

        @Override
        public boolean addLocalRegion(IMarkableRegion region) {
            if (this.hasLocal(region.getName())) {
                return false;
            }
            this.levelData.addLocal(region);
            return true;
        }

        @Override
        public boolean removeLocal(IMarkableRegion region) {
            return this.removeLocalRegion(region.getName());
        }

        @Override
        public boolean removeLocalRegion(String regionName) {
            Optional<IMarkableRegion> localRegion;
            if (this.hasLocal(regionName) && (localRegion = this.getLocalRegion(regionName)).isPresent()) {
                this.levelData.removeLocal(localRegion.get());
                return true;
            }
            return false;
        }

        @Override
        public boolean hasRegionAt(BlockPos pos) {
            return !this.getRegionsAt(pos).isEmpty();
        }

        @Override
        public List<IMarkableRegion> getRegionsAt(BlockPos pos) {
            return this.getAllLocalRegions().stream().filter(region -> region.contains(pos)).collect(Collectors.toList());
        }

        @Override
        public Collection<IMarkableRegion> getAllLocalRegions() {
            return this.levelData.getLocalList();
        }

        @Override
        public List<IMarkableRegion> getRegionsIn(Vec3i pos1, Vec3i pos2) {
            return this.getRegionsInBox(BoundingBox.fromCorners((Vec3i)pos1, (Vec3i)pos2));
        }

        @Override
        public List<IMarkableRegion> getRegionsInCoords(int x1, int y1, int z1, int x2, int y2, int z2) {
            return this.getRegionsIn((Vec3i)new BlockPos(x1, y1, z1), (Vec3i)new BlockPos(x2, y2, z2));
        }

        @Override
        public List<IMarkableRegion> getRegionsInBox(BoundingBox blockBox) {
            CuboidArea predicateArea = new CuboidArea(blockBox);
            return this.getAllLocalRegions().stream().filter(r -> predicateArea.containsOther(r.getArea())).toList();
        }

        @Override
        public List<IMarkableRegion> getRegionsAround(BlockPos pos, int radius) {
            SphereArea predicateArea = new SphereArea(pos, radius);
            return this.getAllLocalRegions().stream().filter(r -> predicateArea.intersects(r.getArea())).toList();
        }

        @Override
        public List<IMarkableRegion> getIntersectingRegions(BoundingBox blockBox) {
            CuboidArea predicateArea = new CuboidArea(blockBox);
            return this.getAllLocalRegions().stream().filter(r -> predicateArea.intersects(r.getArea())).collect(Collectors.toList());
        }

        @Override
        public List<IMarkableRegion> getIntersectingRegions(IMarkableRegion region) {
            return this.getAllLocalRegions().stream().filter(r -> !r.equals(region)).filter(r -> r.getArea().intersects(region.getArea())).collect(Collectors.toList());
        }

        @Override
        public List<IMarkableRegion> getContainingRegions(IMarkableRegion region) {
            return this.getAllLocalRegions().stream().filter(r -> !r.equals(region)).filter(r -> r.getArea().containsOther(region.getArea())).collect(Collectors.toList());
        }

        @Override
        public List<IMarkableRegion> getContainedRegions(IMarkableRegion region) {
            return this.getAllLocalRegions().stream().filter(r -> !r.equals(region)).filter(r -> region.getArea().containsOther(r.getArea())).collect(Collectors.toList());
        }

        @Override
        public Optional<IMarkableRegion> getInvolvedRegionFor(BlockPos position) {
            List<IMarkableRegion> regionsForPos = this.getInvolvedRegionsFor(position);
            if (regionsForPos.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Collections.max(regionsForPos, Comparator.comparing(IMarkableRegion::getPriority)));
        }

        private List<IMarkableRegion> getInvolvedRegionsFor(BlockPos pos) {
            return this.getRegionsAt(pos).stream().filter(IProtectedRegion::isActive).collect(Collectors.toList());
        }

        @Override
        public Optional<IProtectedRegion> findResponsibleRegion(BlockPos pos) {
            Optional<IMarkableRegion> maybeRegion = this.getInvolvedRegionFor(pos);
            if (maybeRegion.isEmpty()) {
                DimensionalRegion dimRegion = this.levelData.getDim();
                if (dimRegion.isActive()) {
                    return Optional.of(dimRegion);
                }
                return RegionManager.get().getGlobalRegion().isActive() ? Optional.of(RegionManager.get().getGlobalRegion()) : Optional.empty();
            }
            IProtectedRegion region = maybeRegion.get();
            return Optional.of(region);
        }
    }
}

