/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.region.RegionEvent;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.CommandUtil;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.flag.BooleanFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.CuboidRegion;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.core.region.SphereRegion;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionsInDimensionPagination;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import org.jetbrains.annotations.Nullable;

class DimensionCommands {
    private DimensionCommands() {
    }

    private static List<String> getRegionNameSuggestions() {
        String examples = Component.translatableWithFallback((String)"cli.region.name.examples", (String)"newRegion,spawn,home,town,arena").getString();
        return Arrays.asList(examples.split(","));
    }

    static String getRandomExample() {
        List<String> regionNameSuggestions = DimensionCommands.getRegionNameSuggestions();
        return regionNameSuggestions.get(new Random().nextInt(regionNameSuggestions.size()));
    }

    static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.DIM).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.DIM.toString(), (ArgumentType)DimensionArgument.dimension()).executes(ctx -> CommandUtil.promptRegionInfo((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(ArgumentUtil.literal(CommandConstants.INFO).executes(ctx -> CommandUtil.promptRegionInfo((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim())))).then(CommandUtil.buildListSubCommand(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(CommandUtil.buildClearSubCommand(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(CommandUtil.buildAddSubCommand(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(CommandUtil.buildRemoveSubCommand(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(CommandUtil.buildCopySubCommand(ctx -> ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.NUKE_DISPLAY_ENTITIES).executes(ctx -> DimensionCommands.nukeDisplayEntities((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getLevel()))).then(Commands.argument((String)CommandConstants.DIM.toString(), (ArgumentType)DimensionArgument.dimension()).executes(ctx -> DimensionCommands.nukeDisplayEntities((CommandContext<CommandSourceStack>)ctx, DimensionArgument.getDimension((CommandContext)ctx, (String)CommandConstants.DIM.toString())))))).then(ArgumentUtil.literal(CommandConstants.LIST).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.LOCAL).executes(ctx -> DimensionCommands.promptDimensionRegionList((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), 0))).then(Commands.argument((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> DimensionCommands.promptDimensionRegionList((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getPageNoArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.DELETE).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.attemptDeleteRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getRegionArgument((CommandContext<CommandSourceStack>)ctx)))).then(ArgumentUtil.literal(CommandConstants.FOR_SURE).executes(ctx -> DimensionCommands.deleteRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getRegionArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.DELETE_ALL).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.REGIONS).executes(ctx -> DimensionCommands.attemptDeleteRegions((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx)))).then(ArgumentUtil.literal(CommandConstants.FOREVER).then(ArgumentUtil.literal(CommandConstants.SERIOUSLY).executes(ctx -> DimensionCommands.deleteRegions((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.STATE).executes(ctx -> CommandUtil.promptRegionState((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim()))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ALERT).executes(ctx -> CommandUtil.setAlertState((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim(), ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim().isMuted()))).then(Commands.argument((String)CommandConstants.ALERT.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CommandUtil.setAlertState((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim(), ArgumentUtil.getAlertArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.ALERT_LOCAL).then(Commands.argument((String)CommandConstants.ALERT.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> DimensionCommands.setAlertStateForAllLocal((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getAlertArgument((CommandContext<CommandSourceStack>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ENABLE).executes(ctx -> CommandUtil.setActiveState((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim(), !ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim().isActive()))).then(Commands.argument((String)CommandConstants.ENABLE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CommandUtil.setActiveState((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx).getDim(), ArgumentUtil.getEnableArgument((CommandContext<CommandSourceStack>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.ENABLE_LOCAL).then(Commands.argument((String)CommandConstants.ENABLE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> DimensionCommands.setActiveStateForAllLocal((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getEnableArgument((CommandContext<CommandSourceStack>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.CREATE).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(Collections.singletonList(DimensionCommands.getRandomExample()), (SuggestionsBuilder)builder)).then(Commands.literal((String)AreaType.CUBOID.areaType).then(Commands.argument((String)CommandConstants.POS1.toString(), (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.POS2.toString(), (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> DimensionCommands.createCuboidRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)CommandConstants.POS1.toString()), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)CommandConstants.POS2.toString()), null))).then(Commands.argument((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.createCuboidRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)CommandConstants.POS1.toString()), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)CommandConstants.POS2.toString()), ArgumentUtil.getContainingOwnedRegionArgument((CommandContext<CommandSourceStack>)ctx)))))))).then(Commands.literal((String)AreaType.SPHERE.areaType).then(Commands.argument((String)CommandConstants.CENTER_POS.toString(), (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> DimensionCommands.createSphereRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()), null))).then(Commands.argument((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.createSphereRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<CommandSourceStack>)ctx), ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx), BlockPosArgument.getSpawnablePos((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()), (IProtectedRegion)ArgumentUtil.getContainingOwnedRegionArgument((CommandContext<CommandSourceStack>)ctx))))))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.RESET).then(ArgumentUtil.literal(CommandConstants.DIM).executes(ctx -> DimensionCommands.resetDimRegion((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx))))).then(ArgumentUtil.literal(CommandConstants.REGIONS).executes(ctx -> DimensionCommands.resetLocalRegions((CommandContext<CommandSourceStack>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<CommandSourceStack>)ctx))))));
    }

    private static int nukeDisplayEntities(CommandContext<CommandSourceStack> ctx, ServerLevel level) {
        List entities = level.getEntities(EntityTypeTest.forClass(Display.class), entity -> {
            boolean containsTextTag = entity.getTags().contains(VisualizationManager.REGION_TEXT_DISPLAY_TAG.toString());
            boolean containsBlockTag = entity.getTags().contains(VisualizationManager.REGION_BLOCK_DISPLAY_TAG.toString());
            return containsTextTag || containsBlockTag;
        });
        int entityAmount = entities.size();
        entities.forEach(e -> e.remove(Entity.RemovalReason.DISCARDED));
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"Nuked all (%s) yawp entities in '%s'", (String)"Nuked all (%s) yawp entities in '%s'", (Object[])new Object[]{entityAmount, level.dimension().location().toString()}));
        return 0;
    }

    private static int setActiveStateForAllLocal(CommandContext<CommandSourceStack> ctx, LevelRegionData dimCache, boolean enable) {
        if (dimCache != null) {
            dimCache.getLocalList().forEach(region -> region.setIsActive(enable));
            if (enable) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.all.set.on.value", (String)"Activates alert for all local regions of %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim())}));
            } else {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.state.enable.all.set.off.value", (String)"Deactivated all local regions of %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim())}));
            }
            RegionManager.get().save();
            return 0;
        }
        return 1;
    }

    private static int setAlertStateForAllLocal(CommandContext<CommandSourceStack> ctx, LevelRegionData dimCache, boolean mute) {
        if (dimCache != null) {
            dimCache.getLocalList().forEach(region -> region.setIsMuted(mute));
            if (mute) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.state.alert.all.set.on.value", (String)"Activated alert for all local regions of %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim())}));
            } else {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.region.state.alert.all.set.off.value", (String)"Deactivated alert for all local regions of %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim())}));
            }
            RegionManager.get().save();
            return 0;
        }
        return 1;
    }

    private static int resetLocalRegions(CommandContext<CommandSourceStack> ctx, LevelRegionData dimCache) {
        dimCache.getLocalList().forEach(region -> {
            region.resetGroups();
            region.setIsActive(true);
            region.setIsMuted(false);
        });
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.reset.all.confirm", (String)"Successfully reset all local regions in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim())}));
        return 0;
    }

    private static int resetDimRegion(CommandContext<CommandSourceStack> ctx, LevelRegionData dimCache) {
        DimensionalRegion dimRegion = dimCache.getDim();
        dimRegion.resetGroups();
        dimRegion.setIsActive(true);
        dimRegion.setIsMuted(false);
        dimRegion.getFlags().clear();
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.reset.confirm", (String)"Successfully reset dimensional region %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(dimRegion)}));
        return 0;
    }

    private static int createRegion(CommandContext<CommandSourceStack> ctx, String regionName, LevelRegionData levelData, IMarkableRegion region, IProtectedRegion parent) {
        ServerPlayer player;
        int res = levelData.isValidRegionName(regionName);
        if (res == -1) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.name.invalid", (String)"Invalid region name supplied: '%s'", (Object[])new Object[]{regionName}));
            return res;
        }
        if (res == 1) {
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.name.exists", (String)"Dimension %s already contains region with name %s", (Object[])new Object[]{levelData.getDim().getName(), ChatLinkBuilder.buildRegionInfoLink(levelData.getLocal(regionName))}));
            return res;
        }
        try {
            player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            player = null;
        }
        if (Services.EVENT.post(new RegionEvent.Create(region, (Player)player))) {
            return 1;
        }
        Services.REGION_CONFIG.getDefaultFlags().stream().map(RegionFlag::fromId).forEach(flag -> region.addFlag(new BooleanFlag((RegionFlag)((Object)flag))));
        levelData.addLocal(parent, region);
        LocalRegions.ensureHigherRegionPriorityFor(region, Services.REGION_CONFIG.getDefaultPriority());
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.dim.info.region.create.success", (String)"Successfully created region %s (parent: %s)", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), ChatLinkBuilder.buildRegionInfoLink(parent)}));
        return 0;
    }

    public static int createCuboidRegion(CommandContext<CommandSourceStack> ctx, String regionName, BlockPos pos1, BlockPos pos2, @Nullable IProtectedRegion parentRegion) {
        Optional<LevelRegionData> dimCache = RegionManager.get().getLevelRegionData((ResourceKey<Level>)((CommandSourceStack)ctx.getSource()).getLevel().dimension());
        if (dimCache.isPresent()) {
            return DimensionCommands.createCuboidRegion(ctx, regionName, dimCache.get(), pos1, pos2, parentRegion);
        }
        Constants.LOGGER.error("Error getting dimension cache for {}", (Object)((CommandSourceStack)ctx.getSource()).getLevel().dimension().location().toString());
        return -1;
    }

    public static int createSphereRegion(CommandContext<CommandSourceStack> ctx, String regionName, BlockPos centerPos, int radius, @Nullable IProtectedRegion parentRegion) {
        Optional<LevelRegionData> dimCache = RegionManager.get().getLevelRegionData((ResourceKey<Level>)((CommandSourceStack)ctx.getSource()).getLevel().dimension());
        if (dimCache.isPresent()) {
            return DimensionCommands.createSphereRegion(ctx, regionName, dimCache.get(), centerPos, radius, parentRegion);
        }
        Constants.LOGGER.error("Error getting dimension cache for {}", (Object)((CommandSourceStack)ctx.getSource()).getLevel().dimension().location().toString());
        return -1;
    }

    public static int createCuboidRegion(CommandContext<CommandSourceStack> ctx, String regionName, LevelRegionData levelData, BlockPos pos1, BlockPos pos2, @Nullable IProtectedRegion parentRegion) {
        CuboidRegion region = new CuboidRegion(regionName, new CuboidArea(pos1, pos2), null, levelData.getDimKey());
        IProtectedRegion parent = parentRegion == null ? levelData.getDim() : parentRegion;
        return DimensionCommands.createRegion(ctx, regionName, levelData, region, parent);
    }

    private static int createSphereRegion(CommandContext<CommandSourceStack> ctx, String regionName, LevelRegionData levelData, BlockPos centerPos, BlockPos radiusPos, @Nullable IProtectedRegion parentRegion) {
        SphereRegion region = new SphereRegion(regionName, new SphereArea(centerPos, radiusPos), null, levelData.getDimKey());
        IProtectedRegion parent = parentRegion == null ? levelData.getDim() : parentRegion;
        return DimensionCommands.createRegion(ctx, regionName, levelData, region, parent);
    }

    public static int createSphereRegion(CommandContext<CommandSourceStack> ctx, String regionName, LevelRegionData levelData, BlockPos centerPos, int radius, @Nullable IProtectedRegion parentRegion) {
        SphereRegion region = new SphereRegion(regionName, new SphereArea(centerPos, radius), null, levelData.getDimKey());
        IProtectedRegion parent = parentRegion == null ? levelData.getDim() : parentRegion;
        return DimensionCommands.createRegion(ctx, regionName, levelData, region, parent);
    }

    public static int attemptDeleteRegion(CommandContext<CommandSourceStack> ctx, LevelRegionData levelData, IMarkableRegion region) {
        if (levelData.hasLocal(region.getName())) {
            MutableComponent removeRegionLink = ChatLinkBuilder.buildRemoveRegionLink(region);
            MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.region.remove.attempt", (String)"Attempt to remove region %s from %s. Confirm by clicking here %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), ChatLinkBuilder.buildRegionInfoLink(levelData.getDim()), removeRegionLink}));
            return 0;
        }
        return 1;
    }

    public static int deleteRegion(CommandContext<CommandSourceStack> ctx, IMarkableRegion region) {
        Optional<LevelRegionData> dimCache = RegionManager.get().getLevelRegionData(region.getDim());
        if (dimCache.isPresent()) {
            return DimensionCommands.deleteRegion(ctx, dimCache.get(), region);
        }
        Constants.LOGGER.error("Error getting dimension cache for region {} in {}", (Object)region.getName(), (Object)region.getDim().location().toString());
        return -1;
    }

    public static int deleteRegion(CommandContext<CommandSourceStack> ctx, LevelRegionData levelData, IMarkableRegion region) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            player = null;
        }
        if (Services.EVENT.post(new RegionEvent.Remove(region, (Player)player))) {
            return 1;
        }
        if (levelData.hasLocal(region.getName())) {
            if (!region.getChildren().isEmpty()) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.region.remove.fail.hasChildren", (String)"Region %s can't be deleted because it has child regions.", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
                return -1;
            }
            RegionType parentType = region.getParent().getRegionType();
            if (parentType == RegionType.DIMENSION) {
                levelData.removeLocal(region);
                RegionManager.get().save();
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.region.remove.confirm", (String)"Removed region '%s' from %s", (Object[])new Object[]{region.getName(), ChatLinkBuilder.buildRegionInfoLink(levelData.getDim())}));
                return 0;
            }
            if (parentType == RegionType.LOCAL) {
                MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.region.remove.fail.hasParent", (String)"Region %s can't be deleted because it has a Local Regions as parent.", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
                return 1;
            }
        }
        return 1;
    }

    private static int attemptDeleteRegions(CommandContext<CommandSourceStack> ctx, LevelRegionData dimCache) {
        int amount = dimCache.getLocalNames().size();
        MutableComponent removeAllRegionsLink = ChatLinkBuilder.buildRemoveAllRegionsLink(dimCache);
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.region.remove.all.attempt", (String)"Attempt to remove all (%s) regions from dimension %s. Confirm removal by clicking here %s", (Object[])new Object[]{amount, ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim()), removeAllRegionsLink}));
        return 0;
    }

    private static int deleteRegions(CommandContext<CommandSourceStack> ctx, LevelRegionData levelData) {
        int amount = levelData.regionCount();
        levelData.clearLocals();
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((CommandSourceStack)ctx.getSource(), Component.translatableWithFallback((String)"cli.msg.info.dim.region.remove.all.confirm", (String)"Removed %s regions from dimension %s", (Object[])new Object[]{amount, ChatLinkBuilder.buildRegionInfoLink(levelData.getDim())}));
        return 0;
    }

    private static int promptDimensionRegionList(CommandContext<CommandSourceStack> ctx, LevelRegionData levelData, int pageNo) {
        List<IProtectedRegion> regionsForDim = levelData.getLocalList().stream().map(region -> region).sorted(Comparator.comparing(IProtectedRegion::getName)).toList();
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            RegionsInDimensionPagination childRegionPagination = new RegionsInDimensionPagination(levelData, regionsForDim, pageNo, paginationSize);
            MultiLineMessage.send((CommandSourceStack)ctx.getSource(), childRegionPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((CommandSourceStack)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }
}

