/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.CenteredArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.apache.commons.lang3.NotImplementedException;

public class VerticalCylinderArea
extends CenteredArea {
    private final BlockPos centerTopPos;
    private final int distance;
    private final int radius;

    public VerticalCylinderArea(BlockPos centerBottomPos, BlockPos scopePos) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = new BlockPos(centerBottomPos.getX(), scopePos.getY(), centerBottomPos.getZ());
        this.radius = AreaUtil.distanceManhattan(centerBottomPos, new BlockPos(scopePos.getX(), centerBottomPos.getY(), scopePos.getZ()));
        this.distance = AreaUtil.distanceManhattan(centerBottomPos, this.centerTopPos);
    }

    public VerticalCylinderArea(BlockPos centerBottomPos, int radius, int distance) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = centerBottomPos.offset(0, distance, 0);
        this.radius = radius;
        this.distance = distance;
    }

    @Override
    public Vec3i getCenter() {
        return new Vec3i(this.center.getX(), this.center.getY(), this.center.getZ());
    }

    @Override
    public boolean contains(BlockPos pos) {
        BlockPos dist = this.centerTopPos.subtract((Vec3i)this.center);
        boolean b1 = this.multiply(pos.subtract((Vec3i)this.center), dist).compareTo((Vec3i)BlockPos.ZERO) >= 0;
        boolean b2 = this.multiply(pos.subtract((Vec3i)this.centerTopPos), dist).compareTo((Vec3i)BlockPos.ZERO) <= 0;
        boolean isBetweenPlanes = b1 && b2;
        BlockPos crossProduct = pos.subtract((Vec3i)this.center).cross((Vec3i)dist);
        double distance = AreaUtil.length(crossProduct) / (double)AreaUtil.distanceManhattan(this.centerTopPos, this.center);
        boolean isInsideSurface = distance <= (double)this.radius;
        return isBetweenPlanes && isInsideSurface;
    }

    @Override
    public Set<BlockPos> getHull() {
        throw new NotImplementedException("CylinderArea.getHull() not implemented yet");
    }

    @Override
    public Set<BlockPos> getFrame() {
        return Set.of();
    }

    @Override
    public Set<BlockPos> getMinimalOutline() {
        return Set.of();
    }

    public int getDistance() {
        return this.distance;
    }

    public int getRadius() {
        return this.radius;
    }

    public BlockPos multiply(BlockPos p1, BlockPos p2) {
        return new BlockPos(p1.getX() * p2.getX(), p1.getY() * p2.getY(), p1.getZ() * p2.getZ());
    }

    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public MarkedAreaType<?> getType() {
        return null;
    }

    public String toString() {
        return "Cylinder " + AreaUtil.blockPosStr(this.center) + " with radius " + this.radius + " and height " + this.distance + ".";
    }
}

