/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler.flags;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.handler.flags.NeoForgeHandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityEvent;
import net.neoforged.neoforge.event.entity.EntityMobGriefingEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@EventBusSubscriber(modid="yawp", bus=EventBusSubscriber.Bus.GAME)
public class GrievingFlagHandler {
    private GrievingFlagHandler() {
    }

    @SubscribeEvent
    public static void onFarmLandTrampled(BlockEvent.FarmlandTrampleEvent event) {
        if (HandlerUtil.isServerSide(event.getEntity())) {
            Entity trampler = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey(trampler);
            Player player = trampler instanceof Player ? (Player)trampler : null;
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.TRAMPLE_FARMLAND, dim, player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, denyResult -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(denyResult);
            });
            if (flagState == FlagState.DENIED) {
                return;
            }
            if (trampler instanceof Player) {
                checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.TRAMPLE_FARMLAND_PLAYER, dim, player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(denyResult);
                });
            } else {
                checkEvent = new FlagCheckEvent(event.getPos(), RegionFlag.TRAMPLE_FARMLAND_OTHER, dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDestroyBlock(LivingDestroyBlockEvent event) {
        if (HandlerUtil.isServerSide((Entity)event.getEntity())) {
            LivingEntity destroyer = event.getEntity();
            BlockPos target = event.getPos();
            FlagCheckEvent checkEvent = null;
            if (destroyer instanceof EnderDragon && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.DRAGON_BLOCK_PROT, HandlerUtil.getDimKey((Entity)destroyer)))) {
                return;
            }
            if (destroyer instanceof WitherBoss && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.WITHER_BLOCK_PROT, HandlerUtil.getDimKey((Entity)destroyer)))) {
                return;
            }
            if (destroyer instanceof Zombie && Services.EVENT.post(checkEvent = new FlagCheckEvent(target, RegionFlag.ZOMBIE_DOOR_PROT, HandlerUtil.getDimKey((Entity)destroyer)))) {
                return;
            }
            if (checkEvent != null) {
                FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDropLoot(LivingDropsEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            LivingEntity lootEntity = event.getEntity();
            Player player = lootEntity instanceof Player ? (Player)lootEntity : null;
            FlagCheckEvent checkEvent = new FlagCheckEvent(lootEntity.blockPosition(), RegionFlag.DROP_LOOT_ALL, (ResourceKey<Level>)event.getEntity().level().dimension(), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, denyResult -> {
                event.setCanceled(true);
                MessageSender.sendFlagMsg(denyResult);
            });
            if (flagState == FlagState.DENIED) {
                return;
            }
            if (player != null) {
                checkEvent = new FlagCheckEvent(lootEntity.blockPosition(), RegionFlag.DROP_LOOT_PLAYER, (ResourceKey<Level>)player.level().dimension(), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(denyResult);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onEntityXpDrop(LivingExperienceDropEvent event) {
        if (NeoForgeHandlerUtil.isServerSide((EntityEvent)event)) {
            Player player = event.getAttackingPlayer();
            LivingEntity xpDroppingEntity = event.getEntity();
            ResourceKey<Level> dim = HandlerUtil.getDimKey((Entity)xpDroppingEntity);
            BlockPos pos = xpDroppingEntity.blockPosition();
            if (player != null) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.XP_DROP_ALL, dim);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagState flagState = FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanceled(true));
                if (flagState == FlagState.DENIED) {
                    return;
                }
                checkEvent = new FlagCheckEvent(pos, RegionFlag.XP_DROP_PLAYER, dim, player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                flagState = FlagEvaluator.processCheck(checkEvent, denyResult -> {
                    event.setCanceled(true);
                    MessageSender.sendFlagMsg(denyResult);
                });
                if (flagState == FlagState.DENIED) {
                    return;
                }
                if (HandlerUtil.isMonster((Entity)xpDroppingEntity)) {
                    checkEvent = new FlagCheckEvent(pos, RegionFlag.XP_DROP_MONSTER, dim);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    flagState = FlagEvaluator.processCheck(checkEvent, denyResult -> {
                        event.setCanceled(true);
                        MessageSender.sendFlagMsg(denyResult);
                    });
                    if (flagState == FlagState.DENIED) {
                        // empty if block
                    }
                } else {
                    checkEvent = new FlagCheckEvent(pos, RegionFlag.XP_DROP_OTHER, dim);
                    if (Services.EVENT.post(checkEvent)) {
                        return;
                    }
                    FlagEvaluator.processCheck(checkEvent, denyResult -> {
                        event.setCanceled(true);
                        MessageSender.sendFlagMsg(denyResult);
                    });
                }
            }
            if (xpDroppingEntity instanceof Player) {
                Player targetPlayer = (Player)xpDroppingEntity;
                FlagCheckEvent checkEvent = new FlagCheckEvent(targetPlayer.blockPosition(), RegionFlag.KEEP_XP, HandlerUtil.getDimKey((Entity)targetPlayer), targetPlayer);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.process(checkEvent).onAllow(res -> event.setCanceled(true));
            }
        }
    }

    @SubscribeEvent
    public static void onMobGriefing(EntityMobGriefingEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        if (HandlerUtil.isServerSide(event.getEntity())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(event.getEntity().blockPosition(), RegionFlag.MOB_GRIEFING, HandlerUtil.getDimKey(event.getEntity()));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanGrief(false));
            if (flagState == FlagState.DENIED) {
                return;
            }
            if (event.getEntity() instanceof EnderMan) {
                checkEvent = new FlagCheckEvent(event.getEntity().blockPosition(), RegionFlag.ENDERMAN_GRIEFING, HandlerUtil.getDimKey(event.getEntity()));
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> event.setCanGrief(false));
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (HandlerUtil.isServerSide(event.getLevel())) {
            ResourceKey dim = event.getLevel().dimension();
            Set<Object> protectedBlocks = event.getAffectedBlocks().stream().filter(GrievingFlagHandler.explosionBlockPosFilterPredicate((ResourceKey<Level>)dim, RegionFlag.EXPLOSION_BLOCK)).collect(Collectors.toSet());
            Set<Object> protectedEntities = event.getAffectedEntities().stream().filter(GrievingFlagHandler.explosionEntityPosFilterPredicate((ResourceKey<Level>)dim, RegionFlag.EXPLOSION_ENTITY)).collect(Collectors.toSet());
            GrievingFlagHandler.preventDestructionFor(event, protectedBlocks, protectedEntities);
            if (event.getExplosion().getIndirectSourceEntity() != null) {
                boolean explosionTriggeredByCreeper = event.getExplosion().getIndirectSourceEntity() instanceof Creeper;
                if (explosionTriggeredByCreeper) {
                    protectedBlocks = event.getAffectedBlocks().stream().filter(GrievingFlagHandler.explosionBlockPosFilterPredicate((ResourceKey<Level>)dim, RegionFlag.EXPLOSION_CREEPER_BLOCK)).collect(Collectors.toSet());
                    protectedEntities = event.getAffectedEntities().stream().filter(GrievingFlagHandler.explosionEntityPosFilterPredicate((ResourceKey<Level>)dim, RegionFlag.EXPLOSION_CREEPER_ENTITY)).collect(Collectors.toSet());
                }
                GrievingFlagHandler.preventDestructionFor(event, protectedBlocks, protectedEntities);
            }
        }
    }

    private static void preventDestructionFor(ExplosionEvent.Detonate event, Set<BlockPos> protectedBlocks, Set<Entity> protectedEntities) {
        event.getAffectedBlocks().removeAll(protectedBlocks);
        event.getAffectedEntities().removeAll(protectedEntities);
    }

    private static Predicate<Entity> explosionEntityPosFilterPredicate(ResourceKey<Level> dim, RegionFlag flag) {
        return entity -> {
            FlagCheckEvent checkEvent = new FlagCheckEvent(entity.blockPosition(), flag, dim);
            if (Services.EVENT.post(checkEvent)) {
                return true;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, null, null);
            return flagState == FlagState.DENIED;
        };
    }

    private static Predicate<BlockPos> explosionBlockPosFilterPredicate(ResourceKey<Level> dim, RegionFlag flag) {
        return pos -> {
            FlagCheckEvent checkEvent = new FlagCheckEvent((BlockPos)pos, flag, dim);
            if (Services.EVENT.post(checkEvent)) {
                return true;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, null, null);
            return flagState == FlagState.DENIED;
        };
    }
}

