/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ChildRegionPagination
extends BasePaginationMessage<IProtectedRegion> {
    private final IProtectedRegion region;

    public ChildRegionPagination(IProtectedRegion region, List<IProtectedRegion> entries, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(entries, Commands.buildListChildRegionCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    @Override
    public List<Component> buildEntries() {
        return ChatComponentBuilder.buildRemoveRegionEntries(this.region, this.pageContent);
    }

    @Override
    public Component noContentMsg() {
        return Component.translatableWithFallback((String)"cli.msg.info.region.children.empty", (String)"No children defined in region %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.region)});
    }

    @Override
    public Component header() {
        return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{ChatLinkBuilder.buildRegionListChildrenLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
    }

    @Override
    public Component emptyEntry() {
        return Component.translatable((String)" - %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionAddChildrenLink(this.region)});
    }
}

