/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.data.region.RegionDataManager;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class LevelRegionDataArgumentType
implements ArgumentType<LevelRegionData> {
    private static final Collection<String> EXAMPLES = RegionDataManager.getLevelNames();
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(dim -> Component.translatableWithFallback((String)"cli.arg.dim.invalid", (String)"Dimension '%s' does not exist!", (Object[])new Object[]{dim}));

    public static LevelRegionDataArgumentType levelData() {
        return new LevelRegionDataArgumentType();
    }

    public static LevelRegionData getDimRegion(CommandContext<CommandSourceStack> context, String dim) throws CommandSyntaxException {
        ResourceLocation levelRl = (ResourceLocation)context.getArgument(dim, ResourceLocation.class);
        boolean isValidDimResourceLocation = ((CommandSourceStack)context.getSource()).levels().stream().map(ResourceKey::location).anyMatch(loc -> loc.equals((Object)levelRl));
        if (isValidDimResourceLocation) {
            LevelRegionData dimCache = RegionDataManager.getOrCreate(levelRl);
            if (dimCache == null) {
                throw ERROR_INVALID_VALUE.create((Object)levelRl.toString());
            }
            return dimCache;
        }
        throw ERROR_INVALID_VALUE.create((Object)levelRl.toString());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        if (context.getSource() instanceof CommandSourceStack) {
            return SharedSuggestionProvider.suggest(RegionDataManager.getLevelNames(), (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public LevelRegionData parse(StringReader reader) throws CommandSyntaxException {
        ResourceLocation levelRl = ResourceLocation.read((StringReader)reader);
        if (RegionDataManager.hasLevel(levelRl)) {
            return RegionDataManager.getOrCreate(levelRl);
        }
        return null;
    }
}

