package de.z0rdak.yawp.api.visualization;

import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5575;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.util.*;

import static de.z0rdak.yawp.constants.Constants.MOD_ID;

import I;

/*
- TODO: Event for filtering tracking for players? -> separately in next patch (most likely with luckperms)
    -> when tracking other player is added?... kill entities and add tracking for other player or how doesi t work?
-TODO: Show teleport anchors
-TODO: Remove entities on server-stop
-Note: Remove on start not possible due to events fired by entities not yet loaded?
-TODO: permission for commands in CommandInterceptor
 */
public class VisualizationManager {

    // TODO: MOAR logging
    public static final Logger VISUALIZATION_LOGGER = LogManager.getLogger(MOD_ID.toUpperCase() + "-Visualization");

    public static void initServerInstance(MinecraftServer server) {
        serverInstance = server;
    }

    public final static class_2960 REGION_BLOCK_DISPLAY_TAG = class_2960.method_12829("yawp:region_block_display");
    public final static class_2960 REGION_TEXT_DISPLAY_TAG = class_2960.method_12829("yawp:region_text_display");

    public static void nukeDisplayEntities(class_3218 level) {
        var entities = level.method_18198(class_5575.method_31795(class_8113.class), (entity) -> {
            boolean containsTextTag = entity.method_5752().contains(REGION_TEXT_DISPLAY_TAG.toString());
            boolean containsBlockTag = entity.method_5752().contains(REGION_BLOCK_DISPLAY_TAG.toString());
            return containsTextTag || containsBlockTag;
        });
        var entityAmount = entities.size();
        entities.forEach(e -> e.method_5650(class_1297.class_5529.field_26999));
        if (entityAmount > 0) {
            VISUALIZATION_LOGGER.info("Nuked all ({}) untracked region display entities in level {}.", entityAmount, level.method_27983().method_29177().toString());
        }
    }

    private static MinecraftServer serverInstance;
    // level key -> VisualizationManager
    private static final Map<class_2960, VisualizationManager> dimVisualizationManagers = new HashMap<>();
    // region name -> RegionVisualizationManager

    private final Map<String, RegionVisualizationManager> regionDisplayManagers;

    private VisualizationManager() {
        this.regionDisplayManagers = new HashMap<>();
    }

    public static void hideRegionsAround(class_1657 player, int radius) {
        class_1937 level = player.method_5770();
        class_2338 playerPos = player.method_24515();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(level.method_27983());
        if (maybeApi.isPresent()) {
            var dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, radius);
            regionsAround.forEach(region -> {
                hide(region, DisplayType.FRAME);
                hide(region, DisplayType.HULL);
                hide(region, DisplayType.MINIMAL);
                hide(region, DisplayType.MARKED);
            });
        }
    }

    public static void showRegionsAround(class_1657 player, int radius, DisplayType displayType) {
        class_1937 level = player.method_5770();
        class_2338 playerPos = player.method_24515();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(level.method_27983());
        if (maybeApi.isPresent()) {
            var dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, radius);
            regionsAround.forEach(region -> {
                show(region, displayType);
            });
        }
    }

    public static void hideAllRegions(class_1937 level, boolean untracked) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(level.method_27983());
        if (maybeApi.isPresent()) {
            var dimApi = maybeApi.get();
            Collection<IMarkableRegion> regions = dimApi.getAllLocalRegions();
            regions.forEach(region -> {
                hide(region, DisplayType.FRAME);
                hide(region, DisplayType.HULL);
                hide(region, DisplayType.MINIMAL);
                hide(region, DisplayType.MARKED);
            });

        }
        if (untracked) {
            nukeDisplayEntities((class_3218) level);
        }
    }

    public static void showTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);

        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.showTpAnchor(tpAnchor, level);
    }

    public static void hideTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);

        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.hideTpAnchor(tpAnchor, level);
    }

    public static void updateTpAnchor(IMarkableRegion region, TeleportAnchor tpAnchor) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);

        rvm.updateTpAnchor(tpAnchor);
    }

    // Note: Not useful, since tp anchor don't have a text component yet to distinguish them
    public static void showTeleportAnchors(IMarkableRegion region) {
        region.getTpAnchors().getAnchors().forEach(
                anchor -> showTpAnchor(region, anchor)
        );
    }

    public static void hideTeleportAnchors(IMarkableRegion region) {
        region.getTpAnchors().getAnchors().forEach(
                anchor -> hideTpAnchor(region, anchor)
        );
    }

    public static void show(IMarkableRegion region, DisplayType displayType, BlockDisplayProperties displayProperties) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);

        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.show(displayType, displayProperties, level);
    }

    private static VisualizationManager getOrCreateVisualizationManager(class_2960 levelRl) {
        if (!dimVisualizationManagers.containsKey(levelRl)) {
            VisualizationManager dimVm = new VisualizationManager();
            dimVisualizationManagers.put(levelRl, dimVm);
        }
        return dimVisualizationManagers.get(levelRl);
    }

    private static RegionVisualizationManager getOrCreateRegionVisualizationManager(VisualizationManager vm, IMarkableRegion region) {
        if (!vm.regionDisplayManagers.containsKey(region.getName())) {
            vm.regionDisplayManagers.put(region.getName(), new RegionVisualizationManager(region));
        }
        return vm.regionDisplayManagers.get(region.getName());
    }

    public static void show(IMarkableRegion region, DisplayType displayType) {
        show(region, displayType, region.getArea().getDisplay());
    }

    public static void hide(IMarkableRegion region, DisplayType displayType) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);
        rvm.hide(displayType);
    }

    public static void updateRegionDisplay(IMarkableRegion region) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);
        class_3218 level = serverInstance.method_3847(region.getDim());
        rvm.updateDisplay(region.getArea(), level);
    }


    public static void refreshDisplay(IMarkableRegion region, DisplayType displayType) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);

        rvm.updateDisplay(region.getArea().getDisplay(), displayType);
    }

    public static void refreshDisplay(IMarkableRegion region) {
        class_2960 levelRl = region.getDim().method_29177();
        VisualizationManager vm = getOrCreateVisualizationManager(levelRl);
        RegionVisualizationManager rvm = getOrCreateRegionVisualizationManager(vm, region);

        rvm.updateDisplay(region.getArea().getDisplay(), true);
    }

    public static void showHierarchy(IMarkableRegion region, DisplayType displayType, boolean recursive) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isEmpty()) return;
        Collection<IProtectedRegion> children = region.getChildren().values();
        for (IProtectedRegion child : children) {
            if (child instanceof IMarkableRegion childRegion) {
                show(childRegion, displayType);
                if (recursive) {
                    showHierarchy(childRegion, displayType, recursive);
                }
            }
        }
    }

    public static void showIntersecting(IMarkableRegion region, DisplayType displayType) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isPresent()) {
            var dimApi = maybeApi.get();
            List<IMarkableRegion> intersectingRegions = dimApi.getIntersectingRegions(region);
            intersectingRegions.forEach(intersectingRegion -> {
                show(intersectingRegion, displayType);
            });
        }
    }

    public static void hideHierarchy(IMarkableRegion region, DisplayType displayType, boolean recursive) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isEmpty()) return;
        Collection<IProtectedRegion> children = region.getChildren().values();
        for (IProtectedRegion child : children) {
            if (child instanceof IMarkableRegion childRegion) {
                hide(childRegion, displayType);
                if (recursive) {
                    hideHierarchy(childRegion, displayType, recursive);
                }
            }
        }
    }

    public static void hideIntersecting(IMarkableRegion region, DisplayType displayType) {
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(region.getDim());
        if (maybeApi.isPresent()) {
            var dimApi = maybeApi.get();
            List<IMarkableRegion> intersectingRegions = dimApi.getIntersectingRegions(region);
            intersectingRegions.forEach(intersectingRegion -> {
                hide(intersectingRegion, displayType);
            });
        }
    }
}
