package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionsInDimensionPagination;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

import static de.z0rdak.yawp.api.MessageSender.sendError;
import static de.z0rdak.yawp.api.commands.CommandConstants.*;
import static de.z0rdak.yawp.commands.DimensionCommands.*;
import static de.z0rdak.yawp.commands.RegionCommands.*;
import static de.z0rdak.yawp.commands.arguments.ArgumentUtil.*;


class ShortcutCommands {

    private ShortcutCommands() {
    }

    static LiteralArgumentBuilder<class_2168> buildInfoLocal() {
        return literal(INFO)
                    .then(class_2170.method_9244(LOCAL.toString(), StringArgumentType.word())
                            .suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, ctx.getSource().method_9225()))
                            .executes(ctx -> CommandUtil.promptRegionInfo(ctx, getRegionIn(ctx, ctx.getSource().method_9225())))
                    );
    }

    static LiteralArgumentBuilder<class_2168> buildDeleteLocal() {
        return literal(DELETE)
                    .then(class_2170.method_9244(LOCAL.toString(), StringArgumentType.word())
                            .suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, ctx.getSource().method_9225()))
                            .executes(ctx -> DimensionCommands.deleteRegion(ctx, getRegionIn(ctx, ctx.getSource().method_9225())))
                    );
    }

    static LiteralArgumentBuilder<class_2168> buildCreateLocal() {
        return literal(CREATE)
                .then(class_2170.method_9244(CommandConstants.NAME.toString(), StringArgumentType.word())
                                .suggests((ctx, builder) -> class_2172.method_9265(Collections.singletonList(getRandomExample()), builder))
                                .then(class_2170.method_9247(AreaType.CUBOID.areaType)
                                        .then(class_2170.method_9244(POS1.toString(), class_2262.method_9698())
                                                .then(class_2170.method_9244(POS2.toString(), class_2262.method_9698())
                                                        .executes(ctx -> createCuboidRegion(ctx, getRegionNameArgument(ctx),
                                                                class_2262.method_9697(ctx, POS1.toString()),
                                                                class_2262.method_9697(ctx, POS2.toString()), null))
                                                        .then(class_2170.method_9244(CommandConstants.PARENT.toString(), StringArgumentType.word())
                                                                .suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder))
                                                                .executes(ctx -> createCuboidRegion(ctx, getRegionNameArgument(ctx),
                                                                        class_2262.method_9697(ctx, POS1.toString()),
                                                                        class_2262.method_9697(ctx, POS2.toString()), getContainingOwnedRegionArgument(ctx))))))
                                )
                                .then(class_2170.method_9247(AreaType.SPHERE.areaType)
                                        .then(class_2170.method_9244(CENTER_POS.toString(), class_2262.method_9698())
                                                .then(class_2170.method_9244(RADIUS.toString(), IntegerArgumentType.integer(0))
                                                        .executes(ctx -> createSphereRegion(ctx, getRegionNameArgument(ctx),
                                                                class_2262.method_9697(ctx, CENTER_POS.toString()),
                                                                IntegerArgumentType.getInteger(ctx, RADIUS.toString()), null))
                                                        .then(class_2170.method_9244(CommandConstants.PARENT.toString(), StringArgumentType.word())
                                                                .suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder))
                                                                .executes(ctx -> createSphereRegion(ctx, getRegionNameArgument(ctx),
                                                                        class_2262.method_9697(ctx, CENTER_POS.toString()),
                                                                        IntegerArgumentType.getInteger(ctx, RADIUS.toString()), getContainingOwnedRegionArgument(ctx))))))
                                )
                        );
    }

    // TODO: HIDE LOCAL HIERARCHY/INTERSECTING
    static LiteralArgumentBuilder<class_2168> buildHide() {
        return literal(HIDE)
                .then(literal(LOCAL)
                        .then(class_2170.method_9244(LOCAL.toString(), StringArgumentType.word())
                                .suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, ctx.getSource().method_9225()))
                                .executes(ctx -> hideRegion(ctx, getRegionIn(ctx, ctx.getSource().method_9225()), DisplayType.FRAME))
                                .then(class_2170.method_9244(STYLE.toString(), StringArgumentType.word())
                                        .suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), builder))
                                        .executes(ctx -> hideRegion(ctx, getRegionIn(ctx, ctx.getSource().method_9225()), getDisplayTypeArgument(ctx)))
                                )
                        )
                ).then(buildHideAll())
                .then(buildHideNear());
    }

    private static LiteralArgumentBuilder<class_2168> buildHideAll() {
        return literal(ALL)
                .executes(ShortcutCommands::hideRegions)
                .then(class_2170.method_9244(UNTRACKED.toString(), BoolArgumentType.bool())
                        .executes(ctx -> hideRegions(ctx, BoolArgumentType.getBool(ctx, UNTRACKED.toString())))
                );
    }

    private static LiteralArgumentBuilder<class_2168> buildHideNear() {
        return literal(NEAR)
                .executes(ctx -> hideRegionsAroundPlayer(ctx, 192))
                .then(class_2170.method_9244(RADIUS.toString(), IntegerArgumentType.integer(0, 800))
                        .executes(ctx -> hideRegionsAroundPlayer(ctx, IntegerArgumentType.getInteger(ctx, RADIUS.toString())))
                );
    }

    private static LiteralArgumentBuilder<class_2168> buildShowNear() {
        return literal(NEAR)
                // TODO: Region pagination list something thing
                //.then(literal(LIST)
                //        .executes(ctx -> promptRegionsAroundPlayer(ctx, 192))
                //        .then(Commands.argument(RADIUS.toString(), IntegerArgumentType.integer(10, 800))
                //                .executes(ctx -> promptRegionsAroundPlayer(ctx, IntegerArgumentType.getInteger(ctx, RADIUS.toString())))))
                //.then(literal(DISPLAY)
                .executes(ctx -> showRegionsAroundPlayer(ctx, DisplayType.FRAME, 192))
                .then(class_2170.method_9244(RADIUS.toString(), IntegerArgumentType.integer(0, 800))
                                .executes(ctx -> showRegionsAroundPlayer(ctx, DisplayType.FRAME, IntegerArgumentType.getInteger(ctx, RADIUS.toString())))
                                .then(class_2170.method_9244(STYLE.toString(), StringArgumentType.word())
                                        .suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), builder))
                                        .executes(ctx -> showRegionsAroundPlayer(ctx, getDisplayTypeArgument(ctx), IntegerArgumentType.getInteger(ctx, RADIUS.toString())))
                                )
                );
    }

    // TODO: SHOW LOCAL HIERARCHY/INTERSECTING
    static LiteralArgumentBuilder<class_2168> buildShow() {
        return literal(SHOW)
                .then(literal(LOCAL)
                        .then(class_2170.method_9244(LOCAL.toString(), StringArgumentType.word())
                                .suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, ctx.getSource().method_9225()))
                                .executes(ctx -> showRegion(ctx, getRegionIn(ctx, ctx.getSource().method_9225()), DisplayType.FRAME))
                                .then(class_2170.method_9244(STYLE.toString(), StringArgumentType.word())
                                        .suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), builder))
                                        .executes(ctx -> showRegion(ctx, getRegionIn(ctx, ctx.getSource().method_9225()), getDisplayTypeArgument(ctx)))
                                )
                        )
                )
                .then(buildShowNear());
    }

    private static int promptRegionsAroundPlayer(CommandContext<class_2168> ctx, int blockRadius) throws CommandSyntaxException {
        class_1937 level = ctx.getSource().method_9225();
        class_3222 player = ctx.getSource().method_9207();

        Optional<IDimensionRegionApi> maybeDimRegionApi = RegionManager.get().getDimRegionApi(level.method_27983());
        if (maybeDimRegionApi.isPresent()) {
            IDimensionRegionApi dimRegionApi = maybeDimRegionApi.get();
            List<IProtectedRegion> regionsAround = dimRegionApi.getRegionsAround(player.method_24515(), blockRadius)
                    .stream()
                    .map(r -> (IProtectedRegion)r)
                    .collect(Collectors.toList());
            try {
                // TODO: Build own RegionList Pagination
                int paginationSize = Services.REGION_CONFIG.getPaginationSize();
                RegionsInDimensionPagination childRegionPagination = new RegionsInDimensionPagination(dimRegionApi.getCache(), regionsAround, 0, paginationSize);
                MultiLineMessage.send(ctx.getSource(), childRegionPagination);
            } catch (InvalidPageNumberException e) {
                sendError(ctx.getSource(), e.getError());
                return -1;
            }
            return 0;
        } else {
            return -1;
        }
    }

    private static int showRegionsAroundPlayer(CommandContext<class_2168> ctx, DisplayType displayType, int blockRadius) throws CommandSyntaxException {
        class_3222 player = ctx.getSource().method_9207();
        VisualizationManager.showRegionsAround(player, blockRadius, displayType);

        class_1937 level = player.method_5770();
        class_2338 playerPos = player.method_24515();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi(level.method_27983());
        if (maybeApi.isPresent()) {
            var dimApi = maybeApi.get();
            List<IMarkableRegion> regionsAround = dimApi.getRegionsAround(playerPos, blockRadius);
            // TODO: build pagination list of regions visualized and prompt info links for them
        }
        return 0;
    }

    private static int hideRegions(CommandContext<class_2168> ctx) {
        return hideRegions(ctx, false);
    }

    private static int hideRegions(CommandContext<class_2168> ctx, boolean untracked) {
        VisualizationManager.hideAllRegions(ctx.getSource().method_9225(), untracked);
        return 0;
    }

    private static int hideRegionsAroundPlayer(CommandContext<class_2168> ctx, int blockRadius) throws CommandSyntaxException {
        class_3222 player = ctx.getSource().method_9207();
        VisualizationManager.hideRegionsAround(player, blockRadius);
        return 0;
    }
}
