package de.z0rdak.yawp.data.region;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.GlobalRegion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;

public class GlobalRegionData extends class_18 {

    public static final String GLOBAL_REGION_FILE_NAME = "global";
    public static final String TYPE = Constants.MOD_ID + "/" + GLOBAL_REGION_FILE_NAME;

    public static final Codec<GlobalRegionData> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_2960.field_25139.fieldOf("id")
                            .forGetter(r -> GlobalRegion.GLOBAL),
                    GlobalRegion.CODEC.optionalFieldOf("global", new GlobalRegion())
                            .forGetter(GlobalRegionData::getGlobal))
                    .apply(instance, GlobalRegionData::new));

    private final class_2960 id;
    private GlobalRegion globalRegion;

    public GlobalRegionData() {
        this.id = GlobalRegion.GLOBAL;
        this.globalRegion = new GlobalRegion();
    }

    public GlobalRegionData(class_2960 id, GlobalRegion region) {
        this.id = id;
        this.globalRegion = region;
    }

    public static GlobalRegionData load(class_2487 tag) {
        return GlobalRegionData.CODEC.parse(class_2509.field_11560, tag)
                .resultOrPartial(Constants.LOGGER::warn)
                .orElse(new GlobalRegionData());
    }

    @Override
    public @NotNull class_2487 method_75(@NotNull class_2487 tag) {
        Optional<class_2520> nbt = GlobalRegionData.CODEC.encodeStart(class_2509.field_11560, this)
                .resultOrPartial(Constants.LOGGER::warn);
        if (nbt.isPresent()) {
            tag = (class_2487) nbt.get();
        }
        return tag;
    }

    public GlobalRegion getGlobal() {
        return globalRegion;
    }

    public void reset() {
        this.globalRegion = new GlobalRegion();
    }

    public static GlobalRegionData get(class_26 dataStorage, @Nullable Supplier<GlobalRegionData> globalRegionDataSupplier) {
        return dataStorage.method_17924(
                GlobalRegionData::load,
                globalRegionDataSupplier != null ? globalRegionDataSupplier : GlobalRegionData::new,
                GlobalRegionData.TYPE
        );
    }
}

