package de.z0rdak.yawp.data.region;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.constants.Constants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Supplier;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_2960;

public class LevelListData extends class_18 {

    public static final String DIMENSIONS_FILE_NAME = "dimensions";

    public static Codec<LevelListData> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    Codec.list(class_2960.field_25139).optionalFieldOf("dims", new ArrayList<>())
                            .forGetter(LevelListData::getLevels)
            ).apply(instance, LevelListData::new));

    public final static String TYPE = String.join("/", Constants.MOD_ID, DIMENSIONS_FILE_NAME);

    private final Set<class_2960> dimensions;

    public LevelListData(List<class_2960> dims){
        this.dimensions = new HashSet<>(dims);
    }

    public LevelListData(){
        this.dimensions = new HashSet<>();
    }

    @Override
    public @NotNull class_2487 method_75(@NotNull class_2487 tag) {
        Optional<class_2520> nbt = LevelListData.CODEC.encodeStart(class_2509.field_11560, this)
                .resultOrPartial(Constants.LOGGER::warn);
        if (nbt.isPresent()) {
            tag = (class_2487) nbt.get();
        }
        return tag;
    }

    public static LevelListData get(class_26 storage, @Nullable Supplier<LevelListData> defaultSupplier) {
        return storage.method_17924(
                LevelListData::load,
                defaultSupplier == null ? LevelListData::new : defaultSupplier,
                LevelListData.TYPE);
    }

    public static LevelListData load(class_2487 tag) {
        return LevelListData.CODEC.parse(class_2509.field_11560, tag)
                .resultOrPartial(Constants.LOGGER::warn)
                .orElse(new LevelListData());
    }

    public List<class_2960> getLevels() {
        return new ArrayList<>(this.dimensions);
    }

    public void addDimEntry(class_2960 rl) {
        this.dimensions.add(rl);
    }

    public boolean hasDimEntry(class_2960 rl) {
        return this.dimensions.contains(rl);
    }
}

