package de.z0rdak.yawp.handler;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.constants.serialization.ItemNbtKeys;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.util.StickType;
import de.z0rdak.yawp.util.StickUtil;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3965;

import static de.z0rdak.yawp.handler.HandlerUtil.isServerSide;
import static de.z0rdak.yawp.util.StickUtil.*;

public class MarkerStickHandler {

    public static void onCreateStick(class_1657 player, class_1799 input, class_1799 output, StickType type) {
        // split stack and only create one stick, also refund xp
        input.method_7939(output.method_7947() - 1);
        player.method_7270(input);
        player.method_7316(1);
        StickUtil.initMarkerNbt(output, player.method_37908().method_27983());
    }

    public static void onMarkBlock(class_1657 player, class_1799 involvedItem, class_2338 target) {
        if (isServerSide(player.method_37908())) {
            // TODO: Maybe check if player is allowed to mark block
            if (!involvedItem.equals(class_1799.field_8037) && isVanillaStick(involvedItem)) {
                StickType stickType = getStickType(involvedItem);
                if (Objects.requireNonNull(stickType) == StickType.MARKER) {
                    MarkerStick marker = new MarkerStick(involvedItem.method_7969().method_10562(ItemNbtKeys.STICK));
                    AreaType areaType = marker.getAreaType();
                    if (areaType == null) {
                        Constants.LOGGER.warn("Unknown area type on marking - should really not happening");
                        return;
                    }
                    // add block to NBT list
                    marker.addMarkedBlock(target);
                    // check whether marked blocks form a valid marked area
                    marker.checkValidArea();
                    involvedItem.method_7969().method_10566(ItemNbtKeys.STICK, marker.serializeNBT());
                    setStickName(involvedItem, StickType.MARKER);
                }
            }
        }
    }

    public static void onCycleMode(class_1657 player, class_1799 involvedItem, class_3965 target) {
        if (isServerSide(player.method_37908())) {
            // is some valid mod stick
            if (!involvedItem.equals(class_1799.field_8037)
                    && hasNonNullTag(involvedItem)
                    && involvedItem.method_7969().method_10545(ItemNbtKeys.STICK)) {
                boolean targetIsAir;
                if (target.method_17783() == class_239.class_240.field_1332) { // should always be block
                    class_2338 blockpos = target.method_17777();
                    class_2680 blockstate = player.method_37908().method_8320(blockpos);
                    targetIsAir = blockstate.method_26204().equals(class_2246.field_10124);
                } else {
                    targetIsAir = target.method_17783() == class_239.class_240.field_1333;
                }

                if (player.method_5715() && targetIsAir) {
                    StickType stickType = getStickType(involvedItem);
                    if (Objects.requireNonNull(stickType) == StickType.MARKER) {
                        class_2487 nbt = involvedItem.method_7969();
                        MarkerStick marker = new MarkerStick(nbt.method_10562(ItemNbtKeys.STICK));
                        // change area nbt, reset marked blocks, set valid to false
                        marker.cycleMode();
                        // update stick name
                        involvedItem.method_7969().method_10566(ItemNbtKeys.STICK, marker.serializeNBT());
                        StickUtil.setStickName(involvedItem, StickType.MARKER);
                    }
                }
            }
        }
    }
}
