package de.z0rdak.yawp.mixin;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.handler.CommandInterceptor;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.EXECUTE_COMMAND;
import static de.z0rdak.yawp.handler.HandlerUtil.getDimKey;
import static de.z0rdak.yawp.api.FlagEvaluator.processCheck;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_2170.class)
public abstract class CommandManagerMixin {

    @Inject(method = "performCommand", at = @At(value = "HEAD"), cancellable = true)
    public void execute(ParseResults<class_2168> parseResults, String command, CallbackInfoReturnable<Integer> cir) {
        // check mod command permissions
        int result = 0;
        try {
            result = CommandInterceptor.handleModCommands(parseResults, command);
        } catch (CommandSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (result != 0) {
            cir.setReturnValue(1);
        }
        // check exec-command flag
        class_2168 cmdSource = parseResults.getContext().getSource();
        if (cmdSource.method_43737()) {
            class_3222 player = cmdSource.method_44023();
            if (player != null) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), EXECUTE_COMMAND, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    sendFlagMsg(deny);
                    cir.setReturnValue(1);
                });
            }
        }
    }
}