package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3616;
import net.minecraft.class_3621;
import net.minecraft.world.level.material.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;

@Mixin(class_3609.class)
public class FlowingFluidMixin {

    @Inject(method = "canSpreadTo", at = @At("HEAD"), cancellable = true)
    protected void canSpreadTo(class_1922 blockGetter, class_2338 blockPos, class_2680 blockState, class_2350 direction, class_2338 blockPos2, class_2680 blockState2, class_3610 fluidState, class_3611 fluid, CallbackInfoReturnable<Boolean> cir) {
        if (!(blockGetter instanceof class_1937 level)) {
            // Should never happen, but skip check if it does
            return;
        }

        if (!Services.FLAG_CONFIG.isDisabledByConfig(FLUID_FLOW.name)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, FLUID_FLOW, level.method_27983());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                cir.setReturnValue(false);
            });
            if (cir.isCancelled()) {
                return;
            }
        }

        if (!Services.FLAG_CONFIG.isDisabledByConfig(WATER_FLOW.name)) {
            if (fluidState.method_15772() instanceof class_3621) {
                FlagCheckEvent specificFluidCheckEvent = new FlagCheckEvent(blockPos, WATER_FLOW, level.method_27983());
                if (Services.EVENT.post(specificFluidCheckEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> {
                    cir.setReturnValue(false);
                });
            }
        }
        if (!Services.FLAG_CONFIG.isDisabledByConfig(LAVA_FLOW.name)) {
            if (fluidState.method_15772() instanceof class_3616) {
                FlagCheckEvent specificFluidCheckEvent = new FlagCheckEvent(blockPos, LAVA_FLOW, level.method_27983());
                if (Services.EVENT.post(specificFluidCheckEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> {
                    cir.setReturnValue(false);
                });
            }
        }
    }
}
