package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.platform.Services;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.isServerSide;

@Mixin(class_1927.class)
public abstract class ExplosionMixin {

    @Final
    @Shadow
    private class_1937 level;

    @Final
    @Shadow
    private @Nullable class_1297 source;

    @Unique
    private static void filterExplosionTargets(class_1927 explosion, class_1937 world, List<class_1297> affectedEntities) {
        Predicate<FlagCheckEvent> isProtected = (fce) -> {
            if (Services.EVENT.post(fce)) {
                return true;
            }
            return FlagEvaluator.processCheck(fce) == FlagState.DENIED;
        };
        BiFunction<List<class_2338>, RegionFlag, Set<class_2338>> filterBlocks = (in, flag) -> in.stream()
                .filter(blockPos -> isProtected.test(new FlagCheckEvent(blockPos, flag, world.method_27983())))
                .collect(Collectors.toSet());
        BiFunction<List<class_1297>, RegionFlag, Set<class_1297>> filterEntities = (in, flag) -> in.stream()
                .filter(entity -> isProtected.test(new FlagCheckEvent(entity.method_24515(), flag, world.method_27983())))
                .collect(Collectors.toSet());

        explosion.method_8346().removeAll(filterBlocks.apply(explosion.method_8346(), EXPLOSION_BLOCK));
        affectedEntities.removeAll(filterEntities.apply(affectedEntities, EXPLOSION_ENTITY));

        if (explosion.method_8347() != null) {
            boolean explosionTriggeredByCreeper = (explosion.method_8347() instanceof class_1548);
            if (explosionTriggeredByCreeper) {
                explosion.method_8346().removeAll(filterBlocks.apply(explosion.method_8346(), EXPLOSION_CREEPER_BLOCK));
                affectedEntities.removeAll(filterEntities.apply(affectedEntities, EXPLOSION_CREEPER_ENTITY));
            }
        }
    }

    @Inject(method = "explode", locals = LocalCapture.CAPTURE_FAILSOFT, at = @At(value = "INVOKE", target = "Lnet/minecraft/world/phys/Vec3;<init>(DDD)V", ordinal = 1), allow = 1)
    public void onExplosion(CallbackInfo ci, Set<class_2338> set, int i, float q, int k, int l, int r, int s, int t, int u, List<class_1297> list) {
        /* List<Entity> list is a local variable - the affectedEntities - which, 
        is captured and provided as argument here through the LocalCapture feature 
        */
        class_1927 explosion = (class_1927) (Object) this;
        if (this.level != null && isServerSide(this.level)) {
            if (this.source != null) {
                // flag check
                filterExplosionTargets(explosion, this.level, list);
            }
        }
    }
}
