package de.z0rdak.yawp.mixin.flag.player.breeding;

import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_8153;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.core.flag.RegionFlag.ANIMAL_BREEDING;
import static de.z0rdak.yawp.handler.HandlerUtil.isServerSide;
import static de.z0rdak.yawp.api.FlagEvaluator.processCheck;

@Mixin(class_8153.class)
public abstract class SnifferMixin {

    @Inject(method = "spawnChildFromBreeding", at = @At("HEAD"), cancellable = true, allow = 1)
    public void spawnChildFromBreeding(class_3218 world, class_1429 parentB, CallbackInfo ci) {
        if (isServerSide(world)) {
            class_8153 parentA = (class_8153) (Object) this;
            if (parentA.method_6478()  != null) {
                class_1657 breeder = parentA.method_6478();
                FlagCheckEvent checkEvent = new FlagCheckEvent(parentA.method_24515(), ANIMAL_BREEDING, world.method_27983(), breeder);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                processCheck(checkEvent, deny -> {
                    parentA.method_5614(6000);
                    parentB.method_5614(6000);
                    parentA.method_6477();
                    parentB.method_6477();
                    ci.cancel();
                });
            }
        }
    }
}
