package de.z0rdak.yawp.mixin.stick;

import de.z0rdak.yawp.handler.MarkerStickHandler;
import de.z0rdak.yawp.util.StickUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3225;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.handler.HandlerUtil.isServerSide;

@Mixin(class_3225.class)
public class ServerPlayerInteractionManagerMixin {

    @Inject(method = "useItemOn", at = @At("HEAD"), cancellable = true, allow = 1)
    public void useItemOn(class_3222 serverPlayer, class_1937 level, class_1799 itemStack, class_1268 interactionHand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> cir) {
        if (isServerSide(level)) {
            if (StickUtil.isMarker(itemStack)) {
                class_2338 blockpos = blockHitResult.method_17777();
                MarkerStickHandler.onMarkBlock(serverPlayer, itemStack, blockpos);
                cir.setReturnValue(class_1269.field_5812);
            }
        }
    }
}
