package de.z0rdak.yawp.util;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.PlayerManager;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.text.Messages;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_270;
import net.minecraft.class_3341;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.network.chat.*;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static de.z0rdak.yawp.api.commands.CommandConstants.DIM;
import static de.z0rdak.yawp.api.commands.Commands.buildCommandStr;
import static de.z0rdak.yawp.api.permission.Permissions.GROUP_LIST;
import static de.z0rdak.yawp.util.ChatLinkBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.LINK_COLOR;
import static de.z0rdak.yawp.util.text.Messages.REMOVE_CMD_COLOR;
import static net.minecraft.class_124.*;
import static net.minecraft.class_2558.class_2559.field_11750;
import static net.minecraft.class_2558.class_2559.field_11745;

public class ChatComponentBuilder {

    private ChatComponentBuilder() {
    }

    /**
     * Builds a string from the given block pos which can be used in commands
     */
    public static String commandBlockPosStr(class_2338 target) {
        return target.method_10263() + " " + target.method_10264() + " " + target.method_10260();
    }

    public static String shortBlockPosBracketed(class_2338 target) {
        return "[" + shortBlockPos(target) + "]";
    }

    public static String shortBlockPos(class_2338 target) {
        return "X=" + target.method_10263() + ", Y=" + target.method_10264() + ", Z=" + target.method_10260();
    }

    public static String tinyBlockPos(class_2338 target) {
        return "[" + commandBlockPosStr(target) + "]";
    }

    public static String buildBlockPosLinkText(class_2338 target) {
        return target.method_10263() + ", " + target.method_10264() + ", " + target.method_10260();
    }

    public static class_5250 buildHeader(class_5250 header) {
        // return Messages.substitutable("%s %s %s", ChatFormatting.BOLD, header, ChatFormatting.BOLD);
        return header;
    }

    public static class_5250 buildExecuteCmdComponent(class_5250 linkText, class_5250 hoverText, String command, class_2558.class_2559 eventAction, class_124 color) {
        class_5250 text = class_2564.method_10885(linkText);
        return text.method_10862(text.method_10866()
                .method_10977(color)
                .method_10949(new class_2568(class_2568.class_5247.field_24342, hoverText))
                .method_10958(new class_2558(eventAction, command)));
    }

    public static class_5250 buildExecuteCmdLink(class_5250 linkText, class_5250 hoverText, String command, class_2558.class_2559 eventAction, class_124 color) {
        return linkText.method_10862(linkText.method_10866()
                .method_10977(color)
                .method_10949(new class_2568(class_2568.class_5247.field_24342, hoverText))
                .method_10958(new class_2558(eventAction, command)));
    }

    public static class_5250 buildExecuteCmdLinkWithBrackets(class_5250 linkText, class_5250 hoverText, String command, class_2558.class_2559 eventAction, class_124 color) {
        var cmdLink = linkText.method_10862(linkText.method_10866()
                .method_10977(color)
                .method_10949(new class_2568(class_2568.class_5247.field_24342, hoverText))
                .method_10958(new class_2558(eventAction, command)));
        return class_2564.method_10885(cmdLink);
    }

    public static class_5250 buildPlayerHoverComponent(class_1657 player) {
        class_5250 playerName = class_2561.method_43470(player.method_5820());
        class_5250 playerInfo = Messages.substitutable("%s (%s)", player.method_5476(), player.method_5667().toString());
        playerName.method_10862(playerName.method_10866()
                .method_10977(LINK_COLOR)
                .method_10949(new class_2568(class_2568.class_5247.field_24342, playerInfo))
                .method_10958(new class_2558(field_11745, "/tell " + playerName.getString() + " ")));
        return playerName;
    }

    public static class_5250 buildTeamHoverComponent(class_270 team) {
        class_5250 playerName = class_2561.method_43470(team.method_1197());
        playerName.method_10862(playerName.method_10866()
                .method_10977(LINK_COLOR)
                .method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_48321("cli.msg.info.region.group.link.hover", "Click to display team info")))
                .method_10958(new class_2558(field_11750, "/team list " + team.method_1197())));
        return playerName;
    }

    public static class_5250 buildRegionAreaDetailComponent(IMarkableRegion region) {
        IMarkableArea area = region.getArea();
        class_5250 areaInfo = class_2561.method_43470(area.getAreaType().areaType);
        switch (area.getAreaType()) {
            case CUBOID:
                return Messages.substitutable("%s, %s", areaInfo, buildCuboidAreaInfo((CuboidArea) area));
            case SPHERE:
                return Messages.substitutable("%s, %s", areaInfo, buildSphereAreaInfo((SphereArea) area));
            default:
                throw new IllegalArgumentException("Invalid area type");
        }
    }

    /**
     * Size: X=69, Y=10, Z=42
     */
    private static class_5250 buildCuboidAreaInfo(CuboidArea cuboidArea) {
        return class_2561.method_48322("cli.msg.info.region.area.area.size.text.cuboid", "Size: %s %s %s",
                buildAreaAxisInfoComponent(cuboidArea, class_2350.class_2351.field_11048),
                buildAreaAxisInfoComponent(cuboidArea, class_2350.class_2351.field_11052),
                buildAreaAxisInfoComponent(cuboidArea, class_2350.class_2351.field_11051));
    }

    /**
     * Center: [X,Y,Z], Radius: 5, Diameter: 11
     */
    private static class_5250 buildSphereAreaInfo(SphereArea sphereArea) {
        int diameter = (sphereArea.getRadius() * 2) + 1;
        class_5250 centerPos = class_2561.method_43470(buildBlockPosLinkText(sphereArea.getCenterPos()));
        return class_2561.method_48322("cli.msg.info.region.area.area.size.text.sphere", "Center: %s, Radius: %s, Diameter: %s",
                buildTextWithHoverAndBracketsMsg(centerPos, centerPos, field_1068), sphereArea.getRadius(), diameter);
    }

    /**
     * Builds component showing size of the area for the given axis with a hover text displaying the block range of the axis.
     * Axis=N, e.g. X=5
     */
    private static class_5250 buildAreaAxisInfoComponent(CuboidArea cuboidArea, class_2350.class_2351 axis) {
        class_3341 area = cuboidArea.getArea();
        int axisSize = AreaUtil.blocksOnAxis(area, axis);
        String axisName = axis.method_10174().toUpperCase();
        int min = axis.method_10173(area.method_35415(), area.method_35416(), area.method_35417());
        int max = axis.method_10173(area.method_35418(), area.method_35419(), area.method_35420());
        return buildTextWithHoverAndBracketsMsg(class_2561.method_43470(axisName + "=" + axisSize), class_2561.method_43470(axisName + ": " + min + " - " + max), field_1068);
    }

    public static class_5250 buildTextWithHoverAndBracketsMsg(class_5250 text, class_5250 hoverText, class_124 color) {
        class_5250 bracketedText = class_2564.method_10885(text);
        return buildTextWithHoverMsg(bracketedText, hoverText, color);
    }

    public static class_5250 buildTextWithWhiteBracketsAndHover(class_5250 text, class_5250 hoverText, class_124 color) {
        return class_2564.method_10885(buildTextWithHoverMsg(text, hoverText, color));
    }


    public static class_5250 buildTextWithHoverMsg(class_5250 text, class_5250 hoverText, class_124 color) {
        text.method_10862(text.method_10866().method_10977(color).method_10949(new class_2568(class_2568.class_5247.field_24342, hoverText)));
        return text;
    }

    public static class_5250 buildHelpStartComponent() {
        String command = buildCommandStr(CommandConstants.GLOBAL.toString(), CommandConstants.INFO.toString());
        class_5250 text = class_2561.method_48321("help.hint.link.text", "Start here");
        class_5250 hover = class_2561.method_48322("help.hint.link.hover", "Use '/%s global info' as a starting point to manage the global region", "/" + Constants.MOD_ID);
        return buildExecuteCmdComponent(text, hover, command, class_2558.class_2559.field_11750, LINK_COLOR);
    }

    public static List<String> getGroupsForRegion(IProtectedRegion region) {
        return GROUP_LIST;
    }

    public static int getGroupSize(IProtectedRegion region, String groupName) {
        PlayerContainer group = region.getGroup(groupName);
        return group.getPlayers().size() + group.getTeams().size();
    }

    public static class_5250 buildGroupListHeader(IProtectedRegion region, String group) {
        class_5250 groupLink = buildGroupLink(region, group, getGroupSize(region, group));
        return buildHeader(class_2561.method_48322("cli.msg.info.header.in", "== %s in %s ==", groupLink, buildRegionInfoLink(region)));
    }

    public static class_5250 buildGroupTypeHeader(IProtectedRegion region, String group, GroupType groupType) {
        String fallback = "== Region '%s' " + groupType.name + " in %s ==";
        return class_2561.method_48322("cli.msg.info.region.group." + groupType.name + ".list", fallback, buildRegionInfoLink(region), group);
    }

    public static class_5250 buildFlagStateComponent(IProtectedRegion region, IFlag flag) {
        FlagState state = flag.getState();
        class_5250 text = class_2561.method_43470(state.name);
        class_5250 hover = class_2561.method_43473();
        class_124 color = field_1068;
        switch (state) {
            case ALLOWED:
                color = field_1060;
                hover = class_2561.method_48321("cli.flag.state.allowed.info.hover", "A flag with allowed state does not prevent the related action");
                break;
            case DENIED:
                color = field_1061;
                hover = class_2561.method_48321("cli.flag.state.denied.info.hover", "A flag with denied state prevents the related action");
                break;
            case DISABLED:
                color = field_1080;
                hover = class_2561.method_48321("cli.flag.state.disabled.info.hover", "A disabled flag is not considered in flag checks");
                break;
        }
        class_5250 stateInfo = buildTextWithHoverAndBracketsMsg(text, hover, color);
        return Messages.substitutable("%s %s", stateInfo, buildFlagStateSuggestionLink(region, flag));
    }

    public static class_5250 buildFlagMessageHoverText(IProtectedRegion region, IFlag flag) {
        class_5250 flagMsgText = truncateMsg(flag);
        class_5250 hoverText = class_2561.method_43470(flag.getFlagMsg().msg());
        // if flag has default msg, use default msg
        if (flag.getFlagMsg().isDefault()) {
            String hoverFallback = "[{region}]: The '{flag}' flag denies this action here!";
            hoverText = class_2561.method_48321("flag.msg.deny." + region.getRegionType().type + ".default", hoverFallback);
        }
        return buildTextWithHoverAndBracketsMsg(flagMsgText, hoverText, field_1068);
    }

    public static class_5250 truncateMsg(IFlag flag, int length) {
        String flagMsg = flag.getFlagMsg().msg();
        if (flag.getFlagMsg().msg().length() > length) {
            flagMsg = flagMsg.substring(0, length) + "...";
        }
        return class_2561.method_43470(flagMsg);
    }

    public static class_5250 truncateMsg(IFlag flag) {
        return truncateMsg(flag, 30);
    }

    /**
     * Message: [set] [x]: 'msg' <br>
     */
    public static class_5250 buildFlagMessageComponent(IProtectedRegion region, IFlag flag) {
        class_5250 editLink = buildFlagMessageEditLink(region, flag);
        class_5250 clearLink = buildFlagMessageClearLink(region, flag);
        class_5250 flagMsgTextWithHover = buildFlagMessageHoverText(region, flag);
        return Messages.substitutable("%s %s '%s'", editLink, clearLink, flagMsgTextWithHover);
    }

    public static List<class_2561> buildRemoveRegionEntries(IProtectedRegion parent, List<IProtectedRegion> regions) {
        return regions.stream().map(region -> buildRemoveRegionEntry(parent, region)).collect(Collectors.toList());
    }

    public static class_5250 buildRemoveRegionEntry(IProtectedRegion parent, IProtectedRegion region) {
        class_5250 regionRemoveLink;
        switch (parent.getRegionType()) {
            case GLOBAL: {
                regionRemoveLink = Messages.substitutable("%s %s", buildDimResetComponent((DimensionalRegion) region), buildRegionInfoLink(region));
                break;
            }
            case DIMENSION: {
                class_5250 removeLink;
                class_5250 regionInfoLinkWithIndicator;
                class_5250 childCompInfo = class_2561.method_48321("cli.msg.info.dim.region.child.hover", "This is a direct child region of the Dimensional Region");
                class_5250 childIndicator = buildTextWithHoverAndBracketsMsg(class_2561.method_43470("*"), childCompInfo, field_1065);
                if (parent.hasChild(region)) {
                    regionInfoLinkWithIndicator = Messages.substitutable("%s%s", buildRegionInfoLink(region), childIndicator);
                } else {
                    regionInfoLinkWithIndicator = Messages.substitutable("%s", buildRegionInfoLink(region));
                }
                removeLink = buildDimSuggestRegionRemovalLink((IMarkableRegion) region);
                regionRemoveLink = Messages.substitutable("%s %s", removeLink, regionInfoLinkWithIndicator);
                break;
            }
            case LOCAL: {
                regionRemoveLink = Messages.substitutable("%s %s", buildRegionRemoveChildLink(parent, region), buildRegionInfoLink(region));
                break;
            }
            default:
                throw new IllegalArgumentException();
        }
        return Messages.substitutable(" - %s", regionRemoveLink);
    }

    private static class_5250 buildDimResetComponent(DimensionalRegion region) {
        String cmd = buildCommandStr(DIM.toString(), region.getDim().method_29177().toString(), CommandConstants.RESET.toString(), DIM.toString());
        class_5250 hover = class_2561.method_48322("cli.dim.reset.dim.link.hover", "Reset Dimensional Region '%s'", region.getName());
        class_5250 text = class_2561.method_48321("cli.link.action.undo.text", "<-");
        return buildExecuteCmdComponent(text, hover, cmd, field_11745, REMOVE_CMD_COLOR);
    }

    public static class_5250 buildInfoComponent(String subjectLangKey, String fallback, class_5250 payload) {
        return Messages.substitutable("%s: %s", class_2561.method_48321(subjectLangKey, fallback), payload);
    }

    public static class_5250 buildInfoComponent(class_5250 subject, class_5250 info, class_5250 actions) {
        return Messages.substitutable("%s: %s | %s", subject, info, actions);
    }

    public static class_5250 buildInfoComponent(class_5250 subject, class_5250 content) {
        return Messages.substitutable("%s: %s", subject, content);
    }

    public static String buildExecuteCommandString(class_5321<class_1937> dim, String command) {
        return "/execute in " + dim.method_29177() + " run " + command;
    }

    public static String buildTeleportCmd(class_5321<class_1937> dim, String tpSource, class_2338 target) {
        return buildExecuteCommandString(dim, "tp " + tpSource + " " + commandBlockPosStr(target));
    }

    /**
     * @param region    the region to build the link for
     * @param names     the names of the players or teams of the group
     * @param groupType the type of the group (player or team)
     * @param group     the name of the group
     * @return a list of links to remove the group from the region
     */
    public static List<class_2561> buildRemoveGroupMemberEntries(IProtectedRegion region, List<String> names, GroupType groupType, String group) {
        return names.stream().map(name -> buildRemoveGroupEntry(region, name, groupType, group)).collect(Collectors.toList());
    }

    public static class_5250 buildRemoveGroupEntry(IProtectedRegion region, String name, GroupType groupType, String group) {
        class_5250 linkText = class_2561.method_48321("cli.link.remove", "x");
        class_5250 hoverText = class_2561.method_48322("cli.msg.info.region.group." + groupType.name + ".remove.link.hover", "Remove " + groupType.name + " '%s' from region %s", name, region.getName());
        class_5250 regionRemoveLink;
        // TODO: could be moved to ChatLinkBuilder
        if (groupType == GroupType.PLAYER) {
            class_1657 player = PlayerManager.getPlayer(name);
            boolean isOffline = player == null;
            if (isOffline) {
                class_5250 offlinePlayerRemoveLink = buildRemoveLinkForOfflinePlayer(region, name, groupType, group, linkText, hoverText);
                return Messages.substitutable(" - %s %s", offlinePlayerRemoveLink, buildGroupInfo(region, name, groupType));
            }
        }
        regionRemoveLink = buildRemoveGroupMemberLink(region, name, groupType, group, linkText, hoverText);
        return Messages.substitutable(" - %s %s", regionRemoveLink, buildGroupInfo(region, name, groupType));
    }

    public static class_5250 buildGroupInfo(IProtectedRegion region, String groupMemberName, GroupType groupType) {
        return switch (groupType) {
            case PLAYER -> {
                class_1657 player = PlayerManager.getPlayer(groupMemberName);
                if (player == null) {
                    yield class_2561.method_43469("%s %s", class_2561.method_43470(groupMemberName).method_27692(field_1080), class_2561.method_48321("cli.msg.info.player.list.entry.offline", "(offline)"));
                } else {
                    yield buildPlayerHoverComponent(player);
                }
            }
            case TEAM -> {
                class_270 team = PlayerManager.getTeam(groupMemberName);
                yield team == null ? class_2561.method_43470(groupMemberName) : buildTeamHoverComponent(team);
            }
        };
    }

    public static List<String> getGroupList(IProtectedRegion region, String group, GroupType groupType) {
        switch (groupType) {
            case PLAYER:
                return getPlayerNamesByState(region, group);
            case TEAM:
                return region.getGroup(group).getTeams().stream().sorted().collect(Collectors.toList());
            default:
                return new ArrayList<>();
        }
    }

    /**
     * Lookup which players are online and put them first, sorted alphabetical by their name
     * Adds the offline players after the online players, also sorted alphabetical by their name
     */
    private static @NotNull List<String> getPlayerNamesByState(IProtectedRegion region, String group) {
        List<String> names = new ArrayList<>(region.getGroup(group).getPlayers().values());
        // Lookup which players are online and put them first, sorted alphabetical by their name
        List<String> onlinePlayerNames = names.stream()
                .map(name -> Map.entry(name, PlayerManager.getPlayer(name) != null))
                .filter(Map.Entry::getValue)
                .map(Map.Entry::getKey)
                .sorted().toList();
        names.removeAll(onlinePlayerNames);
        // add the offline players after the online players, also sorted alphabetical by their name
        List<String> offlinePlayers = names.stream().sorted().toList();
        List<String> playerNames = new ArrayList<>(onlinePlayerNames);
        playerNames.addAll(offlinePlayers);
        return playerNames;
    }


    public static class_5250 buildFlagInfoHeader(IProtectedRegion region, IFlag flag) {
        return buildHeader(class_2561.method_48322("cli.msg.info.header.flag.in", "== Flag %s in %s ==",
                buildFlagInfoLink(region, flag),
                buildRegionInfoLink(region)));
    }
}
