package de.z0rdak.yawp.util;

import de.z0rdak.yawp.constants.serialization.ItemNbtKeys;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.stick.AbstractStick;
import de.z0rdak.yawp.core.stick.MarkerStick;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

import static net.minecraft.class_124.*;

public final class StickUtil {

    private static final String MARKED_BLOCK_INDICATOR = "X";
    private static final String UNMARKED_BLOCK_INDICATOR = "#";
    private static final String TP_POS_INDICATOR = "TP";
    private static final class_124 MARKED_BLOCK_COLOR = field_1060;
    private static final class_124 UNMARKED_BLOCK_COLOR = field_1061;
    private static final class_124 UNMARKED_POS_COLOR = field_1075;

    private StickUtil() {
    }

    public static void applyEnchantmentGlint(class_1799 item) {
        class_2487 dummy = new class_2487();
        dummy.method_10582("id", "");
        dummy.method_10569("lvl", 1);
        class_2499 enchantmentList = new class_2499();
        enchantmentList.add(dummy);
        item.method_7959("Enchantments", enchantmentList);
    }

    /**
     * Set init (default) nbt value for sticks
     *
     * @param stick stick item
     * @param type  stick type to create
     * @param dim   dimension tag to set for sticks
     */
    public static void initStickTag(class_1799 stick, StickType type, class_5321<class_1937> dim) {
        class_2487 itemTag = stick.method_7985() ? stick.method_7969() : new class_2487();
        if (itemTag != null) {
            if (Objects.requireNonNull(type) == StickType.MARKER) {
                class_2487 compoundNBT = new MarkerStick(dim).serializeNBT();
                itemTag.method_10566(ItemNbtKeys.STICK, compoundNBT);
                stick.method_7980(itemTag);
            }
        }
    }

    public static class_1799 initMarkerNbt(class_1799 stack, class_5321<class_1937> dim) {
        stack.method_7939(1);
        initStickTag(stack, StickType.MARKER, dim);
        setStickName(stack, StickType.MARKER);
        setStickToolTip(stack, StickType.MARKER);
        applyEnchantmentGlint(stack);
        return stack;
    }

    public static boolean isVanillaStick(class_1799 itemStack) {
        return itemStack.method_7909().method_7854().method_7922().equals(class_1802.field_8600.method_7876());
    }

    public static AbstractStick getStick(class_1799 stick) throws StickException {
        if (stick.method_7969() != null && stick.method_7985()) {
            if (stick.method_7969().method_10545(ItemNbtKeys.STICK)) {
                class_2487 stickNbt = stick.method_7969().method_10562(ItemNbtKeys.STICK);
                StickType type = StickType.of(stickNbt.method_10558(ItemNbtKeys.STICK_TYPE));
                switch (type) {
                    case MARKER:
                        return new MarkerStick(stickNbt);
                    case UNKNOWN:
                    default:
                        throw new StickException("Unknown stick type: '" + type + "'!");
                }
            }
        }
        throw new StickException("Invalid or missing NBT data for Stick '" + stick.method_7954().getString() + "'!");
    }

    public static StickType getStickType(class_1799 stick) {
        if (stick.method_7969() != null && stick.method_7985()) {
            if (stick.method_7969().method_10545(ItemNbtKeys.STICK)) {
                class_2487 stickNbt = stick.method_7969().method_10562(ItemNbtKeys.STICK);
                if (stickNbt.method_10545(ItemNbtKeys.STICK_TYPE)) {
                    return StickType.of(stickNbt.method_10558(ItemNbtKeys.STICK_TYPE));
                }
            }
        }
        return StickType.UNKNOWN;
    }

    public static class_2487 getStickNBT(class_1799 stick) {
        if (stick.method_7969() != null && stick.method_7985()
                && stick.method_7969().method_10545(ItemNbtKeys.STICK)) {
            return stick.method_7969().method_10562(ItemNbtKeys.STICK);
        } else {
            return null;
        }
    }

    @Nullable
    public static IMarkableArea getMarkedArea(class_1799 stick) {
        if (isVanillaStick(stick) && isMarker(stick)) {
            class_2487 stickNBT = StickUtil.getStickNBT(stick);
            if (stickNBT != null) {
                MarkerStick marker = new MarkerStick(stickNBT);
                if (!marker.isValidArea()) {
                    return null;
                }
                return LocalRegions.areaFrom(marker);
            }
        }
        return null;
    }

    public static boolean isMarker(class_1799 stick) {
        return getStickType(stick) == StickType.MARKER;
    }

    public static void setStickName(class_1799 stick, StickType type) {
        if (Objects.requireNonNull(type) == StickType.MARKER) {
            MarkerStick marker = new MarkerStick(getStickNBT(stick));
            class_5250 markerIndicators = buildRegionMarkerIndicators(marker);
            class_5250 markerHoverName = buildStickName(marker)
                    .method_27693(" ")
                    .method_10852(markerIndicators);
            stick.method_7977(markerHoverName);
        }
    }

    private static class_5250 buildStickName(MarkerStick marker) {
        class_5250 stickName = class_2561.method_43470(marker.getStickType().stickName).method_27692(field_1065);
        class_5250 areaType = class_2561.method_43470(" (").method_27693(marker.getAreaType().areaType).method_27693(")");
        return stickName.method_10852(areaType);
    }

    /**
     * @param isMarked
     * @return [X] or [#]
     */
    private static class_5250 buildMarkerIndicator(boolean isMarked) {
        String indicator = isMarked ? MARKED_BLOCK_INDICATOR : UNMARKED_BLOCK_INDICATOR;
        class_124 color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_BLOCK_COLOR;
        class_5250 indicatorComp = class_2561.method_43470(indicator).method_27692(color);
        class_5250 closedResetComp = class_2561.method_43470("]").method_27692(field_1070);
        return class_2561.method_43470("[").method_10852(indicatorComp).method_10852(closedResetComp);
    }

    /**
     * RegionMarker [x][x] [TP]
     *
     * @param marker
     * @return
     */
    private static class_5250 buildRegionMarkerIndicators(MarkerStick marker) {
        class_5250 regionMarkerIndicators = class_2561.method_43470("");
        int maxBlocks = marker.getAreaType().maxBlocks;
        int amountUnmarked = maxBlocks - marker.getMarkedBlocks().size();
        for (int i = 0; i < marker.getMarkedBlocks().size(); i++) {
            regionMarkerIndicators.method_10852(buildMarkerIndicator(true));
        }
        for (int i = 0; i < amountUnmarked; i++) {
            regionMarkerIndicators.method_10852(buildMarkerIndicator(false));
        }
        return regionMarkerIndicators;
    }

    public static void setStickToolTip(class_1799 stick, StickType type) {
        if (Objects.requireNonNull(type) == StickType.MARKER) {
            setToolTip(stick, getMarkerToolTip());
        }
    }

    public static void setToolTip(class_1799 stack, class_2499 loreNbt) {
        stack.method_7911("display").method_10566("Lore", loreNbt);
    }

    public static boolean hasNonNullTag(class_1799 itemStack) {
        return itemStack.method_7985() && itemStack.method_7969() != null;
    }

    private static class_2499 getMarkerToolTip() {
        class_2499 lore = new class_2499();
        lore.add(buildLoreTextLine(class_2561.method_48321("help.tooltip.stick.marker.simple.1", "Used to mark a new region."), "#ff4d4d"));
        lore.add(buildLoreTextLine(class_2561.method_48321("help.tooltip.stick.marker.simple.2", "Keep the Region Marker in your hand while creating a region!"), "#ff4d4d"));
        lore.add(buildLoreTextLine(class_2561.method_43470(field_1056 + "").method_10852(class_2561.method_48321("help.tooltip.stick.marker.simple.3", "Mark a (Cuboid) region by right-clicking the diagonal opposite corner blocks.")), "#808080"));
        lore.add(buildLoreTextLine(class_2561.method_43470(field_1056 + "").method_10852(class_2561.method_48321("help.tooltip.stick.marker.simple.4", "Set a region teleport position by shift-right-clicking a block.")), "#808080"));
        return lore;
    }

    private static class_2519 buildLoreTextLine(String text, String hexColor) {
        return class_2519.method_23256("{\"text\":\"" + text + "\", \"color\":\"" + hexColor + "\"}");
    }

    private static class_2519 buildLoreTextLine(class_5250 text, String hexColor) {
        return buildLoreTextLine(text.getString(), hexColor);
    }

}
