package de.z0rdak.yawp.util.text.messages;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.network.chat.*;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/* Note: Inheritance requires mod to be present on client side */
@Deprecated(since = "Not used until YAWP is required on client-side", forRemoval = false)
public class SubstituteTextContent implements class_7417 {
    private static final class_5348 LITERAL_PERCENT_SIGN = class_5348.method_29430("%");
    private static final class_5348 NULL_ARGUMENT = class_5348.method_29430("null");
    private static final Pattern ARG_FORMAT = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    private final String pattern;
    @Nullable
    private final Object[] args;
    @Nullable
    private List<class_5348> substitutes = ImmutableList.of();

    public SubstituteTextContent(String pattern, Object[] args) {
        this.pattern = pattern;
        this.args = args;
    }

    private void updateSubstitutes() {
        try {
            ImmutableList.Builder<class_5348> builder = ImmutableList.builder();
            this.forEachPart(pattern, builder::add);
            this.substitutes = builder.build();
        } catch (SubstituteException substituteException) {
            this.substitutes = ImmutableList.of(class_5348.method_29430(pattern));
        }
    }

    private void forEachPart(String substitute, Consumer<class_5348> partsConsumer) {
        Matcher matcher = ARG_FORMAT.matcher(substitute);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                String string;
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    string = substitute.substring(j, k);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    partsConsumer.accept(class_5348.method_29430(string));
                }
                string = matcher.group(2);
                String string2 = substitute.substring(k, l);
                if ("%".equals(string) && "%%".equals(string2)) {
                    partsConsumer.accept(LITERAL_PERCENT_SIGN);
                } else if ("s".equals(string)) {
                    String string3 = matcher.group(1);
                    int m = string3 != null ? Integer.parseInt(string3) - 1 : i++;
                    partsConsumer.accept(this.getArg(m));
                } else {
                    throw new SubstituteException(this, "Unsupported format: '" + string2 + "'");
                }
                j = l;
            }
            if (j < substitute.length()) {
                String string4 = substitute.substring(j);
                if (string4.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                partsConsumer.accept(class_5348.method_29430(string4));
            }
        } catch (IllegalArgumentException illegalArgumentException) {
            throw new SubstituteException(this, illegalArgumentException);
        }
    }

    public final class_5348 getArg(int index) {
        if (index < 0 || index >= this.args.length) {
            throw new SubstituteException(this, index);
        }
        Object object = this.args[index];
        if (object instanceof class_2561) {
            return (class_2561) object;
        }
        return object == null ? NULL_ARGUMENT : class_5348.method_29430(object.toString());
    }

    @Override
    public <T> Optional<T> method_27660(class_5348.class_5246<T> visitor, class_2583 style) {
        this.updateSubstitutes();
        if (this.substitutes == null)
            return Optional.empty();
        for (class_5348 stringVisitable : this.substitutes) {
            Optional<T> optional = stringVisitable.method_27658(visitor, style);
            if (optional.isEmpty()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public <T> Optional<T> method_27659(class_5348.class_5245<T> visitor) {
        this.updateSubstitutes();
        if (this.substitutes == null)
            return Optional.empty();
        for (class_5348 stringVisitable : this.substitutes) {
            Optional<T> optional = stringVisitable.method_27657(visitor);
            if (optional.isEmpty()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public class_5250 method_10890(@Nullable class_2168 source, @Nullable class_1297 sender, int depth) throws CommandSyntaxException {
        Object[] objects = new Object[this.args.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = this.args[i];
            objects[i] = object instanceof class_2561 ? class_2564.method_10881(source, (class_2561) object, sender, depth) : object;
        }
        return class_5250.method_43477(new SubstituteTextContent(this.pattern, objects));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubstituteTextContent substituteTextContent)) return false;
        if (!Objects.equals(this.pattern, substituteTextContent.pattern)) return false;
        return Arrays.equals(this.args, substituteTextContent.args);
    }

    public int hashCode() {
        int i = Objects.hashCode(this.pattern);
        i = 31 * i + Arrays.hashCode(this.args);
        return i;
    }

    public String toString() {
        return "substitute{key='" + this.pattern + "', args=" + Arrays.toString(this.args) + "}";
    }

    public String getPattern() {
        return this.pattern;
    }


    public Object[] getArgs() {
        return this.args;
    }
}


