/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.events.region.RegionEvent;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.CommandUtil;
import de.z0rdak.yawp.commands.DimensionCommands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.region.AddRegionChildArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RemoveRegionChildArgumentType;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.RegionAnchors;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.LevelRegionData;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.TeleportAnchorPagination;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2186;
import net.minecraft.class_2189;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

class RegionCommands {
    private RegionCommands() {
    }

    static LiteralArgumentBuilder<class_2168> build() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.LOCAL).then(class_2170.method_9244((String)CommandConstants.DIM.toString(), (ArgumentType)class_2181.method_9288()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestions(ctx, builder)).executes(ctx -> CommandUtil.promptRegionInfo((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))).then(ArgumentUtil.literal(CommandConstants.INFO).executes(ctx -> CommandUtil.promptRegionInfo((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx))))).then(CommandUtil.buildClearSubCommand(ArgumentUtil::getRegionArgument))).then(CommandUtil.buildAddSubCommand(ArgumentUtil::getRegionArgument))).then(CommandUtil.buildListSubCommand(ArgumentUtil::getRegionArgument))).then(CommandUtil.buildRemoveSubCommand(ArgumentUtil::getRegionArgument))).then(CommandUtil.buildCopySubCommand(ArgumentUtil::getRegionArgument))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.DELETE).executes(ctx -> DimensionCommands.attemptDeleteRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))).then(ArgumentUtil.literal(CommandConstants.FOR_SURE).executes(ctx -> DimensionCommands.deleteRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.ADD).then(ArgumentUtil.literal(CommandConstants.CHILD).then(class_2170.method_9244((String)CommandConstants.CHILD.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> AddRegionChildArgumentType.potentialChildRegions().listSuggestions(ctx, builder)).executes(ctx -> RegionCommands.addChildren((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getChildRegionArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.REMOVE).then(ArgumentUtil.literal(CommandConstants.CHILD).then(class_2170.method_9244((String)CommandConstants.CHILD.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RemoveRegionChildArgumentType.childRegions().listSuggestions(ctx, builder)).executes(ctx -> RegionCommands.removeChildren((CommandContext<class_2168>)ctx, ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getChildRegionArgument((CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.STATE).executes(ctx -> CommandUtil.promptRegionState((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ALERT).executes(ctx -> CommandUtil.setAlertState((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx).isMuted()))).then(class_2170.method_9244((String)CommandConstants.ALERT.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CommandUtil.setAlertState((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getAlertArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ENABLE).executes(ctx -> CommandUtil.setActiveState((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), !ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx).isActive()))).then(class_2170.method_9244((String)CommandConstants.ENABLE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> CommandUtil.setActiveState((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getEnableArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.PRIORITY).then(class_2170.method_9244((String)CommandConstants.PRIORITY.toString(), (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RegionCommands.setPriority((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getPriorityArgument((CommandContext<class_2168>)ctx))))).then(ArgumentUtil.literal(CommandConstants.INC).then(class_2170.method_9244((String)CommandConstants.PRIORITY.toString(), (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RegionCommands.setPriority((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getPriorityArgument((CommandContext<class_2168>)ctx), 1))))).then(ArgumentUtil.literal(CommandConstants.DEC).then(class_2170.method_9244((String)CommandConstants.PRIORITY.toString(), (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RegionCommands.setPriority((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getPriorityArgument((CommandContext<class_2168>)ctx), -1))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.AREA).executes(ctx -> RegionCommands.promptRegionAreaInfo((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.SET).then(class_2170.method_9247((String)AreaType.CUBOID.areaType).then(class_2170.method_9244((String)CommandConstants.POS1.toString(), (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)CommandConstants.POS2.toString(), (ArgumentType)class_2262.method_9698()).executes(ctx -> RegionCommands.setCuboidArea((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.POS1.toString()), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.POS2.toString()))))))).then(class_2170.method_9247((String)AreaType.SPHERE.areaType).then(class_2170.method_9244((String)CommandConstants.CENTER_POS.toString(), (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> RegionCommands.setSphereArea((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString())))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.EXPAND).then(((LiteralArgumentBuilder)class_2170.method_9247((String)AreaType.CUBOID.areaType).executes(ctx -> RegionCommands.expandCuboid((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), -64, 320))).then(class_2170.method_9244((String)CommandConstants.Y_MIN.toString(), (ArgumentType)IntegerArgumentType.integer()).then(class_2170.method_9244((String)CommandConstants.Y_MAX.toString(), (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RegionCommands.expandCuboid((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.Y_MIN.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.Y_MAX.toString()))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)AreaType.SPHERE.areaType).executes(ctx -> RegionCommands.expandSphere((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), 1))).then(class_2170.method_9244((String)CommandConstants.EXPANSION.toString(), (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> RegionCommands.expandSphere((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.EXPANSION.toString())))))))).then(ArgumentUtil.literal(CommandConstants.LIST).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.TP_ANCHOR).executes(ctx -> RegionCommands.promptTeleportAnchorPagination((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), 0))).then(class_2170.method_9244((String)CommandConstants.PAGE.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> RegionCommands.promptTeleportAnchorPagination((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getPageNoArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.ADD).then(ArgumentUtil.literal(CommandConstants.TP_ANCHOR).then(class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(List.of("tpAnchor-name"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)CommandConstants.TP_ANCHOR.toString(), (ArgumentType)class_2262.method_9698()).executes(ctx -> RegionCommands.updateTeleportAnchor((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getTeleportAnchorPosArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getTeleportAnchorNameArgument((CommandContext<class_2168>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.REMOVE).then(ArgumentUtil.literal(CommandConstants.TP_ANCHOR).then(class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).executes(ctx -> RegionCommands.removeTeleportAnchor((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getTeleportAnchorNameArgument((CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.TP_ANCHOR).then(ArgumentUtil.literal(CommandConstants.RENAME).then(class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)CommandConstants.RENAME.toString(), (ArgumentType)StringArgumentType.word()).executes(ctx -> RegionCommands.renameTeleportAnchor((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getTeleportAnchorNameArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getNewTeleportAnchorNameArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.SET).then(class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(List.of("tpAnchor-name"), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)CommandConstants.TP_ANCHOR.toString(), (ArgumentType)class_2262.method_9698()).executes(ctx -> RegionCommands.updateTeleportAnchor((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getTeleportAnchorPosArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getTeleportAnchorNameArgument((CommandContext<class_2168>)ctx))))))).then(ArgumentUtil.literal(CommandConstants.HIDE).then(class_2170.method_9244((String)CommandConstants.TP_ANCHOR.toString(), (ArgumentType)StringArgumentType.word()).executes(ctx -> RegionCommands.hideTpAnchor((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), StringArgumentType.getString((CommandContext)ctx, (String)CommandConstants.TP_ANCHOR.toString())))))).then(ArgumentUtil.literal(CommandConstants.SHOW).then(class_2170.method_9244((String)CommandConstants.TP_ANCHOR.toString(), (ArgumentType)StringArgumentType.word()).executes(ctx -> RegionCommands.showTpAnchor((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), StringArgumentType.getString((CommandContext)ctx, (String)CommandConstants.TP_ANCHOR.toString())))))).then(ArgumentUtil.literal(CommandConstants.TELEPORT).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.TP_ANCHOR.toString(), (ArgumentType)StringArgumentType.word()).executes(ctx -> RegionCommands.teleport((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), StringArgumentType.getString((CommandContext)ctx, (String)CommandConstants.TP_ANCHOR.toString())))).then(class_2170.method_9244((String)CommandConstants.PLAYER.toString(), (ArgumentType)class_2186.method_9305()).executes(ctx -> RegionCommands.teleport((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), StringArgumentType.getString((CommandContext)ctx, (String)CommandConstants.TP_ANCHOR.toString()), ArgumentUtil.getPlayerArgument((CommandContext<class_2168>)ctx)))))))).then(ArgumentUtil.literal(CommandConstants.RENAME).then(class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Collections.singletonList(ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx).getName()), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.renameRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getLevelDataArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.SHOW).executes(ctx -> RegionCommands.promptVisualizationOptions((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.LOCAL).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), DisplayType.FRAME))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.BLOCK.toString(), (ArgumentType)class_2232.method_9441()).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayBlockArgument((CommandContext<class_2168>)ctx)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.GLOW.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayBlockArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayGlowArgument((CommandContext<class_2168>)ctx)))).then(class_2170.method_9244((String)CommandConstants.LIGHT_LEVEL.toString(), (ArgumentType)IntegerArgumentType.integer((int)0, (int)15)).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayBlockArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayGlowArgument((CommandContext<class_2168>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.LIGHT_LEVEL.toString()))))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.HIERARCHY).executes(ctx -> RegionCommands.showRegionHierarchy((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), DisplayType.FRAME, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.showRegionHierarchy((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), false))).then(class_2170.method_9244((String)CommandConstants.RECURSIVE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RegionCommands.showRegionHierarchy((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), BoolArgumentType.getBool((CommandContext)ctx, (String)CommandConstants.RECURSIVE.toString()))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.INTERSECTING).executes(ctx -> RegionCommands.showRegionsIntersecting((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), DisplayType.FRAME))).then(class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.showRegionsIntersecting((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.HIDE).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.LOCAL).executes(ctx -> RegionCommands.hideRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), DisplayType.FRAME))).then(class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.hideRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx)))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.HIERARCHY).executes(ctx -> RegionCommands.hideRegionHierarchy((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), DisplayType.FRAME, true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.hideRegionHierarchy((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), false))).then(class_2170.method_9244((String)CommandConstants.RECURSIVE.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RegionCommands.hideRegionHierarchy((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), BoolArgumentType.getBool((CommandContext)ctx, (String)CommandConstants.RECURSIVE.toString()))))))).then(((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.INTERSECTING).executes(ctx -> RegionCommands.hideRegionsIntersecting((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), DisplayType.FRAME))).then(class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.hideRegionsIntersecting((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.DISPLAY).executes(ctx -> RegionCommands.promptDisplaySettings((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))).then(ArgumentUtil.literal(CommandConstants.BLOCK).then(class_2170.method_9244((String)CommandConstants.BLOCK.toString(), (ArgumentType)class_2232.method_9441()).executes(ctx -> RegionCommands.setDisplayBlock((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayBlockArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.GLOW).then(class_2170.method_9244((String)CommandConstants.GLOW.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> RegionCommands.setDisplayGlow((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), ArgumentUtil.getDisplayGlowArgument((CommandContext<class_2168>)ctx)))))).then(ArgumentUtil.literal(CommandConstants.LIGHT_LEVEL).then(class_2170.method_9244((String)CommandConstants.LIGHT_LEVEL.toString(), (ArgumentType)IntegerArgumentType.integer((int)0, (int)15)).executes(ctx -> RegionCommands.setDisplayLightLevel((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.LIGHT_LEVEL.toString())))))).then(ArgumentUtil.literal(CommandConstants.RESET).executes(ctx -> RegionCommands.resetDisplaySettings((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionArgument((CommandContext<class_2168>)ctx)))))));
    }

    private static int setDisplayLightLevel(CommandContext<class_2168> ctx, IMarkableRegion region, int lightLevel) {
        IMarkableArea area = region.getArea();
        area.getDisplay().setLightLevel(lightLevel);
        RegionManager.get().save();
        VisualizationManager.refreshDisplay(region);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"Set light level for area display for region %s to '%s'", (String)"Set display light level for %s to '%s'", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), lightLevel}));
        return 0;
    }

    public static int resetDisplaySettings(CommandContext<class_2168> ctx, IMarkableRegion region) {
        IMarkableArea area = region.getArea();
        area.getDisplay().setHasGlow(true);
        area.getDisplay().setLightLevel(15);
        RegionManager.get().save();
        VisualizationManager.refreshDisplay(region);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"Reset display settings for region %s", (String)"Reset display settings for %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
        return 0;
    }

    public static int setDisplayGlow(CommandContext<class_2168> ctx, IMarkableRegion region, boolean hasGlow) {
        IMarkableArea area = region.getArea();
        BlockDisplayProperties display = area.getDisplay();
        if (display.hasGlow() != hasGlow) {
            display.setHasGlow(hasGlow);
            RegionManager.get().save();
            VisualizationManager.refreshDisplay(region);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"Set display glow effect for region %s to '%s'", (String)"Set display glow effect for %s to '%s'", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), Boolean.toString(hasGlow)}));
            return 0;
        }
        return 1;
    }

    public static int setDisplayBlock(CommandContext<class_2168> ctx, IMarkableRegion region, class_2960 blockRl) {
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(blockRl);
        if (block instanceof class_2189) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"Not found", (String)"Not found", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), blockRl.toString()}));
            return -1;
        }
        IMarkableArea area = region.getArea();
        area.getDisplay().setBlockRl(blockRl);
        RegionManager.get().save();
        VisualizationManager.refreshDisplay(region);
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"Set display block for region %s to '%s'", (String)"Set display block for %s to '%s'", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), blockRl.toString()}));
        return 0;
    }

    private static int expandSphere(CommandContext<class_2168> ctx, IMarkableRegion region, int expansion) {
        SphereArea expand = SphereArea.expand((SphereArea)region.getArea(), expansion);
        return RegionCommands.updateArea(ctx, region, expand);
    }

    private static int setSphereArea(CommandContext<class_2168> ctx, IMarkableRegion region, class_2338 center, int radius) {
        class_2338 newRadius = center.method_10069(0, radius, 0);
        return RegionCommands.setSphereArea(ctx, region, center, newRadius);
    }

    private static int setSphereArea(CommandContext<class_2168> ctx, IMarkableRegion region, class_2338 center, class_2338 radiusPos) {
        return RegionCommands.updateArea(ctx, region, new SphereArea(center, radiusPos));
    }

    private static int setCuboidArea(CommandContext<class_2168> ctx, IMarkableRegion region, class_2338 p1, class_2338 p2) {
        return RegionCommands.updateArea(ctx, region, new CuboidArea(p1, p2));
    }

    private static int expandCuboid(CommandContext<class_2168> ctx, IMarkableRegion region, int yMin, int yMax) {
        CuboidArea expand = CuboidArea.expand((CuboidArea)region.getArea(), yMin, yMax);
        return RegionCommands.updateArea(ctx, region, expand);
    }

    private static int updateArea(CommandContext<class_2168> ctx, IMarkableRegion region, IMarkableArea area) {
        try {
            class_3222 player;
            AreaType prevAreaType = region.getArea().getAreaType();
            AreaType newAreaType = area.getAreaType();
            IProtectedRegion parent = region.getParent();
            try {
                player = ((class_2168)ctx.getSource()).method_9207();
            }
            catch (CommandSyntaxException e) {
                player = null;
            }
            RegionEvent.UpdateArea updateArea = new RegionEvent.UpdateArea(region, area, (class_1657)player);
            updateArea = Services.EVENT.post(updateArea);
            area = updateArea.markedArea();
            block2 : switch (newAreaType) {
                case CUBOID: 
                case SPHERE: {
                    if (parent.getRegionType() == RegionType.DIMENSION) {
                        int newPriority = LocalRegions.ensureHigherRegionPriorityFor(region, Services.REGION_CONFIG.getDefaultPriority());
                        Constants.LOGGER.info("New priority {} for region {}", (Object)newPriority, (Object)region.getName());
                    }
                    if (parent.getRegionType() != RegionType.LOCAL) break;
                    IMarkableRegion localParent = (IMarkableRegion)parent;
                    switch (localParent.getArea().getAreaType()) {
                        case CUBOID: 
                        case SPHERE: {
                            if (localParent.getArea().containsOther(area)) {
                                int newPriority = LocalRegions.ensureHigherRegionPriorityFor(region, localParent.getPriority() + 1);
                                Constants.LOGGER.info("New priority {} for region {}", (Object)newPriority, (Object)region.getName());
                                break block2;
                            }
                            class_5250 updateAreaFailMsg = class_2561.method_48322((String)"cli.msg.info.region.area.area.update.fail.boundaries", (String)"Parent region %s does not fully contain new are for region %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(parent), ChatLinkBuilder.buildRegionInfoLink(region)});
                            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), updateAreaFailMsg);
                            return 1;
                        }
                        case CYLINDER: 
                        case POLYGON_3D: 
                        case PRISM: {
                            throw new UnsupportedOperationException("Unsupported area type");
                        }
                    }
                    break;
                }
                case CYLINDER: 
                case POLYGON_3D: 
                case PRISM: {
                    throw new UnsupportedOperationException("Unsupported area type");
                }
            }
            if (prevAreaType != newAreaType) {
                class_5250 updateAreaFailMsg = class_2561.method_48322((String)"cli.msg.info.region.area.update.type.change", (String)"AreaType for %s changed from %s to %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), prevAreaType, newAreaType});
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), updateAreaFailMsg);
            }
            region.setArea(area);
            RegionManager.get().save();
            VisualizationManager.updateRegionDisplay(region);
            class_5250 updateAreaMsg = class_2561.method_48322((String)"cli.msg.info.region.area.area.update", (String)"Updated %s for %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionAreaLink(region), ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), updateAreaMsg);
            return 0;
        }
        catch (Exception ex) {
            Constants.LOGGER.error("Failed to update area: {}", (Object)ex.getMessage());
            return 1;
        }
    }

    private static int renameRegion(CommandContext<class_2168> ctx, IMarkableRegion region, String regionName, LevelRegionData levelData) {
        if (region.getName().equals(regionName)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.name.no-change", (String)regionName));
            return 1;
        }
        int res = levelData.isValidRegionName(regionName);
        if (res == -1) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48321((String)"cli.msg.dim.info.region.create.name.invalid", (String)regionName));
            return res;
        }
        if (res == 1) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.name.exists", (String)"Dimension %s already contains region with name %s", (Object[])new Object[]{levelData.getDim().getName(), ChatLinkBuilder.buildRegionInfoLink(levelData.getLocal(regionName))}));
            return res;
        }
        try {
            class_3222 player;
            try {
                player = ((class_2168)ctx.getSource()).method_9207();
            }
            catch (CommandSyntaxException e) {
                player = null;
            }
            RegionEvent.Rename renameRegion = new RegionEvent.Rename(region, region.getName(), regionName, (class_1657)player);
            if (Services.EVENT.post(renameRegion)) {
                return 1;
            }
            String oldName = region.getName();
            levelData.renameLocal(region, regionName);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.name.success", (String)"Changed name of region %s from '%s' to '%s'", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), oldName, regionName}));
            RegionManager.get().save();
            return 0;
        }
        catch (IllegalArgumentException ex) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.dim.info.region.create.name.exists", (String)"Dimension %s already contains region with name %s", (Object[])new Object[]{levelData.getDim().getName(), ChatLinkBuilder.buildRegionInfoLink(levelData.getLocal(regionName))}));
            return 1;
        }
    }

    private static int removeChildren(CommandContext<class_2168> ctx, LevelRegionData dimCache, IProtectedRegion parent, IMarkableRegion child) {
        if (parent.hasChild(child)) {
            parent.removeChild(child);
            dimCache.getDim().addChild(child);
            LocalRegions.ensureLowerRegionPriorityFor(child, Services.REGION_CONFIG.getDefaultPriority());
            RegionManager.get().save();
            class_5250 parentLink = ChatLinkBuilder.buildRegionInfoLink(parent);
            class_5250 notLongerChildLink = ChatLinkBuilder.buildRegionInfoLink(child);
            class_5250 dimensionalLink = ChatLinkBuilder.buildRegionInfoLink(dimCache.getDim());
            class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.REMOVE, CommandConstants.ADD);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.children.remove", (String)"Removed child '%s' from region %s", (Object[])new Object[]{notLongerChildLink, parentLink}).method_27693(" ").method_10852((class_2561)undoLink));
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.parent.clear", (String)"Reset default parent for %s back to %s", (Object[])new Object[]{notLongerChildLink, dimensionalLink}));
            return 0;
        }
        return -1;
    }

    private static int addChildren(CommandContext<class_2168> ctx, IMarkableRegion parent, IMarkableRegion child) {
        boolean currentParentIsNotNullAndDimension;
        boolean bl = currentParentIsNotNullAndDimension = child.getParent() != null && child.getParent().getRegionType() == RegionType.DIMENSION;
        if (!parent.hasChild(child) && currentParentIsNotNullAndDimension) {
            if (!parent.getArea().containsOther(child.getArea())) {
                MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.arg.region.owned.invalid.containment", (String)"Region %s is not suitable as parent for %s (does not fully contain child region)", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(parent), ChatLinkBuilder.buildRegionInfoLink(child)}));
                return -1;
            }
            child.getParent().removeChild(child);
            parent.addChild(child);
            LocalRegions.ensureHigherRegionPriorityFor(child, parent.getPriority() + 1);
            RegionManager.get().save();
            class_5250 parentLink = ChatLinkBuilder.buildRegionInfoLink(parent);
            class_5250 childLink = ChatLinkBuilder.buildRegionInfoLink(child);
            class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), CommandConstants.ADD, CommandConstants.REMOVE);
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.children.add", (String)"Added child %s to region %s", (Object[])new Object[]{childLink, parentLink}).method_27693(" ").method_10852((class_2561)undoLink));
            return 0;
        }
        return -1;
    }

    private static int setPriority(CommandContext<class_2168> ctx, IMarkableRegion region, int priority, int factor) {
        long newValue = (long)region.getPriority() + (long)priority * (long)factor;
        if (Integer.MAX_VALUE - newValue > 0L) {
            return RegionCommands.setPriority(ctx, region, (int)newValue);
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.warn.region.state.priority.set.invalid", (String)"Unable to change priority for region %s: %s is to high/low", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), newValue}));
        return -1;
    }

    private static int setPriority(CommandContext<class_2168> ctx, IMarkableRegion region, int priority) {
        int parentPriority;
        IProtectedRegion parent = region.getParent();
        if (parent instanceof IMarkableRegion && (parentPriority = ((IMarkableRegion)parent).getPriority()) >= priority) {
            class_5250 updatePriorityFailMsg = class_2561.method_48322((String)"cli.msg.info.region.state.priority.set.fail.to-low", (String)"Unable to set priority for region %s. The priority is not higher than its parents priority", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), updatePriorityFailMsg);
            return 1;
        }
        boolean existRegionWithSamePriority = LocalRegions.hasAnyRegionWithSamePriority(region, priority);
        if (existRegionWithSamePriority) {
            class_5250 updatePriorityFailMsg = class_2561.method_48322((String)"cli.msg.info.region.state.priority.set.fail.same", (String)"Unable to set priority for region %s. There is already another region with priority %s.", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), priority});
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), updatePriorityFailMsg);
            return 1;
        }
        int oldPriority = region.getPriority();
        if (oldPriority != priority) {
            region.setPriority(priority);
            RegionManager.get().save();
            class_5250 undoLink = ChatLinkBuilder.buildRegionActionUndoLink(ctx.getInput(), String.valueOf(oldPriority), String.valueOf(priority));
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.state.priority.set.success", (String)"Changed priority for region %s: %s -> %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), oldPriority, region.getPriority()}).method_27693(" ").method_10852((class_2561)undoLink));
            return 0;
        }
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.state.priority.set.fail.no-change", (String)"Unable to set priority for region %s. The priority is the same.", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
        return 1;
    }

    public static int showRegion(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType) {
        return RegionCommands.showRegion(ctx, region, displayType, region.getArea().getDisplay().blockRl());
    }

    public static int showRegion(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType, class_2960 blockRl) {
        return RegionCommands.showRegion(ctx, region, displayType, blockRl, region.getArea().getDisplay().hasGlow());
    }

    public static int showRegion(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType, class_2960 blockRl, boolean glow) {
        return RegionCommands.showRegion(ctx, region, displayType, blockRl, glow, region.getArea().getDisplay().lightLevel());
    }

    public static int showRegion(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType, class_2960 blockRl, boolean glow, int lightLevel) {
        BlockDisplayProperties displayProperties = new BlockDisplayProperties(blockRl, glow, lightLevel);
        VisualizationManager.show(region, displayType, displayProperties);
        return 0;
    }

    public static int hideRegion(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType) {
        VisualizationManager.hide(region, displayType);
        return 0;
    }

    public static int showRegionsIntersecting(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType) {
        VisualizationManager.showIntersecting(region, displayType);
        return 0;
    }

    public static int showRegionHierarchy(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType, boolean recursive) {
        VisualizationManager.showHierarchy(region, displayType, recursive);
        return 0;
    }

    public static int hideRegionHierarchy(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType, boolean recursive) {
        VisualizationManager.hideHierarchy(region, displayType, recursive);
        return 0;
    }

    public static int hideRegionsIntersecting(CommandContext<class_2168> ctx, IMarkableRegion region, DisplayType displayType) {
        VisualizationManager.hideIntersecting(region, displayType);
        return 0;
    }

    private static int promptDisplaySettings(CommandContext<class_2168> ctx, IMarkableRegion region) {
        MultiLineMessage.send((class_2168)ctx.getSource(), MultiLineMessage.displaySettingsInfo(region));
        return 0;
    }

    private static int promptVisualizationOptions(CommandContext<class_2168> ctx, IMarkableRegion region) {
        MultiLineMessage.send((class_2168)ctx.getSource(), MultiLineMessage.visualizationOptions(region));
        return 0;
    }

    private static int promptTeleportAnchorPagination(CommandContext<class_2168> ctx, IMarkableRegion region, int pageNo) {
        try {
            int paginationSize = Services.REGION_CONFIG.getPaginationSize();
            TeleportAnchorPagination tpAnchorPagination = new TeleportAnchorPagination(region, pageNo, paginationSize);
            MultiLineMessage.send((class_2168)ctx.getSource(), tpAnchorPagination);
        }
        catch (InvalidPageNumberException e) {
            MessageSender.sendError((class_2168)ctx.getSource(), e.getError());
            return -1;
        }
        return 0;
    }

    private static int updateTeleportAnchor(CommandContext<class_2168> ctx, IMarkableRegion region, class_2338 pos, String name) {
        RegionAnchors tpAnchors = region.getTpAnchors();
        boolean hasAnchor = tpAnchors.hasAnchor(name);
        if (!hasAnchor && !RegionCommands.isValidName(name)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.fail-msg.invalid-name", (String)"Teleport Anchor name is invalid. Must be alphanumeric and between 3 and 50 letters.", (Object[])new Object[]{name, ChatLinkBuilder.buildRegionInfoLink(region)}));
            return -1;
        }
        if (!region.getArea().contains(pos)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.fail-msg.not-contained", (String)"Teleport Anchor pos must be inside the region.", (Object[])new Object[]{name, ChatLinkBuilder.buildRegionInfoLink(region)}));
            return -1;
        }
        if (tpAnchors.getTpAnchor(name).getPos().equals((Object)pos)) {
            return 0;
        }
        tpAnchors.addOrUpdate(name, pos);
        RegionManager.get().save();
        TeleportAnchor anchor = tpAnchors.getTpAnchor(name);
        VisualizationManager.updateTpAnchor(region, anchor);
        class_2561 blockTpLink = TeleportAnchorPagination.buildTeleportToAnchorLink(region, anchor);
        if (hasAnchor) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.updated.msg", (String)"Updated position of '%s' to %s", (Object[])new Object[]{name, blockTpLink}));
        } else {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.added.msg", (String)"Added new anchor '%s' at %s", (Object[])new Object[]{name, blockTpLink}));
        }
        return 0;
    }

    private static int removeTeleportAnchor(CommandContext<class_2168> ctx, IMarkableRegion region, String name) {
        RegionAnchors tpAnchors = region.getTpAnchors();
        if (!tpAnchors.hasAnchor(name)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.fail-msg.not-existent", (String)"Teleport anchor '%s' does not exist in %s", (Object[])new Object[]{name, ChatLinkBuilder.buildRegionInfoLink(region)}));
            return -1;
        }
        TeleportAnchor anchor = tpAnchors.getTpAnchor(name);
        tpAnchors.removeTpAnchor(name);
        RegionManager.get().save();
        class_5250 blockTpLink = ChatLinkBuilder.buildDimensionalBlockTpLink(region.getDim(), anchor.getPos(), class_2561.method_43470((String)ChatComponentBuilder.shortBlockPos(anchor.getPos())));
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.removed.msg", (String)"Removed teleport anchor '%s' (at %s ) from %s", (Object[])new Object[]{name, blockTpLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
        return 0;
    }

    public static boolean isValidName(String name) {
        return name != null && name.length() >= 4 && name.length() <= 50 && name.matches("^[a-zA-Z0-9][a-zA-Z0-9_-]*$");
    }

    private static int renameTeleportAnchor(CommandContext<class_2168> ctx, IMarkableRegion region, String name, String newName) {
        if (!RegionCommands.isValidName(name) || !RegionCommands.isValidName(newName)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.fail-msg.invalid-name", (String)"Teleport Anchor name is invalid. Must be alphanumeric and between 3 and 50 letters.", (Object[])new Object[]{name, ChatLinkBuilder.buildRegionInfoLink(region)}));
            return -1;
        }
        RegionAnchors tpAnchors = region.getTpAnchors();
        if (!tpAnchors.hasAnchor(name)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.fail-msg.not-existent", (String)"Teleport anchor '%s' does not exist in %s", (Object[])new Object[]{name, ChatLinkBuilder.buildRegionInfoLink(region)}));
            return -1;
        }
        if (tpAnchors.hasAnchor(newName)) {
            TeleportAnchor anchor = tpAnchors.getTpAnchor(newName);
            class_5250 blockTpLink = ChatLinkBuilder.buildDimensionalBlockTpLink(region.getDim(), anchor.getPos(), class_2561.method_43470((String)ChatComponentBuilder.shortBlockPos(anchor.getPos())));
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.fail-msg.already-present", (String)"Teleport anchor '%s' %s is already defined in %s", (Object[])new Object[]{name, blockTpLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
            return 1;
        }
        tpAnchors.rename(name, newName);
        RegionManager.get().save();
        MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_48322((String)"cli.msg.info.region.tp-anchor.renamed.msg", (String)"Renamed teleport anchor '%s' to '%s'", (Object[])new Object[]{name, newName}));
        return 0;
    }

    private static int promptRegionAreaInfo(CommandContext<class_2168> ctx, IMarkableRegion region) {
        MultiLineMessage.send((class_2168)ctx.getSource(), MultiLineMessage.areaInfo(region));
        return 0;
    }

    private static int teleport(CommandContext<class_2168> ctx, IMarkableRegion region, String tpAnchorName) {
        if (!region.getTpAnchors().hasAnchor(tpAnchorName)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)"TODO"));
            return -1;
        }
        try {
            class_3222 self = ((class_2168)ctx.getSource()).method_9207();
            return RegionCommands.teleport(ctx, region, tpAnchorName, self);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.warn("Unable to teleport command source to region. Can only be executed by a player");
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)"TODO"));
            return -1;
        }
    }

    private static int teleport(CommandContext<class_2168> ctx, IMarkableRegion region, String tpAnchorName, class_3222 playerToTeleport) {
        TeleportAnchor tpAnchor = region.getTpAnchors().getTpAnchor(tpAnchorName);
        class_2338 tpPos = tpAnchor.getPos();
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_9207();
            class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(region.getDim());
            if (level != null) {
                player.method_14251(level, (double)tpPos.method_10263(), (double)tpPos.method_10264(), (double)tpPos.method_10260(), player.method_36454(), player.method_36455());
                return 0;
            }
            Constants.LOGGER.error("Error executing teleport command. Level is null.");
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)"TODO"));
            return -1;
        }
        catch (CommandSyntaxException e) {
            class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(region.getDim());
            if (level != null) {
                playerToTeleport.method_14251(level, (double)tpPos.method_10263(), (double)tpPos.method_10264(), (double)tpPos.method_10260(), playerToTeleport.method_36454(), playerToTeleport.method_36455());
                return 0;
            }
            Constants.LOGGER.warn("Error executing teleport command.");
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)"TODO"));
            return -1;
        }
    }

    private static int showTpAnchor(CommandContext<class_2168> ctx, IMarkableRegion region, String tpAnchorName) {
        if (!region.getTpAnchors().hasAnchor(tpAnchorName)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)"TODO"));
            return -1;
        }
        TeleportAnchor tpAnchor = region.getTpAnchors().getTpAnchor(tpAnchorName);
        VisualizationManager.showTpAnchor(region, tpAnchor);
        return 0;
    }

    private static int hideTpAnchor(CommandContext<class_2168> ctx, IMarkableRegion region, String tpAnchorName) {
        if (!region.getTpAnchors().hasAnchor(tpAnchorName)) {
            MessageSender.sendCmdFeedback((class_2168)ctx.getSource(), class_2561.method_43470((String)"TODO"));
            return -1;
        }
        TeleportAnchor tpAnchor = region.getTpAnchors().getTpAnchor(tpAnchorName);
        VisualizationManager.hideTpAnchor(region, tpAnchor);
        return 0;
    }
}

