/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1548;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1927.class})
public abstract class ExplosionMixin {
    @Final
    @Shadow
    private class_1937 field_9187;
    @Final
    @Shadow
    @Nullable
    private class_1297 field_9185;

    @Unique
    private static void filterExplosionTargets(class_1927 explosion, class_1937 world, List<class_1297> affectedEntities) {
        boolean explosionTriggeredByCreeper;
        Predicate<FlagCheckEvent> isProtected = fce -> {
            if (Services.EVENT.post((FlagCheckEvent)fce)) {
                return true;
            }
            return FlagEvaluator.processCheck(fce) == FlagState.DENIED;
        };
        BiFunction<List, RegionFlag, Set> filterBlocks = (in, flag) -> in.stream().filter(blockPos -> isProtected.test(new FlagCheckEvent((class_2338)blockPos, (RegionFlag)((Object)flag), (class_5321<class_1937>)world.method_27983()))).collect(Collectors.toSet());
        BiFunction<List, RegionFlag, Set> filterEntities = (in, flag) -> in.stream().filter(entity -> isProtected.test(new FlagCheckEvent(entity.method_24515(), (RegionFlag)((Object)flag), (class_5321<class_1937>)world.method_27983()))).collect(Collectors.toSet());
        explosion.method_8346().removeAll(filterBlocks.apply(explosion.method_8346(), RegionFlag.EXPLOSION_BLOCK));
        affectedEntities.removeAll(filterEntities.apply(affectedEntities, RegionFlag.EXPLOSION_ENTITY));
        if (explosion.method_8347() != null && (explosionTriggeredByCreeper = explosion.method_8347() instanceof class_1548)) {
            explosion.method_8346().removeAll(filterBlocks.apply(explosion.method_8346(), RegionFlag.EXPLOSION_CREEPER_BLOCK));
            affectedEntities.removeAll(filterEntities.apply(affectedEntities, RegionFlag.EXPLOSION_CREEPER_ENTITY));
        }
    }

    @Inject(method={"explode"}, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraft/world/phys/Vec3;<init>(DDD)V", ordinal=1)}, allow=1)
    public void onExplosion(CallbackInfo ci, Set<class_2338> set, int i, float q, int k, int l, int r, int s, int t, int u, List<class_1297> list) {
        class_1927 explosion = (class_1927)this;
        if (this.field_9187 != null && HandlerUtil.isServerSide(this.field_9187) && this.field_9185 != null) {
            ExplosionMixin.filterExplosionTargets(explosion, this.field_9187, list);
        }
    }
}

