/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.platform;

import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.platform.services.IEventHelper;
import de.z0rdak.yawp.platform.services.IPermissionHelper;
import de.z0rdak.yawp.platform.services.IPlatformHelper;
import de.z0rdak.yawp.platform.services.config.IFlagConfigHelper;
import de.z0rdak.yawp.platform.services.config.ILoggingConfigHelper;
import de.z0rdak.yawp.platform.services.config.IPermissionConfigHelper;
import de.z0rdak.yawp.platform.services.config.IRegionConfigHelper;
import java.util.ServiceLoader;

public class Services {
    public static final IPlatformHelper PLATFORM = Services.load(IPlatformHelper.class);
    public static final IEventHelper EVENT = Services.load(IEventHelper.class);
    public static final IPermissionConfigHelper PERMISSION_CONFIG = Services.load(IPermissionConfigHelper.class);
    public static final IFlagConfigHelper FLAG_CONFIG = Services.load(IFlagConfigHelper.class);
    public static final IRegionConfigHelper REGION_CONFIG = Services.load(IRegionConfigHelper.class);
    public static final ILoggingConfigHelper LOGGING_CONFIG = Services.load(ILoggingConfigHelper.class);
    public static final IPermissionHelper PERMISSIONS = Services.load(IPermissionHelper.class);

    public static <T> T load(Class<T> clazz) {
        T loadedService = ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        Constants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

