/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.PlayerManager;
import de.z0rdak.yawp.util.AreaUtil;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_270;
import net.minecraft.class_3341;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class ChatComponentBuilder {
    private ChatComponentBuilder() {
    }

    public static String commandBlockPosStr(class_2338 target) {
        return target.method_10263() + " " + target.method_10264() + " " + target.method_10260();
    }

    public static String shortBlockPosBracketed(class_2338 target) {
        return "[" + ChatComponentBuilder.shortBlockPos(target) + "]";
    }

    public static String shortBlockPos(class_2338 target) {
        return "X=" + target.method_10263() + ", Y=" + target.method_10264() + ", Z=" + target.method_10260();
    }

    public static String tinyBlockPos(class_2338 target) {
        return "[" + ChatComponentBuilder.commandBlockPosStr(target) + "]";
    }

    public static String buildBlockPosLinkText(class_2338 target) {
        return target.method_10263() + ", " + target.method_10264() + ", " + target.method_10260();
    }

    public static class_5250 buildHeader(class_5250 header) {
        return header;
    }

    public static class_5250 buildExecuteCmdComponent(class_5250 linkText, class_5250 hoverText, String command, class_2558.class_2559 eventAction, class_124 color) {
        class_5250 text = class_2564.method_10885((class_2561)linkText);
        return text.method_10862(text.method_10866().method_10977(color).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)).method_10958(new class_2558(eventAction, command)));
    }

    public static class_5250 buildExecuteCmdLink(class_5250 linkText, class_5250 hoverText, String command, class_2558.class_2559 eventAction, class_124 color) {
        return linkText.method_10862(linkText.method_10866().method_10977(color).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)).method_10958(new class_2558(eventAction, command)));
    }

    public static class_5250 buildExecuteCmdLinkWithBrackets(class_5250 linkText, class_5250 hoverText, String command, class_2558.class_2559 eventAction, class_124 color) {
        class_5250 cmdLink = linkText.method_10862(linkText.method_10866().method_10977(color).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)).method_10958(new class_2558(eventAction, command)));
        return class_2564.method_10885((class_2561)cmdLink);
    }

    public static class_5250 buildPlayerHoverComponent(class_1657 player) {
        class_5250 playerName = class_2561.method_43470((String)player.method_5820());
        class_5250 playerInfo = Messages.substitutable("%s (%s)", player.method_5476(), player.method_5667().toString());
        playerName.method_10862(playerName.method_10866().method_10977(Messages.LINK_COLOR).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)playerInfo)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/tell " + playerName.getString() + " ")));
        return playerName;
    }

    public static class_5250 buildTeamHoverComponent(class_270 team) {
        class_5250 playerName = class_2561.method_43470((String)team.method_1197());
        playerName.method_10862(playerName.method_10866().method_10977(Messages.LINK_COLOR).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_48321((String)"cli.msg.info.region.group.link.hover", (String)"Click to display team info"))).method_10958(new class_2558(class_2558.class_2559.field_11750, "/team list " + team.method_1197())));
        return playerName;
    }

    public static class_5250 buildRegionAreaDetailComponent(IMarkableRegion region) {
        IMarkableArea area = region.getArea();
        class_5250 areaInfo = class_2561.method_43470((String)area.getAreaType().areaType);
        switch (area.getAreaType()) {
            case CUBOID: {
                return Messages.substitutable("%s, %s", areaInfo, ChatComponentBuilder.buildCuboidAreaInfo((CuboidArea)area));
            }
            case SPHERE: {
                return Messages.substitutable("%s, %s", areaInfo, ChatComponentBuilder.buildSphereAreaInfo((SphereArea)area));
            }
        }
        throw new IllegalArgumentException("Invalid area type");
    }

    private static class_5250 buildCuboidAreaInfo(CuboidArea cuboidArea) {
        return class_2561.method_48322((String)"cli.msg.info.region.area.area.size.text.cuboid", (String)"Size: %s %s %s", (Object[])new Object[]{ChatComponentBuilder.buildAreaAxisInfoComponent(cuboidArea, class_2350.class_2351.field_11048), ChatComponentBuilder.buildAreaAxisInfoComponent(cuboidArea, class_2350.class_2351.field_11052), ChatComponentBuilder.buildAreaAxisInfoComponent(cuboidArea, class_2350.class_2351.field_11051)});
    }

    private static class_5250 buildSphereAreaInfo(SphereArea sphereArea) {
        int diameter = sphereArea.getRadius() * 2 + 1;
        class_5250 centerPos = class_2561.method_43470((String)ChatComponentBuilder.buildBlockPosLinkText(sphereArea.getCenterPos()));
        return class_2561.method_48322((String)"cli.msg.info.region.area.area.size.text.sphere", (String)"Center: %s, Radius: %s, Diameter: %s", (Object[])new Object[]{ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(centerPos, centerPos, class_124.field_1068), sphereArea.getRadius(), diameter});
    }

    private static class_5250 buildAreaAxisInfoComponent(CuboidArea cuboidArea, class_2350.class_2351 axis) {
        class_3341 area = cuboidArea.getArea();
        int axisSize = AreaUtil.blocksOnAxis(area, axis);
        String axisName = axis.method_10174().toUpperCase();
        int min = axis.method_10173(area.method_35415(), area.method_35416(), area.method_35417());
        int max = axis.method_10173(area.method_35418(), area.method_35419(), area.method_35420());
        return ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(class_2561.method_43470((String)(axisName + "=" + axisSize)), class_2561.method_43470((String)(axisName + ": " + min + " - " + max)), class_124.field_1068);
    }

    public static class_5250 buildTextWithHoverAndBracketsMsg(class_5250 text, class_5250 hoverText, class_124 color) {
        class_5250 bracketedText = class_2564.method_10885((class_2561)text);
        return ChatComponentBuilder.buildTextWithHoverMsg(bracketedText, hoverText, color);
    }

    public static class_5250 buildTextWithWhiteBracketsAndHover(class_5250 text, class_5250 hoverText, class_124 color) {
        return class_2564.method_10885((class_2561)ChatComponentBuilder.buildTextWithHoverMsg(text, hoverText, color));
    }

    public static class_5250 buildTextWithHoverMsg(class_5250 text, class_5250 hoverText, class_124 color) {
        text.method_10862(text.method_10866().method_10977(color).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hoverText)));
        return text;
    }

    public static class_5250 buildHelpStartComponent() {
        String command = Commands.buildCommandStr(CommandConstants.GLOBAL.toString(), CommandConstants.INFO.toString());
        class_5250 text = class_2561.method_48321((String)"help.hint.link.text", (String)"Start here");
        class_5250 hover = class_2561.method_48322((String)"help.hint.link.hover", (String)"Use '/%s global info' as a starting point to manage the global region", (Object[])new Object[]{"/yawp"});
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static List<String> getGroupsForRegion(IProtectedRegion region) {
        return Permissions.GROUP_LIST;
    }

    public static int getGroupSize(IProtectedRegion region, String groupName) {
        PlayerContainer group = region.getGroup(groupName);
        return group.getPlayers().size() + group.getTeams().size();
    }

    public static class_5250 buildGroupListHeader(IProtectedRegion region, String group) {
        class_5250 groupLink = ChatLinkBuilder.buildGroupLink(region, group, ChatComponentBuilder.getGroupSize(region, group));
        return ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{groupLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static class_5250 buildGroupTypeHeader(IProtectedRegion region, String group, GroupType groupType) {
        String fallback = "== Region '%s' " + groupType.name + " in %s ==";
        return class_2561.method_48322((String)("cli.msg.info.region.group." + groupType.name + ".list"), (String)fallback, (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region), group});
    }

    public static class_5250 buildFlagStateComponent(IProtectedRegion region, IFlag flag) {
        FlagState state = flag.getState();
        class_5250 text = class_2561.method_43470((String)state.name);
        class_5250 hover = class_2561.method_43473();
        class_124 color = class_124.field_1068;
        switch (state) {
            case ALLOWED: {
                color = class_124.field_1060;
                hover = class_2561.method_48321((String)"cli.flag.state.allowed.info.hover", (String)"A flag with allowed state does not prevent the related action");
                break;
            }
            case DENIED: {
                color = class_124.field_1061;
                hover = class_2561.method_48321((String)"cli.flag.state.denied.info.hover", (String)"A flag with denied state prevents the related action");
                break;
            }
            case DISABLED: {
                color = class_124.field_1080;
                hover = class_2561.method_48321((String)"cli.flag.state.disabled.info.hover", (String)"A disabled flag is not considered in flag checks");
            }
        }
        class_5250 stateInfo = ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(text, hover, color);
        return Messages.substitutable("%s %s", stateInfo, ChatLinkBuilder.buildFlagStateSuggestionLink(region, flag));
    }

    public static class_5250 buildFlagMessageHoverText(IProtectedRegion region, IFlag flag) {
        class_5250 flagMsgText = ChatComponentBuilder.truncateMsg(flag);
        class_5250 hoverText = class_2561.method_43470((String)flag.getFlagMsg().msg());
        if (flag.getFlagMsg().isDefault()) {
            String hoverFallback = "[{region}]: The '{flag}' flag denies this action here!";
            hoverText = class_2561.method_48321((String)("flag.msg.deny." + region.getRegionType().type + ".default"), (String)hoverFallback);
        }
        return ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(flagMsgText, hoverText, class_124.field_1068);
    }

    public static class_5250 truncateMsg(IFlag flag, int length) {
        Object flagMsg = flag.getFlagMsg().msg();
        if (flag.getFlagMsg().msg().length() > length) {
            flagMsg = ((String)flagMsg).substring(0, length) + "...";
        }
        return class_2561.method_43470((String)flagMsg);
    }

    public static class_5250 truncateMsg(IFlag flag) {
        return ChatComponentBuilder.truncateMsg(flag, 30);
    }

    public static class_5250 buildFlagMessageComponent(IProtectedRegion region, IFlag flag) {
        class_5250 editLink = ChatLinkBuilder.buildFlagMessageEditLink(region, flag);
        class_5250 clearLink = ChatLinkBuilder.buildFlagMessageClearLink(region, flag);
        class_5250 flagMsgTextWithHover = ChatComponentBuilder.buildFlagMessageHoverText(region, flag);
        return Messages.substitutable("%s %s '%s'", editLink, clearLink, flagMsgTextWithHover);
    }

    public static List<class_2561> buildRemoveRegionEntries(IProtectedRegion parent, List<IProtectedRegion> regions) {
        return regions.stream().map(region -> ChatComponentBuilder.buildRemoveRegionEntry(parent, region)).collect(Collectors.toList());
    }

    public static class_5250 buildRemoveRegionEntry(IProtectedRegion parent, IProtectedRegion region) {
        return Messages.substitutable(" - %s", switch (parent.getRegionType()) {
            case RegionType.GLOBAL -> Messages.substitutable("%s %s", ChatComponentBuilder.buildDimResetComponent((DimensionalRegion)region), ChatLinkBuilder.buildRegionInfoLink(region));
            case RegionType.DIMENSION -> {
                class_5250 childCompInfo = class_2561.method_48321((String)"cli.msg.info.dim.region.child.hover", (String)"This is a direct child region of the Dimensional Region");
                class_5250 childIndicator = ChatComponentBuilder.buildTextWithHoverAndBracketsMsg(class_2561.method_43470((String)"*"), childCompInfo, class_124.field_1065);
                class_5250 regionInfoLinkWithIndicator = parent.hasChild(region) ? Messages.substitutable("%s%s", ChatLinkBuilder.buildRegionInfoLink(region), childIndicator) : Messages.substitutable("%s", ChatLinkBuilder.buildRegionInfoLink(region));
                class_5250 removeLink = ChatLinkBuilder.buildDimSuggestRegionRemovalLink((IMarkableRegion)region);
                yield Messages.substitutable("%s %s", removeLink, regionInfoLinkWithIndicator);
            }
            case RegionType.LOCAL -> Messages.substitutable("%s %s", ChatLinkBuilder.buildRegionRemoveChildLink(parent, region), ChatLinkBuilder.buildRegionInfoLink(region));
            default -> throw new IllegalArgumentException();
        });
    }

    private static class_5250 buildDimResetComponent(DimensionalRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), CommandConstants.RESET.toString(), CommandConstants.DIM.toString());
        class_5250 hover = class_2561.method_48322((String)"cli.dim.reset.dim.link.hover", (String)"Reset Dimensional Region '%s'", (Object[])new Object[]{region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.action.undo.text", (String)"<-");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11745, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildInfoComponent(String subjectLangKey, String fallback, class_5250 payload) {
        return Messages.substitutable("%s: %s", class_2561.method_48321((String)subjectLangKey, (String)fallback), payload);
    }

    public static class_5250 buildInfoComponent(class_5250 subject, class_5250 info, class_5250 actions) {
        return Messages.substitutable("%s: %s | %s", subject, info, actions);
    }

    public static class_5250 buildInfoComponent(class_5250 subject, class_5250 content) {
        return Messages.substitutable("%s: %s", subject, content);
    }

    public static String buildExecuteCommandString(class_5321<class_1937> dim, String command) {
        return "/execute in " + String.valueOf(dim.method_29177()) + " run " + command;
    }

    public static String buildTeleportCmd(class_5321<class_1937> dim, String tpSource, class_2338 target) {
        return ChatComponentBuilder.buildExecuteCommandString(dim, "tp " + tpSource + " " + ChatComponentBuilder.commandBlockPosStr(target));
    }

    public static List<class_2561> buildRemoveGroupMemberEntries(IProtectedRegion region, List<String> names, GroupType groupType, String group) {
        return names.stream().map(name -> ChatComponentBuilder.buildRemoveGroupEntry(region, name, groupType, group)).collect(Collectors.toList());
    }

    public static class_5250 buildRemoveGroupEntry(IProtectedRegion region, String name, GroupType groupType, String group) {
        class_5250 linkText = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        class_5250 hoverText = class_2561.method_48322((String)("cli.msg.info.region.group." + groupType.name + ".remove.link.hover"), (String)("Remove " + groupType.name + " '%s' from region %s"), (Object[])new Object[]{name, region.getName()});
        if (groupType == GroupType.PLAYER) {
            boolean isOffline;
            class_1657 player = PlayerManager.getPlayer(name);
            boolean bl = isOffline = player == null;
            if (isOffline) {
                class_5250 offlinePlayerRemoveLink = ChatLinkBuilder.buildRemoveLinkForOfflinePlayer(region, name, groupType, group, linkText, hoverText);
                return Messages.substitutable(" - %s %s", offlinePlayerRemoveLink, ChatComponentBuilder.buildGroupInfo(region, name, groupType));
            }
        }
        class_5250 regionRemoveLink = ChatLinkBuilder.buildRemoveGroupMemberLink(region, name, groupType, group, linkText, hoverText);
        return Messages.substitutable(" - %s %s", regionRemoveLink, ChatComponentBuilder.buildGroupInfo(region, name, groupType));
    }

    public static class_5250 buildGroupInfo(IProtectedRegion region, String groupMemberName, GroupType groupType) {
        return switch (groupType) {
            default -> throw new IncompatibleClassChangeError();
            case GroupType.PLAYER -> {
                class_1657 player = PlayerManager.getPlayer(groupMemberName);
                if (player == null) {
                    yield class_2561.method_43469((String)"%s %s", (Object[])new Object[]{class_2561.method_43470((String)groupMemberName).method_27692(class_124.field_1080), class_2561.method_48321((String)"cli.msg.info.player.list.entry.offline", (String)"(offline)")});
                }
                yield ChatComponentBuilder.buildPlayerHoverComponent(player);
            }
            case GroupType.TEAM -> {
                class_270 team = PlayerManager.getTeam(groupMemberName);
                if (team == null) {
                    yield class_2561.method_43470((String)groupMemberName);
                }
                yield ChatComponentBuilder.buildTeamHoverComponent(team);
            }
        };
    }

    public static List<String> getGroupList(IProtectedRegion region, String group, GroupType groupType) {
        switch (groupType) {
            case PLAYER: {
                return ChatComponentBuilder.getPlayerNamesByState(region, group);
            }
            case TEAM: {
                return region.getGroup(group).getTeams().stream().sorted().collect(Collectors.toList());
            }
        }
        return new ArrayList<String>();
    }

    @NotNull
    private static List<String> getPlayerNamesByState(IProtectedRegion region, String group) {
        ArrayList<String> names = new ArrayList<String>(region.getGroup(group).getPlayers().values());
        List<String> onlinePlayerNames = names.stream().map(name -> Map.entry(name, PlayerManager.getPlayer(name) != null)).filter(Map.Entry::getValue).map(Map.Entry::getKey).sorted().toList();
        names.removeAll(onlinePlayerNames);
        List offlinePlayers = names.stream().sorted().toList();
        ArrayList<String> playerNames = new ArrayList<String>(onlinePlayerNames);
        playerNames.addAll(offlinePlayers);
        return playerNames;
    }

    public static class_5250 buildFlagInfoHeader(IProtectedRegion region, IFlag flag) {
        return ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.flag.in", (String)"== Flag %s in %s ==", (Object[])new Object[]{ChatLinkBuilder.buildFlagInfoLink(region, flag), ChatLinkBuilder.buildRegionInfoLink(region)}));
    }
}

