/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.stick.AbstractStick;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.util.LocalRegions;
import de.z0rdak.yawp.util.StickException;
import de.z0rdak.yawp.util.StickType;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class StickUtil {
    private static final String MARKED_BLOCK_INDICATOR = "X";
    private static final String UNMARKED_BLOCK_INDICATOR = "#";
    private static final String TP_POS_INDICATOR = "TP";
    private static final class_124 MARKED_BLOCK_COLOR = class_124.field_1060;
    private static final class_124 UNMARKED_BLOCK_COLOR = class_124.field_1061;
    private static final class_124 UNMARKED_POS_COLOR = class_124.field_1075;

    private StickUtil() {
    }

    public static void applyEnchantmentGlint(class_1799 item) {
        class_2487 dummy = new class_2487();
        dummy.method_10582("id", "");
        dummy.method_10569("lvl", 1);
        class_2499 enchantmentList = new class_2499();
        enchantmentList.add((Object)dummy);
        item.method_7959("Enchantments", (class_2520)enchantmentList);
    }

    public static void initStickTag(class_1799 stick, StickType type, class_5321<class_1937> dim) {
        class_2487 itemTag;
        class_2487 class_24872 = itemTag = stick.method_7985() ? stick.method_7969() : new class_2487();
        if (itemTag != null && Objects.requireNonNull(type) == StickType.MARKER) {
            class_2487 compoundNBT = new MarkerStick(dim).serializeNBT();
            itemTag.method_10566("stick", (class_2520)compoundNBT);
            stick.method_7980(itemTag);
        }
    }

    public static class_1799 initMarkerNbt(class_1799 stack, class_5321<class_1937> dim) {
        stack.method_7939(1);
        StickUtil.initStickTag(stack, StickType.MARKER, dim);
        StickUtil.setStickName(stack, StickType.MARKER);
        StickUtil.setStickToolTip(stack, StickType.MARKER);
        StickUtil.applyEnchantmentGlint(stack);
        return stack;
    }

    public static boolean isVanillaStick(class_1799 itemStack) {
        return itemStack.method_7909().method_7854().method_7922().equals(class_1802.field_8600.method_7876());
    }

    public static AbstractStick getStick(class_1799 stick) throws StickException {
        if (stick.method_7969() != null && stick.method_7985() && stick.method_7969().method_10545("stick")) {
            class_2487 stickNbt = stick.method_7969().method_10562("stick");
            StickType type = StickType.of(stickNbt.method_10558("stick_type"));
            switch (type) {
                case MARKER: {
                    return new MarkerStick(stickNbt);
                }
            }
            throw new StickException("Unknown stick type: '" + String.valueOf((Object)type) + "'!");
        }
        throw new StickException("Invalid or missing NBT data for Stick '" + stick.method_7954().getString() + "'!");
    }

    public static StickType getStickType(class_1799 stick) {
        class_2487 stickNbt;
        if (stick.method_7969() != null && stick.method_7985() && stick.method_7969().method_10545("stick") && (stickNbt = stick.method_7969().method_10562("stick")).method_10545("stick_type")) {
            return StickType.of(stickNbt.method_10558("stick_type"));
        }
        return StickType.UNKNOWN;
    }

    public static class_2487 getStickNBT(class_1799 stick) {
        if (stick.method_7969() != null && stick.method_7985() && stick.method_7969().method_10545("stick")) {
            return stick.method_7969().method_10562("stick");
        }
        return null;
    }

    @Nullable
    public static IMarkableArea getMarkedArea(class_1799 stick) {
        class_2487 stickNBT;
        if (StickUtil.isVanillaStick(stick) && StickUtil.isMarker(stick) && (stickNBT = StickUtil.getStickNBT(stick)) != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            if (!marker.isValidArea()) {
                return null;
            }
            return LocalRegions.areaFrom(marker);
        }
        return null;
    }

    public static boolean isMarker(class_1799 stick) {
        return StickUtil.getStickType(stick) == StickType.MARKER;
    }

    public static void setStickName(class_1799 stick, StickType type) {
        if (Objects.requireNonNull(type) == StickType.MARKER) {
            MarkerStick marker = new MarkerStick(StickUtil.getStickNBT(stick));
            class_5250 markerIndicators = StickUtil.buildRegionMarkerIndicators(marker);
            class_5250 markerHoverName = StickUtil.buildStickName(marker).method_27693(" ").method_10852((class_2561)markerIndicators);
            stick.method_7977((class_2561)markerHoverName);
        }
    }

    private static class_5250 buildStickName(MarkerStick marker) {
        class_5250 stickName = class_2561.method_43470((String)marker.getStickType().stickName).method_27692(class_124.field_1065);
        class_5250 areaType = class_2561.method_43470((String)" (").method_27693(marker.getAreaType().areaType).method_27693(")");
        return stickName.method_10852((class_2561)areaType);
    }

    private static class_5250 buildMarkerIndicator(boolean isMarked) {
        String indicator = isMarked ? MARKED_BLOCK_INDICATOR : UNMARKED_BLOCK_INDICATOR;
        class_124 color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_BLOCK_COLOR;
        class_5250 indicatorComp = class_2561.method_43470((String)indicator).method_27692(color);
        class_5250 closedResetComp = class_2561.method_43470((String)"]").method_27692(class_124.field_1070);
        return class_2561.method_43470((String)"[").method_10852((class_2561)indicatorComp).method_10852((class_2561)closedResetComp);
    }

    private static class_5250 buildRegionMarkerIndicators(MarkerStick marker) {
        int i;
        class_5250 regionMarkerIndicators = class_2561.method_43470((String)"");
        int maxBlocks = marker.getAreaType().maxBlocks;
        int amountUnmarked = maxBlocks - marker.getMarkedBlocks().size();
        for (i = 0; i < marker.getMarkedBlocks().size(); ++i) {
            regionMarkerIndicators.method_10852((class_2561)StickUtil.buildMarkerIndicator(true));
        }
        for (i = 0; i < amountUnmarked; ++i) {
            regionMarkerIndicators.method_10852((class_2561)StickUtil.buildMarkerIndicator(false));
        }
        return regionMarkerIndicators;
    }

    public static void setStickToolTip(class_1799 stick, StickType type) {
        if (Objects.requireNonNull(type) == StickType.MARKER) {
            StickUtil.setToolTip(stick, StickUtil.getMarkerToolTip());
        }
    }

    public static void setToolTip(class_1799 stack, class_2499 loreNbt) {
        stack.method_7911("display").method_10566("Lore", (class_2520)loreNbt);
    }

    public static boolean hasNonNullTag(class_1799 itemStack) {
        return itemStack.method_7985() && itemStack.method_7969() != null;
    }

    private static class_2499 getMarkerToolTip() {
        class_2499 lore = new class_2499();
        lore.add((Object)StickUtil.buildLoreTextLine(class_2561.method_48321((String)"help.tooltip.stick.marker.simple.1", (String)"Used to mark a new region."), "#ff4d4d"));
        lore.add((Object)StickUtil.buildLoreTextLine(class_2561.method_48321((String)"help.tooltip.stick.marker.simple.2", (String)"Keep the Region Marker in your hand while creating a region!"), "#ff4d4d"));
        lore.add((Object)StickUtil.buildLoreTextLine(class_2561.method_43470((String)String.valueOf(class_124.field_1056)).method_10852((class_2561)class_2561.method_48321((String)"help.tooltip.stick.marker.simple.3", (String)"Mark a (Cuboid) region by right-clicking the diagonal opposite corner blocks.")), "#808080"));
        lore.add((Object)StickUtil.buildLoreTextLine(class_2561.method_43470((String)String.valueOf(class_124.field_1056)).method_10852((class_2561)class_2561.method_48321((String)"help.tooltip.stick.marker.simple.4", (String)"Set a region teleport position by shift-right-clicking a block.")), "#808080"));
        return lore;
    }

    private static class_2519 buildLoreTextLine(String text, String hexColor) {
        return class_2519.method_23256((String)("{\"text\":\"" + text + "\", \"color\":\"" + hexColor + "\"}"));
    }

    private static class_2519 buildLoreTextLine(class_5250 text, String hexColor) {
        return StickUtil.buildLoreTextLine(text.getString(), hexColor);
    }
}

