package de.z0rdak.yawp.core.area;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_124;
import net.minecraft.class_2487;

public final class TextDisplayProperties {

    public static int BG_TRANSPARENT = 0x10_00_00_00;

    private String text;
    /**
     * TODO: Enum?
     * {center, left, right} are valid values
     */
    private String alignment;
    /**
     * See: https://minecraft.wiki/w/Display#Data_values
     *  The background color, arranged by ARGB. E.g.: 0x10_00_00_00.
     *  Values of A < 0x14 will be rendered transparent
     */
    private int backgroundColor;
    /**
     * See {@link class_124} for valid values
     */
    private String color;
    private int lightLevel;

    public TextDisplayProperties(String text,  String alignment, int backgroundColor, String color, int lightLevel) {
        this.text = text;
        this.alignment = alignment;
        this.backgroundColor = backgroundColor;
        var colorFormat = class_124.method_533(color);
        this.color = colorFormat == null ? class_124.field_1068.method_537() : colorFormat.method_537();
        this.lightLevel = lightLevel;
    }

    public TextDisplayProperties(String text) {
        this.text = text;
        this.alignment = "center";
        this.backgroundColor = BG_TRANSPARENT;
        this.color = class_124.field_1068.toString();
        this.lightLevel = 15;
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10582("text", this.text);
        tag.method_10582("alignment", this.alignment);
        tag.method_10569("backgroundColor", this.backgroundColor);
        tag.method_10582("color", this.color);
        tag.method_10569("lightLevel", this.lightLevel);
        return tag;
    }

    public static final int DEFAULT_BACKGROUND = 0x1A_00_00_00;

    public void deserializeNBT(class_2487 nbt) {
        this.text = nbt.method_10558("text").get();
        this.alignment = nbt.method_10558("alignment").get();
        this.backgroundColor = nbt.method_10550("backgroundColor").get();
        var colorFormat = class_124.method_533(color);
        this.color = colorFormat == null ? class_124.field_1068.method_537() : colorFormat.method_537();
        this.lightLevel = nbt.method_10550("lightLevel").get();
    }

    public String getText() {
        return text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getAlignment() {
        return alignment;
    }

    public int getBackgroundColor() {
        return backgroundColor;
    }

    public String getColor() {
        return color;
    }

    public int getLightLevel() {
        return lightLevel;
    }
}
